/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.preferences;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessorTemplate;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;


public class SCPreferenceInitializer extends AbstractPreferenceInitializer {
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(SCPreferenceInitializer.class);
    public static final String PROPERTY_KIT_LOCATION = "jaxws_kit_location";

    
    @Override
    public void initializeDefaultPreferences() {
        IPreferenceStore store = ScJaxWsPlugin.getDefault().getPreferenceStore();

        String var = System.getProperty(SCPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT);
        LOG.debug("KitInstall : " + var);

        RuntimeProviderManager mgr = RuntimeProviderManager.getInstance();
        IExtension[] exts = mgr.getAllRegistredProviders();
        for (int i = 0; i < exts.length; i++) {
            String extUID = exts[i].getUniqueIdentifier();
            IRuntimeKitProcessorTemplate kitProcessor = mgr.getRuntimeKitTemplateProcessor(extUID);
            store.setDefault(PreferencesAccessor.resolvePrefKey(SCPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT,
                                                                extUID),
                             var != null ? var : kitProcessor.getDefaultInstallDirectory().toOSString());
        }
        
        store.setDefault(SCPreferenceConstants.KEY_ANN_WIZ_ENABLED,
                         SCPreferenceConstants.VAL_ANN_WIZ_DISABLED);
        
        store.setDefault(SCPreferenceConstants.KEY_SOAP_OPTION, SCPreferenceConstants.KEY_SOAP11);
        
        store.setDefault(SCPreferenceConstants.KEY_MERGE, true);
    }
}
