/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.runtimeintegrator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtimeintegrator.IGeneratorTool;
import org.eclipse.stp.sc.common.runtimeintegrator.IParameterPage;
import org.eclipse.stp.sc.common.runtimeintegrator.RtIntegratorMgr;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.preferences.SCPreferenceConstants;

public class JaxWSRtIntegratorMgr extends RtIntegratorMgr {
    
    public final static String EXT_JAXWS_SERVERTYPE = "jaxws.runtime";
    
    public final static String EXT_TOOLTYPE_WSDL2JAVA = "org.eclipse.stp.sc.jaxws.wsdl2java";
    public final static String EXT_TOOLTYPE_JAVA2WSDL = "org.eclipse.stp.sc.jaxws.java2wsdl";
    
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxWSRtIntegratorMgr.class);

    private static JaxWSRtIntegratorMgr instance;
    
    private JaxWSRtIntegratorMgr(){
    }
    
    public static JaxWSRtIntegratorMgr getInstance() {
        if (instance == null) {
            instance = new JaxWSRtIntegratorMgr();
        }
        return instance;
    }
    
    public IGeneratorTool getWsdltoJavaGenerator(IProject project) throws CoreException{
        String runtimeID = getRuntimeIntegratorID(project);
        return getGeneratorTool(runtimeID, EXT_TOOLTYPE_WSDL2JAVA);
    }
    
    
    

    public IGeneratorTool getJavaToWsdlGenerator(IProject project) throws CoreException{
        String runtimeID = getRuntimeIntegratorID(project);
        return getGeneratorTool(runtimeID, EXT_TOOLTYPE_JAVA2WSDL);
    }
    
    public IRuntimeKitProcessor getRuntimeKitProcessor(IProject project) throws CoreException{
        String runtimeID = getRuntimeIntegratorID(project);
        return getRuntimeKitProcessor(runtimeID);
    }

    public RuntimeKitProcessor getRuntimeKitProcessor(String providerExtUID) throws CoreException {
        return new RuntimeKitProcessor(getKitProcessorTemplate(providerExtUID),
                                       getKitRootFolder(providerExtUID));
    }
    
    public String getDefaultRuntimeIntegratorID() {
        //todo, change to read from preference page later
        String id = "org.eclipse.stp.sc.cxf.runtimeintegrator";
        LOG.debug("defualt runtime integrator for JAXWS:" + id);
        return id;
    }

//    private String getRuntimeProviderUID(IProject aProject){
//        try {
//            
//            if (ScNature.hasNature(aProject)) {
//                ScNature theNature = new ScNature();
//                theNature.setProject(aProject);
//                String providerUID = theNature.getRuntimeProviderUID();
//                if (providerUID == null) {
//                    String pickedProviderId = pickAProvider();
//                    theNature.setRuntimeProviderId(pickedProviderId);
//                    return pickedProviderId;
//                }
//                return providerUID;
//            }
//        } catch (CoreException e) {
//            // project not accessible
//            return null;
//        }
//        return null;
//    }
    
//    public String pickAProvider() {
//        IExtension[] allRegistredProviders = getAllRegistredProviders();
//        int numberOfRegistredProviders = allRegistredProviders.length;
//        return numberOfRegistredProviders < 1 
//                ? null 
//                : numberOfRegistredProviders == 1 
//                    ? allRegistredProviders[0].getUniqueIdentifier()
//                    : promptUserToPickAProvider(allRegistredProviders);
//    }
//
//    private String promptUserToPickAProvider(IExtension[] allRegistredProviders) {
//        
//        
//        ListDialog dialog = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
//        dialog.setContentProvider(new ArrayContentProvider());
//        
//        dialog.setTitle(ScJaxWsResources.getString("RuntimeProvider.dialog.title"));
//        dialog.setMessage(ScJaxWsResources.getString("RuntimeProvider.dialog.message"));
//        
//        dialog.setLabelProvider(new LabelProvider() {
//                public String getText(Object element) {
//                    if (element instanceof IExtension) {
//                        return ((IExtension)element).getLabel();
//                    }
//                    return null;
//                }
//            });
//
//        dialog.setBlockOnOpen(true);
//        dialog.open();
//        
//        Object[] result = dialog.getResult();
//        
//        if (result.length > 0) {
//            ((IExtension)result[0]).getUniqueIdentifier();
//        }
//        
//        return null;
//
//    }

//    public IExtension getExtension(String ID){
//        IExtensionRegistry reg = Platform.getExtensionRegistry();
//        return reg.getExtension(EXT_POINT_SC_RUNTIME_PROVIDER, ID);
//    }
    
//    public IExtension[] getAllRegistredProviders() {
//        IExtensionRegistry reg = Platform.getExtensionRegistry();
//        return reg.getExtensionPoint(EXT_POINT_SC_RUNTIME_PROVIDER).getExtensions();
//    }

//    private IWsdlToJavaGenerator getWsdltoJavaGenerator(String ID){
//        IConfigurationElement[] extElts = getExtension(ID).getConfigurationElements();
//        
//        for (int extIndex = 0; extIndex < extElts.length; extIndex++) {
//            IConfigurationElement cfgElt = extElts[extIndex];
//            if (cfgElt.getName().equals(EXT_ELT_SC_W2J_GEN)) {
//                try {
//                    Object kitProcessorObj = cfgElt.createExecutableExtension(EXT_ATT_SC_W2J_GEN_CLASS);
//                    if (kitProcessorObj instanceof IWsdlToJavaGenerator) {
//                        return (IWsdlToJavaGenerator)kitProcessorObj;
//                    }
//                    LOG.error(getLogErrMsgWrongClassType(ID,
//                                                         EXT_ATT_SC_PROCESSOR_CLASS,
//                                                         IWsdlToJavaGenerator.class));
//                } catch (CoreException e) {
//                    LOG.error(getLogErrMsgNotCLass(ID, EXT_ATT_SC_PROCESSOR_CLASS), e);
//                }
//                return null;
//            }
//        }
//        return null;
//    }
//
//    private IJavaToWsdlGenerator getJavaToWsdlGenerator(String ID){
//        IConfigurationElement[] extElts = getExtension(ID).getConfigurationElements();
//        
//        for (int extIndex = 0; extIndex < extElts.length; extIndex++) {
//            IConfigurationElement cfgElt = extElts[extIndex];
//            if (cfgElt.getName().equals(EXT_ELT_SC_J2W_GEN)) {
//                try {
//                    Object kitProcessorObj = cfgElt.createExecutableExtension(EXT_ATT_SC_J2W_GEN_CLASS);
//                    if (kitProcessorObj instanceof IJavaToWsdlGenerator) {
//                        return (IJavaToWsdlGenerator)kitProcessorObj;
//                    }
//                    LOG.error(getLogErrMsgWrongClassType(ID,
//                                                         EXT_ATT_SC_PROCESSOR_CLASS,
//                                                         IJavaToWsdlGenerator.class));
//                } catch (CoreException e) {
//                    LOG.error(getLogErrMsgNotCLass(ID, EXT_ATT_SC_PROCESSOR_CLASS), e);
//                }
//                return null;
//            }
//        }
//        return null;
//    }
//    
//    public IRuntimeKitProcessorTemplate getRuntimeKitTemplateProcessor(String uniqueIdentifier){
//        IConfigurationElement[] extElts = getExtension(uniqueIdentifier).getConfigurationElements();
//        
//        for (int extIndex = 0; extIndex < extElts.length; extIndex++) {
//            IConfigurationElement cfgElt = extElts[extIndex];
//            if (cfgElt.getName().equals(EXT_ELT_SC_KIT_PROCESSOR)) {
//                try {
//                    Object kitProcessorObj = cfgElt.createExecutableExtension(EXT_ATT_SC_PROCESSOR_CLASS);
//                    if (kitProcessorObj instanceof IRuntimeKitProcessorTemplate) {
//                        return (IRuntimeKitProcessorTemplate)kitProcessorObj;
//                    }
//                    LOG.error(getLogErrMsgWrongClassType(uniqueIdentifier,
//                                                         EXT_ATT_SC_PROCESSOR_CLASS,
//                                                         IRuntimeKitProcessorTemplate.class));
//                } catch (CoreException e) {
//                    LOG.error(getLogErrMsgNotCLass(uniqueIdentifier, EXT_ATT_SC_PROCESSOR_CLASS), e);
//                }
//                return null;
//            }
//        }
//        return null;
//    }
    
    /*private String getLogErrMsgNotCLass(String extId, String attributeName) {
        // this msg is intended for the logs, no point to use resources bundles for this
        return "the 'IRuntimeKitProcessor' could not be instanciated from the extension "
                      + extId 
                      + ". check value of the attribute '"
                      + attributeName 
                      + "'";
    }*/

//    private String getLogErrMsgWrongClassType(String extId,
//                                                     String attributeName,
//                                                     Class superClass) {
//        // this msg is intended for the logs, no point to use resources bundles for this
//        return "the class specified in the attribute '"
//                  + attributeName 
//                  + "' of the extension '"
//                  + extId
//                  + "' does not extend the interface '"
//                  + superClass.getCanonicalName()
//                  + "'";
//    }

    private IPath getKitRootFolder(String providerExtUID) {
        String kitPath = PreferencesAccessor.getKitInstallLocation(providerExtUID);
    
        if ((kitPath == null) || kitPath.equals("")) {
            kitPath = System.getProperty(SCPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT); //test support
        }
    
        return new Path(kitPath);
    }

    /**
     * get parameter page for wsdl2java tool
     * @param id
     * @return
     * @throws CoreException 
     */
    public IParameterPage getParameterPage(String runtimeId) throws CoreException {
        return getParameterPage(runtimeId, EXT_TOOLTYPE_WSDL2JAVA);
    }
    
	public IParameterPage getParameterPage(IProject project) throws CoreException {
        return getParameterPage(project, EXT_TOOLTYPE_WSDL2JAVA);
	}
}
