/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;

import java.io.File;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.sc.common.utils.FileUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

/**
 * @author jma
 *
 */
public class WsdlSettingPage extends WizardPage {

	protected WsdlSelectionComposite composite;
	protected WsdlSettingPage(String pageName) {
		super(pageName);
        setTitle(ScJaxWsResources.getString("WsdlSettingPage.Title"));
	    setDescription(ScJaxWsResources.getString("WsdlSettingPage.Description"));
	    ImageDescriptor banner = ScJaxWsResources.getImageDescriptor("wizban/jaxws_project_folder_wiz.jpg");
	    setImageDescriptor(banner);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		composite = new WsdlSelectionComposite(parent, 
				SWT.NULL, this);
		this.setControl(composite);
		setPageComplete(false);
	}
	
	public boolean validatePage() {
		setMessage(null);
		setErrorMessage(null);
		if (composite.rbtLocalFile.getSelection()) {
			if (composite.txtFilePath.getText() != null &&
			    !composite.txtFilePath.getText().equals("") &&
			    validateWSDLFilePath(composite.txtFilePath.getText()) &&
			    !composite.txtWsdl.getText().equals("")) {
				    return true;
		    }
		} else {
            if (composite.txtUrl.getText() != null && 
                !composite.txtUrl.getText().equals("") && 
                !composite.txtWsdl.getText().equals("")) {
                    return true;
                }    
        }
		return false;
	}
	
	private boolean validateWSDLFilePath(String filePath){
		if(filePath != null){
			if(filePath.toLowerCase().endsWith(".wsdl")){
				IPath path = new Path(filePath);
				File file = path.toFile();
				if(file.exists()){
					composite.txtWsdl.setText(FileUtils.getFileContent(filePath));
					return true;
				}
			}
		}
		return false;
	}
	

	public boolean canFlipToNextPage(){
		if(!composite.cbtGenCode.getSelection())
			return false;
		return super.canFlipToNextPage();
	}
	
	public boolean IsGenCode()
	{
		return composite.cbtGenCode.getSelection();
	}

}
