/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.sca.java.workspace;


import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.AbstractNature;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.sca.java.ScaJavaPlugin;
import org.eclipse.stp.sc.sca.java.ScaJavaResources;
import org.eclipse.stp.sc.sca.java.builders.JarBuilder;
import org.eclipse.stp.sc.sca.java.builders.ScaJavaToWsdlBuilder;
import org.eclipse.stp.sc.sca.java.preferences.ScaJavaPreferenceConstants;

/**
 * @author jma
 *
 */
public class ScaJavaNature extends AbstractNature {

	public static final String SCA_KIT_LOCATION = "sca_kit_location";
	static String SCA_NATURE_ID = "org.eclipse.stp.sc.sca.java.nature";
	private static final LoggingProxy LOG = LoggingProxy.getlogger(ScaJavaNature.class);
	
	private IProject theProject; 
	
	
	public IProject getProject() {
        return theProject;
    }

    public void setProject(IProject value) {
        this.theProject = value;
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.stp.sc.common.workspace.AbstractNature#getNatureID()
	 */
	@Override
	public String getNatureID() {
		return SCA_NATURE_ID;
	}
	
	public void configure() throws CoreException {
		super.configure();
		WorkspaceManager.addBuilder(theProject, ScaJavaToWsdlBuilder.BUILDER_ID, 
        		WorkspaceManager.BuilderOrder.LAST);
		WorkspaceManager.addBuilder(theProject, JarBuilder.BUILDER_ID, 
				WorkspaceManager.BuilderOrder.LAST);
    }

    public void deconfigure() throws CoreException {
    	super.deconfigure();
    	WorkspaceManager.removeBuilder(theProject, JarBuilder.BUILDER_ID);
    	WorkspaceManager.removeBuilder(theProject, ScaJavaToWsdlBuilder.BUILDER_ID);
    }


	public void addToProject(IProject project) throws CoreException {
		
        addToProject(JavaCore.create(project));
        super.addToProject(project);
    }
	
	public void addToProject(IJavaProject jproject) throws CoreException {
        IProject project = jproject.getProject();
        //TODO:decoupling the runtime
        if (!project.hasNature(SCA_NATURE_ID)) {
            
        	IPreferenceStore preferenceStore = ScaJavaPlugin.getDefault()
			    .getPreferenceStore();
        	String kitPath = preferenceStore.getString(ScaJavaPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT);
            if (kitPath == null || kitPath.equals("")) {
            	if (System.getProperty(SCA_KIT_LOCATION) != null) {
            		kitPath = System.getProperty(SCA_KIT_LOCATION);
            	} else {
                    MessageDialog.openWarning(null,
                        ScaJavaResources.getString("sca.warning.title"),
                        ScaJavaResources.getString("sca.missing.install.text"));
                    return;
            	}
            }

            // complete the build path based on the kit used
            LOG.debug("adding libraries to project");
            completeJavaProjectBuildPath(jproject, kitPath);
        }
    }
	
	private String getSubstitutionVarName() {
		return "Tuscany_Lib";
	}
	
	public IPath getKitRootDirectory(IProject prj) {
    	IPath kitPath = null;
    	String kitVar = null;
    	IPreferenceStore preferenceStore = ScaJavaPlugin.getDefault()
            .getPreferenceStore();
        kitVar = preferenceStore.getString(ScaJavaPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT);
    	if (kitVar != null && (!kitVar.trim().equals(""))) {
    		kitPath = new Path(kitVar);
    	}
    	return kitPath;
    }

	/*
	private String registerInstallVarWithJavaProject(IJavaProject jProject) throws CoreException {
        String projectSubstitutionVarName = getSubstitutionVarName() + "_" + jProject.getProject().getName();
        
//        JavaCore.setClasspathVariable(projectSubstitutionVarName,
//        		getKitRootDirectory(jProject.getProject()), 
//        		null);
        return projectSubstitutionVarName;
    }
	*/
	
	private static final char SEP = IPath.SEPARATOR;

    private static final IPath LIBS_PATH = new Path(SEP + "lib" + SEP);

    
	public List<IPath> getDefaultBuildPathEntries(IProject project) {
		List<IPath> libPaths = new ArrayList<IPath>();
		
		IPreferenceStore preferenceStore = ScaJavaPlugin.getDefault()
            .getPreferenceStore();
        String kitLoc = preferenceStore.getString(ScaJavaPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT);

		LOG.debug("kit location: " + kitLoc);

		if (kitLoc != null) {
 		    String[] cxfLibs = new String[]{"sca-api-r0.95-1.0-incubator-M2.jar",
 		    		"tuscany-api-1.0-incubator-M2.jar"};

            for (int i = 0; i < cxfLibs.length; ++i) {
                try {
                    libPaths.add(LIBS_PATH.append(cxfLibs[i]));
                } catch (Exception e) {
                    // lib name was probably incorrect, so ignore it and move to the next
                    LOG.debug("build path entry invalid: " + cxfLibs[i], e); 
                }
            }
		}
		
        return libPaths;
    }

	
	private void completeJavaProjectBuildPath(IJavaProject jProject, String kitPath) {
		try {
			
		String projectSubstitutionVarName = getKitRootDirectory(jProject.getProject()).toOSString();
			
		List<IPath> pathList = getDefaultBuildPathEntries(jProject.getProject()); 
		
    
		List<IClasspathEntry> entries = WorkspaceManager.convertFilesToPathEnries(
				pathList, projectSubstitutionVarName);
		WorkspaceManager.addEntriesToClassPath(jProject, 
				entries);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void removeFromProject(IProject project) throws CoreException {
		super.removeFromProject(project);
        if (project.hasNature(JavaCore.NATURE_ID)) {
            IJavaProject javaProject = JavaCore.create(project);
            removeFromProject(javaProject);
        }
    }

    public void removeFromProject(IJavaProject jproject) throws CoreException {
        // clean the build path based on the kit used
        clearJavaProjectBuildPath(jproject);
    }
    
    private static void clearJavaProjectBuildPath(IJavaProject javaProject) {
    	//TODO, remove build path once the sca java has been removed
    	
    }

}
