/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.core.runtime.IStatus;

import org.eclipse.datatools.connectivity.IConnectionProfile;

/**
 * This is the base interface for accessing deployment functionality on a server.
 * This interface must be implemented by all deployment extensions.
 * 
 * @author rcernich
 *
 * Created on Jan 15, 2004
 */
public interface IDeploySession {
	
	/**
	 * Returns the connection profile used to create this session.
	 * 
	 * @return the profile used to create this session
	 */
	IConnectionProfile getConnectionProfile();
	
	/**
	 * @return the version of this server.
	 */
	IVersion getServerVersion();
	
	/**
	 * @param descriptor
	 * @return
	 */
	IStatus[] preDeployCheck(IPackageOutputDescriptor descriptor);
	
	
	
	/**
	 * @param descriptor
	 * @return
	 */
	IStatus[] preUndeployCheck(IPackageOutputDescriptor descriptor);
	/**
	 * Deploys the package defined by the descriptor to the server.
	 * 
	 * @param descriptor the package being deployed
	 * @throws Exception
	 * RJC: improve exception definition
	 */
	void deploy(IPackageOutputDescriptor descriptor) throws Exception;
	
	
	/**
	 * Undeploy the package from the server
	 * @param descriptor the package being deployed
	 * @throws Exception
	 */
	void undeploy(IPackageOutputDescriptor descriptor) throws Exception;
	/**
	 * Disposes of this deploy session.  At this time, the session should
	 * release any resources it may have allocated during deployment operations.
	 */
	void dispose();
}
