/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;


/**
 * @author shongxum
 */
public class Version implements IVersion {

	public static final Version NULL_VERSION = new Version(
			org.eclipse.datatools.connectivity.Version.NULL_VERSION);

	private org.eclipse.datatools.connectivity.Version mVersion;

	public static Version valueOf(String version) {
		return valueOf(org.eclipse.datatools.connectivity.Version.valueOf(version));
	}

	public static Version valueOf(org.eclipse.datatools.connectivity.Version version) {
		if (version == org.eclipse.datatools.connectivity.Version.NULL_VERSION) {
			return NULL_VERSION;
		}
		return new Version(version);
	}

	public Version(int major, int minor, int release, String build) {
		mVersion = new org.eclipse.datatools.connectivity.Version(major, minor,
				release, build);
	}

	private Version(org.eclipse.datatools.connectivity.Version version) {
		mVersion = version;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.datatools.connectivity.IVersion#getMajor()
	 */
	public int getMajor() {
		return mVersion.getMajor();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.datatools.connectivity.IVersion#getMinor()
	 */
	public int getMinor() {
		return mVersion.getMinor();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.datatools.connectivity.IVersion#getRelease()
	 */
	public int getRelease() {
		return mVersion.getRelease();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.datatools.connectivity.IVersion#getBuild()
	 */
	public String getBuild() {
		return mVersion.getBuild();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		return mVersion.compareTo(((Version) o).mVersion);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		boolean retVal;
		if (obj instanceof Version) {
			retVal = compareTo(obj) == 0;
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	public boolean isCompatibleWithVersion(IVersion actual, MatchRule matchRule) {
		boolean retVal;
		if (matchRule == MatchRule.PERFECT) {
			retVal = comparePerfect(actual);
		}
		else if (matchRule == MatchRule.EQUIVALENT) {
			retVal = compareEquivalent(actual);
		}
		else if (matchRule == MatchRule.COMPATIBLE) {
			retVal = compareCompatible(actual);
		}
		else if (matchRule == MatchRule.EQUAL_OR_GREATER) {
			retVal = compareEqualOrGreater(actual);
		}
		else {
			throw new IllegalArgumentException();
		}
		return retVal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return mVersion.hashCode();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return mVersion.toString();
	}

	private boolean comparePerfect(IVersion actual) {
		return getMajor() == actual.getMajor()
				&& getMinor() == actual.getMinor()
				&& getRelease() == actual.getRelease()
				&& getBuild().compareTo(actual.getBuild()) == 0;
	}

	private boolean compareEquivalent(IVersion actual) {
		boolean retVal;
		if (getMajor() == actual.getMajor()) {
			if (getMinor() == actual.getMinor()) {
				if (getRelease() == actual.getRelease()) {
					retVal = getBuild().compareTo(actual.getBuild()) <= 0;
				}
				else {
					retVal = getRelease() < actual.getRelease();
				}
			}
			else {
				retVal = false;
			}
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	private boolean compareCompatible(IVersion actual) {
		boolean retVal;
		if (getMajor() == actual.getMajor()) {
			if (getMinor() == actual.getMinor()) {
				if (getRelease() == actual.getRelease()) {
					retVal = getBuild().compareTo(actual.getBuild()) <= 0;
				}
				else {
					retVal = getRelease() < actual.getRelease();
				}
			}
			else {
				retVal = getMinor() < actual.getMinor();
			}
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	private boolean compareEqualOrGreater(IVersion actual) {
		boolean retVal;
		if (getMajor() == actual.getMajor()) {
			if (getMinor() == actual.getMinor()) {
				if (getRelease() == actual.getRelease()) {
					retVal = getBuild().compareTo(actual.getBuild()) <= 0;
				}
				else {
					retVal = getRelease() < actual.getRelease();
				}
			}
			else {
				retVal = getMinor() < actual.getMinor();
			}
		}
		else {
			retVal = getMajor() < actual.getMajor();
		}
		return retVal;
	}

}