/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IDeployDriverExtension;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CreatePackageFileActionDelegate implements IObjectActionDelegate, IWorkbenchWindowActionDelegate {

	protected IStructuredSelection _selection = null;
	private Shell _shell;

	/**
	 * Constructor for CreatePackageFileAction.
	 */
	public CreatePackageFileActionDelegate() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		if (targetPart != null) {
			_shell = targetPart.getSite().getShell();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate2#runWithEvent(org.eclipse.jface.action.IAction,
	 *      org.eclipse.swt.widgets.Event)
	 */
	public void runWithEvent(IAction action, Event event) {
		run(action);
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(Event event) {
		run((IAction) null);
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		ILogicalPackage thePackage = null;
		if (_selection == null) {
			return;
		}
		if (_selection.getFirstElement() instanceof ILogicalPackage) {
			thePackage = (ILogicalPackage) _selection.getFirstElement();
		}
		else if (_selection.getFirstElement() instanceof IFile) {
			thePackage = DeploymentExtensionManager.getInstance()
					.getLogicalPackage((IFile) _selection.getFirstElement());
		}
		else {
			return;
		}

		ArrayList constructors = new ArrayList();
		for (Iterator drvIt = DeploymentExtensionManager.getInstance()
				.getDeployDrivers().iterator(); drvIt.hasNext();) {
			IDeployDriverExtension driver = (IDeployDriverExtension) drvIt
					.next();
			for (Iterator ctorIt = driver.getPackageConstructors().iterator(); ctorIt
					.hasNext();) {
				IPackageConstructorExtension ipce = (IPackageConstructorExtension) ctorIt
						.next();
				if (ipce.supportsPackage(thePackage)) {
					constructors.add(ipce);
				}
			}
		}
		if (constructors.size() == 0) {
			MessageDialog.openInformation(_shell, DeployCorePlugin
					.getDefault().getResourceString(
							"CreatePackageFileAction.NoConstructors.TITLE"), //$NON-NLS-1$                
					DeployCorePlugin.getDefault().getResourceString(
							"CreatePackageFileAction.NoConstructors.MESSAGE")); //$NON-NLS-1$
			return;
		}
		IPackageConstructorExtension packageConstructor = null;

		if (constructors.size() == 1) {
			packageConstructor = (IPackageConstructorExtension) constructors
					.get(0);
		}
		else {
			PackageConstructorDialog dialog = new PackageConstructorDialog(
					_shell, thePackage);
			if (dialog.open() == Window.OK
					&& dialog.getSelectedPackageConstructor() != null) {
				packageConstructor = dialog.getSelectedPackageConstructor();
			}
		}
		if (packageConstructor != null) {
			new CreatePackageFileAction(new String(), thePackage,
					packageConstructor, null).run();
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			_selection = (IStructuredSelection) selection;
		}
	}

    public void dispose() {
        // TODO Auto-generated method stub
        
    }

    public void init(IWorkbenchWindow window) {
        // TODO Auto-generated method stub
        
    }

}
