/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class FilterDecorationsAction
extends AbstractActionHandler {
    public static final String ID = "FilterDecorationsAction";

    public FilterDecorationsAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    public FilterDecorationsAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public void init() {
        this.setId(ID);
        this.setDescription("Hide or shows decorations");
        this.setToolTipText(this.getDescription());
        this.setText(this.getDescription());
        super.init();
        this.setEnabled(true);
        this.refresh();
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        boolean b = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS);
        BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().setValue(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS, !b);
        this.refresh();
        RootEditPart part = ((IGraphicalEditPart)this.getStructuredSelection().getFirstElement()).getRoot();
        part.refresh();
        this.recursiveRefresh((EditPart)part);
    }

    private void recursiveRefresh(EditPart part) {
        for (Object child : part.getChildren()) {
            ((EditPart)child).refresh();
            this.recursiveRefresh((EditPart)child);
        }
    }

    public void refresh() {
        if (this.getSelection().isEmpty() || !(this.getSelection() instanceof IStructuredSelection) || !(((IStructuredSelection)this.getSelection()).getFirstElement() instanceof EditPart)) {
            return;
        }
        boolean b = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS);
        if (b) {
            this.setText("Show unfiltered decorations");
            this.setDescription(this.getText());
            this.setToolTipText(this.getText());
            this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/showDecorations.gif"));
        } else {
            this.setText("Hide all decorations");
            this.setDescription(this.getText());
            this.setToolTipText(this.getText());
            this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/hideDecorations.gif"));
        }
        this.setEnabled(true);
    }
}

