/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.MessagingEdge;

public class MessagingEdgeConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof MessagingEdge && (ctx.getFeature() == null || ctx.getFeature().getFeatureID() == 11)) {
            MessagingEdge edge = (MessagingEdge)ctx.getTarget();
            Activity source = edge.getSource();
            Activity target = edge.getTarget();
            if (source == null || target == null) {
                return ctx.createSuccessStatus();
            }
            switch (source.getActivityType().getValue()) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (((FeatureMap.Entry)source.getOrderedMessages().get(0)).getValue() != edge) break;
                    return ctx.createFailureStatus(new Object[]{"Intermediate events should not be the source of a messaging flow, unless they are replying to a previous messaging flow "});
                }
                case 2: 
                case 3: 
                case 4: {
                    if (((FeatureMap.Entry)source.getOrderedMessages().get(0)).getValue() != edge) break;
                    return ctx.createFailureStatus(new Object[]{"Start events should not be the source of a messaging flow, unless they are replying to a previous messaging flow "});
                }
            }
            switch (target.getActivityType().getValue()) {
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    if (((FeatureMap.Entry)target.getOrderedMessages().get(0)).getValue() != edge) break;
                    return ctx.createFailureStatus(new Object[]{"End events should not be the target of a messaging flow, unless they are receiving the reply of the messaging flow they sent"});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

