/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.edit.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ChangeSCAObjectNameOperation
extends AbstractScribblerOperation {
    private String oldName = null;
    private String newName = null;

    public ChangeSCAObjectNameOperation() {
    }

    public ChangeSCAObjectNameOperation(IDataModel model) {
        super(model);
    }

    protected IStatus doExecute(IProgressMonitor monitor) throws ExecutionException {
        SCAObject scaObject = (SCAObject)this.model.getProperty("IChangeSCAObjectNameDataModelProperties.SCAOBJECT");
        Assert.isNotNull((Object)scaObject);
        this.oldName = scaObject.getName();
        this.newName = this.model.getStringProperty("IChangeSCAObjectNameDataModelProperties.NEW_NAME");
        if (!this.newName.equals(this.oldName)) {
            scaObject.setName(this.newName);
        }
        return OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
        SCAObject scaObject = (SCAObject)this.model.getProperty("IChangeSCAObjectNameDataModelProperties.SCAOBJECT");
        scaObject.setName(this.newName);
        return OK_STATUS;
    }

    protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
        SCAObject scaObject = (SCAObject)this.model.getProperty("IChangeSCAObjectNameDataModelProperties.SCAOBJECT");
        scaObject.setName(this.oldName);
        return OK_STATUS;
    }
}

