/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import java.util.ArrayList;
import javax.jws.WebMethod;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import junit.framework.TestCase;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.utils.JaxBindAnnotationUtils;

public class JaxBindAnnotationUtilsTest
extends TestCase {
    CompilationUnit astRoot = null;

    protected void setUp() throws Exception {
        ASTParser parser = ASTParser.newParser((int)3);
        String content = "";
        parser.setSource(content.toCharArray());
        this.astRoot = (CompilationUnit)parser.createAST(null);
    }

    public void testGetAnnotationImport() throws Exception {
        ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
        MemberValuePair valPair = JDTUtils.newMemberValuePair((CompilationUnit)this.astRoot, (String)"name", (Object)"namevalue");
        annotValues.add(valPair);
        ArrayList<MemberValuePair> annotValues3 = new ArrayList<MemberValuePair>();
        MemberValuePair valPair3 = JDTUtils.newMemberValuePair((CompilationUnit)this.astRoot, (String)"name", (Object)"namevalue");
        annotValues3.add(valPair3);
        NormalAnnotation annotation = JDTUtils.newNormalAnnotation((CompilationUnit)this.astRoot, (String)XmlRootElement.class.getSimpleName(), annotValues3);
        JaxBindAnnotationUtilsTest.assertEquals((String)"javax.xml.bind.annotation.XmlRootElement", (String)JaxBindAnnotationUtils.getAnnotationImport((Annotation)annotation));
        ArrayList<MemberValuePair> annotValues4 = new ArrayList<MemberValuePair>();
        MemberValuePair valPair4 = JDTUtils.newMemberValuePair((CompilationUnit)this.astRoot, (String)"name", (Object)"namevalue");
        annotValues4.add(valPair4);
        annotation = JDTUtils.newNormalAnnotation((CompilationUnit)this.astRoot, (String)XmlAccessorType.class.getSimpleName(), annotValues4);
        JaxBindAnnotationUtilsTest.assertEquals((String)"javax.xml.bind.annotation.XmlAccessorType", (String)JaxBindAnnotationUtils.getAnnotationImport((Annotation)annotation));
        ArrayList<MemberValuePair> annotValues5 = new ArrayList<MemberValuePair>();
        MemberValuePair valPair5 = JDTUtils.newMemberValuePair((CompilationUnit)this.astRoot, (String)"name", (Object)"namevalue");
        annotValues5.add(valPair5);
        annotation = JDTUtils.newNormalAnnotation((CompilationUnit)this.astRoot, (String)XmlElement.class.getSimpleName(), annotValues5);
        JaxBindAnnotationUtilsTest.assertEquals((String)"javax.xml.bind.annotation.XmlElement", (String)JaxBindAnnotationUtils.getAnnotationImport((Annotation)annotation));
        ArrayList<MemberValuePair> annotValues6 = new ArrayList<MemberValuePair>();
        MemberValuePair valPair6 = JDTUtils.newMemberValuePair((CompilationUnit)this.astRoot, (String)"name", (Object)"namevalue");
        annotValues6.add(valPair6);
        annotation = JDTUtils.newNormalAnnotation((CompilationUnit)this.astRoot, (String)XmlType.class.getSimpleName(), annotValues6);
        JaxBindAnnotationUtilsTest.assertEquals((String)"javax.xml.bind.annotation.XmlType", (String)JaxBindAnnotationUtils.getAnnotationImport((Annotation)annotation));
        ArrayList<MemberValuePair> annotValues2 = new ArrayList<MemberValuePair>();
        MemberValuePair valPair2 = JDTUtils.newMemberValuePair((CompilationUnit)this.astRoot, (String)"name", (Object)"namevalue");
        annotValues2.add(valPair2);
        NormalAnnotation webMethodAnn = JDTUtils.newNormalAnnotation((CompilationUnit)this.astRoot, (String)WebMethod.class.getSimpleName(), annotValues2);
        JaxBindAnnotationUtilsTest.assertNull((Object)JaxBindAnnotationUtils.getAnnotationImport((Annotation)webMethodAnn));
    }

    public void testNewXmlAccessorTypeAnnotation() throws Exception {
        SingleMemberAnnotation ann = JaxBindAnnotationUtils.newXmlAccessorTypeAnnotation((CompilationUnit)this.astRoot, (Expression)this.astRoot.getAST().newSimpleName("test"));
        JaxBindAnnotationUtilsTest.assertNotNull((Object)ann);
    }

    public void testNewXmlElementAnnotation() throws Exception {
        NormalAnnotation ann = JaxBindAnnotationUtils.newXmlElementAnnotation((CompilationUnit)this.astRoot, (String)"name", null, (String)"ns", null, null);
        JaxBindAnnotationUtilsTest.assertNotNull((Object)ann);
    }

    public void testNewXmlRootElementAnnotation() throws Exception {
        NormalAnnotation ann = JaxBindAnnotationUtils.newXmlRootElemntAnnotation((CompilationUnit)this.astRoot, (String)"root");
        JaxBindAnnotationUtilsTest.assertNotNull((Object)ann);
    }

    public void testNewXmlTypeAnnotation() throws Exception {
        NormalAnnotation ann = JaxBindAnnotationUtils.newXmlTypeAnnotation((CompilationUnit)this.astRoot, (String)"namevalue", (String[])new String[]{"test1", "test2"});
        JaxBindAnnotationUtilsTest.assertNotNull((Object)ann);
    }
}

