/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.lang.reflect.InvocationTargetException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.wizards.WebServiceProjectWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class WebServiceProjectWizardTest
extends TestCase {
    private static String TEST_PROJECT_NAME = "JAXWS-JavaFirst-TestProject";

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        if (proj.exists()) {
            proj.delete(true, null);
        }
    }

    public void testAddPages() throws Exception {
        WebServiceProjectWizard wizard = new WebServiceProjectWizard();
        wizard.init(PlatformUI.getWorkbench(), null);
        WebServiceProjectWizardTest.assertTrue((boolean)wizard.needsProgressMonitor());
        wizard.addPages();
        int count = wizard.getPageCount();
        WebServiceProjectWizardTest.assertEquals((String)"should have 1 pages", (int)1, (int)count);
    }

    public void testCreateJavaFirstProject() throws Exception {
        MyWebServiceProjectWizard wizard = new MyWebServiceProjectWizard();
        wizard.addPages();
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardNewProjectCreationPage genPage = (WizardNewProjectCreationPage)wizard.getPage("generalPage");
        genPage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        try {
            wizard.publicCreateProject();
        }
        catch (Exception e) {
            e.printStackTrace();
            WebServiceProjectWizardTest.fail((String)e.getMessage());
        }
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WebServiceProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        WebServiceProjectWizardTest.assertTrue((String)"should have jax-ws nature", (boolean)proj.hasNature("org.eclipse.stp.sc.jaxws.nature"));
        WebServiceProjectWizardTest.assertTrue((String)"should has j2w builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.jaxws.builders.javatowsdlbuilder"));
        WebServiceProjectWizardTest.assertTrue((String)"should has ann validatation builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.annvalidator"));
        String mode = proj.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE);
        WebServiceProjectWizardTest.assertNotNull((Object)mode);
        WebServiceProjectWizardTest.assertTrue((String)"should set to java first mode.", (boolean)mode.equals("JavaFrist"));
    }

    class MyWebServiceProjectWizard
    extends WebServiceProjectWizard {
        MyWebServiceProjectWizard() {
        }

        public boolean publicCreateProject() throws InvocationTargetException {
            return super.createProject(null);
        }
    }
}

