/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations.webservice;

import javax.jws.WebService;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.annotations.AnnotationAttributePage;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webservice.CreateWebServiceWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateWebServiceWizardTest
extends TestCase {
    private static final String TEST_PROJECT_NAME = "CreateWebServiceWizardTestProject";
    private static final String LOCAL_JAVA = "MyWebService.java";
    private static final String JAVA_RESOURCE = "MyWebService.java_resource";
    IProject testProject;
    IMember member;
    CreateWebServiceWizard wizard;
    WizardDialog dialog;
    AnnotationAttributePage attributePage;
    private IPreferenceStore preference_store;
    private String originalPrefFlag;

    protected void setUp() throws Exception {
        this.preference_store = ScJaxWsPlugin.getDefault().getPreferenceStore();
        this.originalPrefFlag = this.preference_store.getString("annWizEnabled");
        this.preference_store.setValue("annWizEnabled", "enabled");
        this.testProject = TestUtilities.createTestCeltixProject((String)TEST_PROJECT_NAME);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)this.testProject, (String)LOCAL_JAVA, ((Object)((Object)this)).getClass(), (String)"/resources/MyWebService.java_resource");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TestUtilities.openEditor((IWorkbenchWindow)window, (IFile)testFile);
        IJavaElement javaFile = JavaCore.create((IFile)testFile);
        CreateWebServiceWizardTest.assertTrue((boolean)(javaFile instanceof ICompilationUnit));
        IType[] types = ((ICompilationUnit)javaFile).getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i] instanceof IMember) {
                this.member = types[i];
                break;
            }
            ++i;
        }
        this.wizard = new CreateWebServiceWizard(this.member);
        this.dialog = new ScWizardDialog(window.getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.attributePage = (AnnotationAttributePage)this.wizard.getPage(AnnotationAttributePage.generatePageName(WebService.class));
    }

    protected void tearDown() throws Exception {
        this.preference_store.setValue("annWizEnabled", this.originalPrefFlag);
        this.dialog.close();
        if (this.testProject != null && this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
        this.attributePage = null;
        this.wizard = null;
    }

    public void testWizardNotNull() {
        CreateWebServiceWizardTest.assertNotNull((Object)this.wizard);
    }

    public void testNumberWizardPages() {
        CreateWebServiceWizardTest.assertEquals((int)1, (int)this.wizard.getPageCount());
    }

    public void testContextHelpID() {
    }

    public void testAttributePageIsStartingPage() {
        CreateWebServiceWizardTest.assertEquals((Object)this.attributePage, (Object)this.wizard.getStartingPage());
    }

    public void testNoPreviousPageInitially() {
        CreateWebServiceWizardTest.assertNull((Object)this.wizard.getPreviousPage((IWizardPage)this.attributePage));
    }

    public void testNosNextPageInitially() {
        CreateWebServiceWizardTest.assertNull((Object)this.wizard.getNextPage((IWizardPage)this.attributePage));
    }
}

