/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.wsdltojava;

import java.util.HashMap;
import java.util.Hashtable;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.jaxws.annotations.filter.JaxWsAnnFilter;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.WsdlToJavaGenerateAction;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class WsdlToJavaGenerateActionTest
extends TestCase {
    private static final String TEST_PROJECT_NAME = "WsdlToJavaTestProject";
    private static final String LOCAL_WSDL = "hello_world_RPCLit.wsdl";
    IProject testProject;
    IFile testFile;
    WsdlToJavaGenerateAction action = null;
    Hashtable<String, Object> genParams = null;
    HashMap<String, Object> params = null;

    protected void setUp() throws Exception {
        this.testProject = TestUtilities.createTestCeltixProject((String)TEST_PROJECT_NAME);
        TestUtilities.setupJavaProject(this.testProject);
        this.testFile = TestUtilities.addFileResourceToTestProject((IProject)this.testProject, (String)LOCAL_WSDL, ((Object)((Object)this)).getClass(), (String)"/resources/hello_world_RPCLit.wsdl");
        this.params = new HashMap();
        this.params.put("impl", "");
        this.params.put("server", "");
        this.params.put("client", "");
        this.params.put("exsoapheader", "");
        this.params.put("defaultns", "");
        this.params.put("defaultex", "");
        this.genParams = new Hashtable();
        this.genParams.put("TOOL_SPECIFIC_OPS", this.params);
        String srcDir = JaxWsWorkspaceManager.getSrcFolder((IProject)this.testProject).getLocation().toOSString();
        this.genParams.put("GEN_OUTPUTDIR", srcDir);
        this.action = new WsdlToJavaGenerateAction();
        this.action.generate(this.testFile.getLocation().toOSString(), this.testProject, this.genParams);
    }

    protected void tearDown() throws Exception {
        if (this.testProject != null && this.testProject.exists()) {
            this.testProject.close(null);
            this.testProject.delete(true, null);
        }
    }

    public void testGenerateJava() throws Exception {
        IFile sei = this.testProject.getFile("/src/org/objectweb/hello_world_rpclit/GreeterRPCLit.java");
        WsdlToJavaGenerateActionTest.assertTrue((String)"should generate sei", (boolean)sei.exists());
        IFile impl = this.testProject.getFile("/src/org/objectweb/hello_world_rpclit/GreeterRPCLitImpl.java");
        WsdlToJavaGenerateActionTest.assertTrue((String)"should generate impl", (boolean)impl.exists());
        IFile client = this.testProject.getFile("/src/org/objectweb/hello_world_rpclit/GreeterRPCLit_SoapPortRPCLit_Client.java");
        WsdlToJavaGenerateActionTest.assertTrue((String)"should generate client", (boolean)client.exists());
        String wsdl = sei.getPersistentProperty(JaxWsWorkspaceManager.WSDL_PROPERTY);
        WsdlToJavaGenerateActionTest.assertNotNull((String)"wsd persisten property shouldn't be null:", (Object)wsdl);
    }

    public void testAnnFilter() throws Exception {
        JaxWsAnnFilter filter = new JaxWsAnnFilter();
        IFile sei = this.testProject.getFile("/src/org/objectweb/hello_world_rpclit/GreeterRPCLit.java");
        WsdlToJavaGenerateActionTest.assertTrue((String)"should perform ann validation on generated sei:", (boolean)filter.needsToValidate(sei));
        IFile client = this.testProject.getFile("/src/org/objectweb/hello_world_rpclit/GreeterRPCLit_SoapPortRPCLit_Client.java");
        WsdlToJavaGenerateActionTest.assertFalse((String)"shouldn't perform ann validation on generated code:", (boolean)filter.needsToValidate(client));
    }
}

