/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.RefreshProfileJob;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IDeploySession;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.core.operations.CreateDeployPackagesJob;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.core.cp.StpProfileManager;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DeployStatusDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.Dialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.PreUndeployCheckDialogPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class ExecuteUndeploymentJob
extends Job {
    private Root mRoot;
    private Map mDeployConfigToDeployTargetMap = new HashMap();
    private Map mDeployTargetToDeploySessionMap = new HashMap();
    private Map mDeployStatusMap = new HashMap();
    private boolean mHasErrorStatus = false;
    private CreateDeployPackagesJob mCreatePackages;
    private Shell mShell;

    public ExecuteUndeploymentJob(Root root, Shell shell) {
        super(DeployCorePlugin.getDefault().getResourceString("ExecuteUndeploymentJob.task.name"));
        this.mRoot = root;
        this.mShell = shell;
        this.mCreatePackages = new CreateDeployPackagesJob(this.mRoot);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.setUser(true);
        this.setSystem(false);
    }

    /*
     * Exception decompiling
     */
    public IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[DOLOOP]], but top level block is 17[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map getDeployStatusMap() {
        return this.mDeployStatusMap;
    }

    private void checkCancelled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private Map createPackages(IProgressMonitor monitor) throws CoreException, InterruptedException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
        IStatus status = this.mCreatePackages.run((IProgressMonitor)subMonitor);
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
        this.checkCancelled(monitor);
        return this.mCreatePackages.getPackageDescriptors();
    }

    private void preUndeployCheck(Map packageDescriptors, final IProgressMonitor monitor) throws CoreException, InterruptedException {
        int deployTaskLength = this.getDeployTaskLength();
        HashMap<DeployConfiguration, IStatus[]> deployCheckStatus = new HashMap<DeployConfiguration, IStatus[]>();
        int severity = 0;
        for (Map.Entry entry : packageDescriptors.entrySet()) {
            DeployConfiguration config = (DeployConfiguration)entry.getKey();
            IPackageOutputDescriptor descriptor = (IPackageOutputDescriptor)entry.getValue();
            monitor.subTask(DeployCorePlugin.getDefault().getResourceString("ExecuteUndeploymentJob.subtask.preDeployCheck", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}));
            if (descriptor == null) {
                String exceptionMessage = DeployCorePlugin.getDefault().getResourceString("ExecuteUndeploymentJob.error.deployError", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()});
                Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("ExecuteUndeploymentJob.error.log.message"), (Throwable)new Exception(exceptionMessage));
                throw new CoreException((IStatus)new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, new IStatus[]{status}, DeployCorePlugin.getDefault().getResourceString("UndeployStatusDialog.TITLE"), null));
            }
            IDeployTarget target = Utilities.adaptToIDeployTarget((EObject)config);
            IDeploySession session = target.createDeploySession();
            this.mDeployConfigToDeployTargetMap.put(config, target);
            this.mDeployTargetToDeploySessionMap.put(target, session);
            IStatus[] status = session.preUndeployCheck(descriptor);
            deployCheckStatus.put(config, status);
            if (status != null && status.length > 0) {
                int index = 0;
                int count = status.length;
                while ((severity & 4) == 0 && index < count) {
                    severity |= status[index].getSeverity();
                    ++index;
                }
            }
            monitor.worked(deployTaskLength);
            if (severity != 0) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                final PreUndeployCheckDialogPage page = new PreUndeployCheckDialogPage(deployCheckStatus, (severity & 4) == 0);
                display.syncExec(new Runnable(){

                    public void run() {
                        boolean disposeShell = false;
                        Display display = Display.getCurrent();
                        Shell shell = display.getActiveShell();
                        if (shell == null) {
                            Shell[] shells = display.getShells();
                            if (shells.length > 0) {
                                shell = shells[shells.length - 1];
                            } else {
                                disposeShell = true;
                                shell = new Shell();
                            }
                        }
                        try {
                            Dialog dialog = new Dialog(shell, (IDialogPage)page, 16);
                            if (dialog.open() == 1) {
                                monitor.setCanceled(true);
                            }
                        }
                        finally {
                            if (disposeShell) {
                                shell.dispose();
                            }
                        }
                    }
                });
            }
            this.checkCancelled(monitor);
        }
        this.checkCancelled(monitor);
    }

    private void undeployPackages(Map packageDescriptors, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int deployTaskLength = this.getDeployTaskLength();
        for (Map.Entry entry : packageDescriptors.entrySet()) {
            block11: {
                DeployConfiguration config = (DeployConfiguration)entry.getKey();
                IPackageOutputDescriptor descriptor = (IPackageOutputDescriptor)entry.getValue();
                monitor.subTask(DeployCorePlugin.getDefault().getResourceString("ExecuteUndeploymentJob.subtask.deploy", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}));
                if (descriptor == null || !new File(descriptor.getFileName()).exists()) {
                    this.mDeployStatusMap.put(config, new IStatus[]{new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Undeploy.ERROR.PackageDoesNotExist", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}), null)});
                    this.mHasErrorStatus = true;
                } else {
                    DeployStatusDialogPage page;
                    Display display;
                    IDeployTarget target = (IDeployTarget)this.mDeployConfigToDeployTargetMap.get(config);
                    IDeploySession session = (IDeploySession)this.mDeployTargetToDeploySessionMap.get(target);
                    try {
                        try {
                            session.undeploy(descriptor);
                            this.mDeployStatusMap.put(config, new IStatus[]{new Status(1, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Undeploy.SUCCESS.Generic", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}), null)});
                        }
                        catch (Exception e) {
                            this.mDeployStatusMap.put(config, new IStatus[]{new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Undeploy.ERROR.Generic", new Object[]{config.getSourcePackage().getPackageFile(), target.getConnectionProfile().getName(), e.getMessage()}), (Throwable)e)});
                            this.mHasErrorStatus = true;
                            if (session != null) {
                                session.dispose();
                            }
                            this.mDeployTargetToDeploySessionMap.remove(target);
                            display = PlatformUI.getWorkbench().getDisplay();
                            page = new DeployStatusDialogPage(this.mDeployStatusMap, DeployCorePlugin.getDefault().getResourceString("UndeployStatusDialog.TITLE"));
                            display.syncExec(new Runnable(page){
                                private final /* synthetic */ DeployStatusDialogPage val$page;
                                {
                                    this.val$page = deployStatusDialogPage;
                                }

                                public void run() {
                                    boolean disposeShell = false;
                                    Display display = Display.getCurrent();
                                    Shell shell = display.getActiveShell();
                                    if (shell == null) {
                                        Shell[] shells = display.getShells();
                                        if (shells.length > 0) {
                                            shell = shells[shells.length - 1];
                                        } else {
                                            disposeShell = true;
                                            shell = new Shell();
                                        }
                                    }
                                    try {
                                        Dialog dialog = new Dialog(shell, (IDialogPage)this.val$page, 16);
                                        dialog.open();
                                    }
                                    finally {
                                        if (disposeShell) {
                                            shell.dispose();
                                        }
                                    }
                                }
                            });
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.dispose();
                        }
                        this.mDeployTargetToDeploySessionMap.remove(target);
                        display = PlatformUI.getWorkbench().getDisplay();
                        page = new DeployStatusDialogPage(this.mDeployStatusMap, DeployCorePlugin.getDefault().getResourceString("UndeployStatusDialog.TITLE"));
                        display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    if (session != null) {
                        session.dispose();
                    }
                    this.mDeployTargetToDeploySessionMap.remove(target);
                    display = PlatformUI.getWorkbench().getDisplay();
                    page = new DeployStatusDialogPage(this.mDeployStatusMap, DeployCorePlugin.getDefault().getResourceString("UndeployStatusDialog.TITLE"));
                    display.syncExec(new /* invalid duplicate definition of identical inner class */);
                }
            }
            monitor.worked(deployTaskLength);
            this.checkCancelled(monitor);
        }
        this.checkCancelled(monitor);
    }

    private void refreshDSE(IProgressMonitor monitor) {
        IViewPart dseView = null;
        IWorkbenchWindow[] workbenchWindows = DeployCorePlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (workbenchWindows != null) {
            int winIndex = 0;
            int winCount = workbenchWindows.length;
            while (dseView == null && winIndex < winCount) {
                IWorkbenchPage[] workbenchPages = workbenchWindows[winIndex].getPages();
                if (workbenchPages != null) {
                    IViewReference dseReference = null;
                    int pageIndex = 0;
                    int pageCount = workbenchPages.length;
                    while (dseReference == null && pageIndex < pageCount) {
                        dseReference = workbenchPages[pageIndex].findViewReference("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
                        ++pageIndex;
                    }
                    if (dseReference != null) {
                        dseView = dseReference.getView(false);
                    }
                }
                ++winIndex;
            }
        }
        if (dseView != null && dseView instanceof CommonNavigator) {
            int refreshTaskLength = this.getRefreshTaskLength();
            final CommonNavigator serversView = (CommonNavigator)dseView;
            Display display = serversView.getSite().getPage().getWorkbenchWindow().getShell().getDisplay();
            CommonViewer viewer = serversView.getCommonViewer();
            display.syncExec(new Runnable(){

                public void run() {
                    serversView.getViewSite().getPage().activate((IWorkbenchPart)serversView);
                }
            });
            for (DeployServer server : this.mRoot.getServer()) {
                IConnectionProfile profile = StpProfileManager.getInstance().getProfileByName(server.getProfileName());
                if (profile.isConnected()) {
                    RefreshProfileJob.scheduleRefreshProfileJob((IConnectionProfile)profile, (TreeViewer)viewer);
                }
                monitor.worked(refreshTaskLength);
            }
        }
    }

    private int getDeployTaskLength() {
        int retVal = 0;
        Iterator it = this.mRoot.getPackage().iterator();
        while (it.hasNext()) {
            retVal += ((DeployPackage)it.next()).getTargetConfiguration().size();
        }
        return retVal / 1000 + 1;
    }

    private int getRefreshTaskLength() {
        return this.mRoot.getServer().size() / 1000 + 1;
    }

    private void logStatus() {
        ArrayList statuses = new ArrayList();
        Iterator it = this.mDeployStatusMap.values().iterator();
        while (it.hasNext()) {
            statuses.addAll(Arrays.asList((IStatus[])it.next()));
        }
        DeployCorePlugin.getDefault().log((IStatus)new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, statuses.toArray(new IStatus[statuses.size()]), DeployCorePlugin.getDefault().getResourceString("UndeployStatusDialog.TITLE"), null));
    }

    private void displayStatus() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final DeployStatusDialogPage page = new DeployStatusDialogPage(this.mDeployStatusMap, DeployCorePlugin.getDefault().getResourceString("UndeployStatusDialog.TITLE"));
        display.syncExec(new Runnable(){

            public void run() {
                boolean disposeShell = false;
                Display display = Display.getCurrent();
                Shell shell = ExecuteUndeploymentJob.this.mShell;
                if (shell == null) {
                    Shell[] shells = display.getShells();
                    if (shells.length > 0) {
                        shell = shells[shells.length - 1];
                    } else {
                        disposeShell = true;
                        shell = new Shell();
                    }
                }
                try {
                    Dialog dialog = new Dialog(shell, (IDialogPage)page, 16);
                    dialog.open();
                }
                finally {
                    if (disposeShell) {
                        shell.dispose();
                    }
                }
            }
        });
    }
}

