package client;

import java.util.List;

import org.apache.tuscany.container.java.module.EventContext;
import org.apache.tuscany.container.java.module.TuscanyModuleComponentContext;
import org.apache.tuscany.container.java.module.impl.DefaultScopeStrategy;
import org.apache.tuscany.container.java.module.impl.SDOConfigurer;
import org.apache.tuscany.container.java.module.impl.TuscanyModuleComponentContextImpl;
import org.osoa.sca.SCA;

import services.account.AccountReport;
import services.account.AccountService;

public class TestDummyAccountService extends SCA {
	
	public void start(){ 
	}

	public void stop(){
	}

	public static void main(String[] args) throws Exception {
		SDOConfigurer configurer = new SDOConfigurer();
		TuscanyModuleComponentContext moduleComponent =
			new TuscanyModuleComponentContextImpl(
					1, "bigbank.accountmodule.testclient", "uri",
					new DefaultScopeStrategy(), configurer);

		setModuleContext(moduleComponent);
		moduleComponent.start();
		moduleComponent.fireEvent(EventContext.MODULE_START, null);
		moduleComponent.fireEvent(EventContext.REQUEST_START, null);
		Object key = new Object();
		moduleComponent.fireEvent(EventContext.SESSION_NOTIFY, key);
		AccountService accountService = (AccountService)
			moduleComponent.locateService("AccountService");


		AccountReport report = accountService.getAccountReport("foo");
		List summaries = report.getAccountSummaries();

		System.out.println("retrieved " + summaries.size() + " summaries");
	}
}
