/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.NullConnectionProfile;
import org.eclipse.jpt.db.internal.ProfileListener;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionProfileRepository {
    private ProfileManager dtpProfileManager = ProfileManager.getInstance();
    private LocalRepositoryListener repositoryListener;
    private LocalProfileListener profileListener;
    private Set<ConnectionProfile> profiles;
    private static ConnectionProfileRepository INSTANCE;
    public static final String DATABASE_CATEGORY_ID = "org.eclipse.datatools.connectivity.db.category";

    public static ConnectionProfileRepository instance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionProfileRepository();
        }
        return INSTANCE;
    }

    private ConnectionProfileRepository() {
    }

    public void initializeListeners() {
        if (this.repositoryListener == null) {
            this.repositoryListener = new LocalRepositoryListener();
            this.dtpProfileManager.addProfileListener((IProfileListener)this.repositoryListener);
        }
        if (this.profileListener == null) {
            this.profileListener = new LocalProfileListener();
            this.dtpProfileManager.addProfileListener((IProfileListener)this.profileListener);
        }
    }

    public void disposeListeners() {
        Iterator<ConnectionProfile> stream = this.profiles();
        while (stream.hasNext()) {
            stream.next().dispose();
        }
        if (this.repositoryListener != null) {
            this.dtpProfileManager.removeProfileListener((IProfileListener)this.repositoryListener);
            this.repositoryListener = null;
        }
        if (this.profileListener != null) {
            this.dtpProfileManager.removeProfileListener((IProfileListener)this.profileListener);
            this.profileListener = null;
        }
    }

    public String toString() {
        return this.profiles.toString();
    }

    public Iterator<ConnectionProfile> profiles() {
        return this.getProfiles().iterator();
    }

    public Iterator<String> profileNames() {
        return new TransformationIterator<ConnectionProfile, String>(this.profiles()){

            protected String transform(ConnectionProfile profile) {
                return profile.getName();
            }
        };
    }

    public ConnectionProfile profileNamed(String name) {
        Iterator<ConnectionProfile> stream = this.profiles();
        while (stream.hasNext()) {
            ConnectionProfile profile = stream.next();
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return NullConnectionProfile.instance();
    }

    private Set<ConnectionProfile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = this.buildProfiles();
        }
        return this.profiles;
    }

    private Set<ConnectionProfile> buildProfiles() {
        IConnectionProfile[] dtpProfiles = this.dtpProfileManager.getProfiles();
        HashSet<ConnectionProfile> result = new HashSet<ConnectionProfile>(dtpProfiles.length);
        IConnectionProfile[] iConnectionProfileArray = dtpProfiles;
        int n = dtpProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile dtpProfile = iConnectionProfileArray[n2];
            result.add(ConnectionProfile.createProfile(this, dtpProfile));
            ++n2;
        }
        return result;
    }

    void addProfile(IConnectionProfile dtpProfile) {
        if (!this.profileExists(dtpProfile)) {
            ConnectionProfile newProfile = ConnectionProfile.createProfile(this, dtpProfile);
            this.profiles.add(newProfile);
        }
    }

    void removeProfile(IConnectionProfile dtpProfile) {
        this.profiles.remove(this.getProfile(dtpProfile));
    }

    private boolean profileExists(IConnectionProfile dtpProfile) {
        return this.getProfile(dtpProfile) != null;
    }

    ConnectionProfile getProfile(IConnectionProfile dtpProfile) {
        Iterator<ConnectionProfile> stream = this.profiles();
        while (stream.hasNext()) {
            ConnectionProfile profile = stream.next();
            if (!profile.wraps(dtpProfile)) continue;
            return profile;
        }
        return null;
    }

    public void addProfileListener(ProfileListener listener) {
        this.profileListener.addProfileListener(listener);
    }

    public void removeProfileListener(ProfileListener listener) {
        this.profileListener.removeProfileListener(listener);
    }

    private void addInternalProfileListener(IProfileListener listener) {
        this.dtpProfileManager.addProfileListener(listener);
    }

    private void removeInternalProfileListener(IProfileListener listener) {
        this.dtpProfileManager.removeProfileListener(listener);
    }

    private class LocalProfileListener
    implements IProfileListener {
        private Collection<ProfileListener> listeners = new ArrayList<ProfileListener>();

        LocalProfileListener() {
        }

        void addProfileListener(ProfileListener listener) {
            this.listeners.add(listener);
        }

        void removeProfileListener(ProfileListener listener) {
            this.listeners.remove(listener);
        }

        public void profileAdded(IConnectionProfile dtpProfile) {
            ConnectionProfile profile = ConnectionProfileRepository.this.getProfile(dtpProfile);
            for (ProfileListener listener : this.listeners) {
                listener.profileAdded(profile);
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile) {
            ConnectionProfile profile = ConnectionProfileRepository.this.getProfile(dtpProfile);
            for (ProfileListener listener : this.listeners) {
                listener.profileChanged(profile);
            }
        }

        public void profileDeleted(IConnectionProfile dtpProfile) {
            String profileName = dtpProfile.getName();
            for (ProfileListener listener : this.listeners) {
                listener.profileDeleted(profileName);
            }
        }
    }

    private class LocalRepositoryListener
    implements IProfileListener {
        LocalRepositoryListener() {
        }

        public void profileAdded(IConnectionProfile connectionProfile) {
            ConnectionProfileRepository.this.addProfile(connectionProfile);
        }

        public void profileChanged(IConnectionProfile connectionProfile) {
        }

        public void profileDeleted(IConnectionProfile connectionProfile) {
            ConnectionProfileRepository.this.removeProfile(connectionProfile);
        }
    }
}

