/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.jpt.db.internal.Catalog;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.ConnectionProfileRepository;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.NullDatabase;
import org.eclipse.jpt.db.internal.ProfileListener;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;

public final class DTPConnectionProfileWrapper
extends ConnectionProfile {
    private final IConnectionProfile dtpConnectionProfile;
    private Connection connection;
    public static final String LIVE_CONNECTION_TYPE = "java.sql.Connection";
    public static final String OFFLINE_CONNECTION_TYPE = "org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo";
    public static final String CONNECTION_PROFILE_TYPE = "org.eclipse.datatools.connectivity.db.generic.connectionProfile";
    public static final String DATABASE_PRODUCT_PROPERTY = "org.eclipse.datatools.connectivity.server.version";
    public static final String DATABASE_SAVE_PWD_PROP_ID = "org.eclipse.datatools.connectivity.db.savePWD";
    public static final String DRIVER_DEFINITION_PROP_ID = "org.eclipse.datatools.connectivity.driverDefinitionID";
    public static final String DRIVER_DEFINITION_TYPE_PROP_ID = "org.eclipse.datatools.connectivity.drivers.defnType";
    public static final String DRIVER_JAR_LIST_PROP_ID = "jarList";
    public static final String POSTGRESQL_VENDOR = "postgres";
    public static final String PUBLIC_SCHEMA = "public";

    DTPConnectionProfileWrapper(ConnectionProfileRepository profileRepository, IConnectionProfile dtpConnectionProfile) {
        super(profileRepository);
        this.dtpConnectionProfile = dtpConnectionProfile;
    }

    public void addProfileListener(ProfileListener listener) {
        this.getProfileRepository().addProfileListener(listener);
    }

    public void removeProfileListener(ProfileListener listener) {
        this.getProfileRepository().removeProfileListener(listener);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.getConnection().addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.getConnection().removeConnectionListener(listener);
    }

    IManagedConnection getDTPConnection() {
        return this.dtpConnectionProfile.getManagedConnection(LIVE_CONNECTION_TYPE);
    }

    IManagedConnection getDTPOfflineConnection() {
        return this.dtpConnectionProfile.getManagedConnection(OFFLINE_CONNECTION_TYPE);
    }

    public void connect() {
        IStatus status;
        if (!this.connectionIsOnline() && !(status = this.dtpConnectionProfile.connect()).isOK()) {
            if (status.isMultiStatus()) {
                IStatus[] statusChildren = status.getChildren();
                throw new RuntimeException(statusChildren[0].getMessage(), statusChildren[0].getException());
            }
            throw new RuntimeException(status.getMessage(), status.getException());
        }
    }

    public void disconnect() {
        IStatus status = this.dtpConnectionProfile.disconnect();
        if (!status.isOK()) {
            if (status.isMultiStatus()) {
                IStatus[] statusChildren = status.getChildren();
                throw new RuntimeException(statusChildren[0].getMessage(), statusChildren[0].getException());
            }
            throw new RuntimeException(status.getMessage(), status.getException());
        }
    }

    protected void dispose() {
        super.dispose();
        this.disposeConnection();
    }

    private void disposeConnection() {
        if (this.getConnection() != null) {
            this.getConnection().dispose();
        }
    }

    void databaseChanged(Database database, int eventType) {
        this.getConnection().databaseChanged(database, eventType);
    }

    void catalogChanged(Catalog catalog, Database database, int eventType) {
    }

    void schemaChanged(Schema schema, Database database, int eventType) {
        this.getConnection().schemaChanged(schema, database, eventType);
    }

    void tableChanged(Table table, Schema schema, Database database, int eventType) {
        this.getConnection().tableChanged(table, schema, database, eventType);
    }

    protected Connection buildConnection() {
        Connection connection = Connection.createConnection(this);
        return connection;
    }

    protected Database buildDatabase() {
        if (this.isConnected()) {
            org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase;
            if (this.isWorkingOffline()) {
                ConnectionInfo connectionInfo = (ConnectionInfo)this.getDTPOfflineConnection().getConnection().getRawConnection();
                dtpDatabase = connectionInfo.getSharedDatabase();
            } else {
                dtpDatabase = ProfileUtil.getDatabase((DatabaseIdentifier)new DatabaseIdentifier(this.getName(), this.getDatabaseName()), (boolean)true);
            }
            return Database.createDatabase(this, dtpDatabase);
        }
        return NullDatabase.instance();
    }

    public IStatus saveWorkOfflineData() {
        return this.dtpConnectionProfile.saveWorkOfflineData();
    }

    public IStatus workOffline() {
        return this.dtpConnectionProfile.workOffline();
    }

    boolean wraps(IConnectionProfile dtpProfile) {
        return this.dtpConnectionProfile == dtpProfile;
    }

    public boolean isConnected() {
        return this.getDTPConnection().isConnected() || this.isWorkingOffline();
    }

    public boolean isWorkingOffline() {
        return this.getDTPOfflineConnection().isWorkingOffline();
    }

    public boolean supportsWorkOfflineMode() {
        return this.dtpConnectionProfile.supportsWorkOfflineMode();
    }

    public boolean canWorkOffline() {
        return this.dtpConnectionProfile.canWorkOffline();
    }

    public boolean isNull() {
        return false;
    }

    public String getName() {
        return this.dtpConnectionProfile.getName();
    }

    public String getDatabaseName() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    public String getDatabaseProduct() {
        return this.getProperties().getProperty(DATABASE_PRODUCT_PROPERTY);
    }

    public String getDatabaseVendor() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.vendor");
    }

    public String getDatabaseVersion() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.version");
    }

    public String getUserName() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.username");
    }

    public String getUserPassword() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.password");
    }

    public String getDefaultSchema() {
        if (this.getDatabase().getVendor().equalsIgnoreCase(POSTGRESQL_VENDOR)) {
            return PUBLIC_SCHEMA;
        }
        return this.getUserName();
    }

    public String getDriverClass() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
    }

    public String getUrl() {
        return this.getProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public String getInstanceId() {
        return this.dtpConnectionProfile.getInstanceID();
    }

    public String getProviderId() {
        return this.dtpConnectionProfile.getProviderId();
    }

    public String getDriverDefinitionId() {
        return this.getProperties().getProperty(DRIVER_DEFINITION_PROP_ID);
    }

    public String getDriverJarList() {
        return DriverManager.getInstance().getDriverInstanceByID(this.getDriverDefinitionId()).getJarList();
    }

    private Properties getProperties() {
        return this.dtpConnectionProfile.getBaseProperties();
    }

    private Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.buildConnection();
            this.engageConnectionListener();
        }
        return this.connection;
    }
}

