/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.jpt.db.internal.Column;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForeignKey
extends DTPWrapper
implements Comparable<ForeignKey> {
    private final Table baseTable;
    private final org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey;
    private ICatalogObjectListener foreignKeyListener;
    private Table referencedTable;
    private Set<ColumnPair> columnPairs;
    private String defaultEntityFieldName;
    private boolean defaultEntityFieldNameCalculated = false;

    ForeignKey(Table baseTable, org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey) {
        this.baseTable = baseTable;
        this.dtpForeignKey = dtpForeignKey;
        this.initialize();
    }

    private void initialize() {
        if (this.connectionIsOnline()) {
            this.foreignKeyListener = this.buildForeignKeyListener();
            this.addCatalogObjectListener((ICatalogObject)this.dtpForeignKey, this.foreignKeyListener);
        }
    }

    @Override
    protected boolean connectionIsOnline() {
        return this.baseTable.connectionIsOnline();
    }

    private ICatalogObjectListener buildForeignKeyListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject foreignKey, int eventType) {
            }
        };
    }

    @Override
    protected void dispose() {
        this.removeCatalogObjectListener((ICatalogObject)this.dtpForeignKey, this.foreignKeyListener);
    }

    public Table getBaseTable() {
        return this.baseTable;
    }

    @Override
    public String getName() {
        return this.dtpForeignKey.getName();
    }

    boolean isCaseSensitive() {
        return this.baseTable.isCaseSensitive();
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.constraints.ForeignKey foreignKey) {
        return this.dtpForeignKey == foreignKey;
    }

    @Override
    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.getName()) + ": " + this.getColumnPairs()));
    }

    public Table getReferencedTable() {
        if (this.referencedTable == null) {
            this.referencedTable = this.baseTable.table((org.eclipse.datatools.modelbase.sql.tables.Table)this.dtpForeignKey.getUniqueConstraint().getBaseTable());
        }
        return this.referencedTable;
    }

    public Iterator<Column> baseColumns() {
        return new TransformationIterator<ColumnPair, Column>(this.columnPairs()){

            protected Column transform(ColumnPair pair) {
                return pair.getBaseColumn();
            }
        };
    }

    public Iterator<Column> nonPrimaryKeyBaseColumns() {
        return new FilteringIterator<Column>(this.baseColumns()){

            protected boolean accept(Object o) {
                return !ForeignKey.this.getBaseTable().primaryKeyColumnsContains((Column)o);
            }
        };
    }

    public Iterator<Column> referencedColumns() {
        return new TransformationIterator<ColumnPair, Column>(this.columnPairs()){

            protected Column transform(ColumnPair columnPair) {
                return columnPair.getReferencedColumn();
            }
        };
    }

    public String javaFieldName() {
        String fieldName = this.getDefaultEntityFieldName();
        return fieldName == null ? this.nonDefaultEntityFieldName() : fieldName;
    }

    public boolean matchesJavaFieldName(String javaFieldName) {
        return this.isCaseSensitive() ? javaFieldName.equals(this.getDefaultEntityFieldName()) : javaFieldName.equalsIgnoreCase(this.getDefaultEntityFieldName());
    }

    public boolean isDefaultFor(String javaFieldName) {
        if (this.columnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().primaryKeyColumnsSize() != 1) {
            return false;
        }
        ColumnPair columnPair = this.columnPairs().next();
        Column pkColumn = this.getReferencedTable().primaryKeyColumns().next();
        if (columnPair.getReferencedColumn() != pkColumn) {
            return false;
        }
        return columnPair.getBaseColumn().matchesJavaFieldName(String.valueOf(javaFieldName) + "_" + pkColumn.getName());
    }

    private synchronized Set<ColumnPair> getColumnPairs() {
        if (this.columnPairs == null) {
            this.columnPairs = this.buildColumnPairs();
        }
        return this.columnPairs;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> dtpBaseColumns() {
        return this.dtpForeignKey.getMembers();
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> dtpRefColumns() {
        return this.dtpForeignKey.getUniqueConstraint().getMembers();
    }

    private Set<ColumnPair> buildColumnPairs() {
        List<org.eclipse.datatools.modelbase.sql.tables.Column> baseColumns = this.dtpBaseColumns();
        int size = baseColumns.size();
        List<org.eclipse.datatools.modelbase.sql.tables.Column> refColumns = this.dtpRefColumns();
        if (refColumns.size() != size) {
            throw new IllegalStateException(String.valueOf(this.getBaseTable().getName()) + "." + this.getName() + " - mismatched sizes: " + size + " vs. " + refColumns.size());
        }
        HashSet<ColumnPair> result = new HashSet<ColumnPair>(baseColumns.size());
        int i = baseColumns.size();
        while (i-- > 0) {
            Column baseColumn = this.baseTable.column(baseColumns.get(i));
            Column refColumn = this.baseTable.column(refColumns.get(i));
            result.add(new ColumnPair(baseColumn, refColumn));
        }
        return result;
    }

    public Iterator<ColumnPair> columnPairs() {
        return this.getColumnPairs().iterator();
    }

    public int columnPairsSize() {
        return this.getColumnPairs().size();
    }

    private String getDefaultEntityFieldName() {
        if (!this.defaultEntityFieldNameCalculated) {
            this.defaultEntityFieldNameCalculated = true;
            this.defaultEntityFieldName = this.buildDefaultEntityFieldName();
        }
        return this.defaultEntityFieldName;
    }

    private String buildDefaultEntityFieldName() {
        if (!this.referencesSingleColumnPrimaryKey()) {
            return null;
        }
        ColumnPair columnPair = this.columnPairs().next();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        if (baseColName.length() <= refColName.length() + 1) {
            return null;
        }
        if (!baseColName.endsWith(refColName)) {
            return null;
        }
        int _index = baseColName.length() - refColName.length() - 1;
        if (baseColName.charAt(_index) != '_') {
            return null;
        }
        String name = baseColName.substring(0, _index);
        return this.isCaseSensitive() ? name : name.toLowerCase();
    }

    public boolean referencesSingleColumnPrimaryKey() {
        if (this.columnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().primaryKeyColumnsSize() != 1) {
            return false;
        }
        ColumnPair columnPair = this.columnPairs().next();
        return columnPair.getReferencedColumn() == this.getReferencedTable().primaryKeyColumns().next();
    }

    private String nonDefaultEntityFieldName() {
        return this.columnPairsSize() == 1 ? this.columnPairs().next().getBaseColumn().javaFieldName() : this.getReferencedTable().javaFieldName();
    }

    @Override
    public int compareTo(ForeignKey foreignKey) {
        return Collator.getInstance().compare(this.getName(), foreignKey.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnPair
    implements Comparable<ColumnPair> {
        private final Column baseColumn;
        private final Column referencedColumn;

        ColumnPair(Column baseColumn, Column referencedColumn) {
            this.baseColumn = baseColumn;
            this.referencedColumn = referencedColumn;
        }

        public Column getBaseColumn() {
            return this.baseColumn;
        }

        public Column getReferencedColumn() {
            return this.referencedColumn;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.baseColumn.getName()) + "=>" + this.referencedColumn.getName()));
        }

        @Override
        public int compareTo(ColumnPair cp) {
            return Collator.getInstance().compare(this.getBaseColumn().getName(), cp.getBaseColumn().getName());
        }
    }
}

