/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.transport;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class TransportTest {
    static final boolean KILL_SOCKETS = false;
    static final boolean TEST_UNENCRYPTED = true;
    static final boolean TEST_ENCRYPTED = false;
    static final boolean TEST_BASIC = false;
    static final boolean TEST_MULTIPLEXED = false;
    static final boolean TEST_RECONNECTION = true;
    static double[] test_doubles = new double[]{0.6, 1.0, 9.9999999E7, 2.1379843270984325E21, 1.4632E-40};

    public static void main(String[] args) {
        Logger.PRINT_INFO = true;
        String initiator = "localhost";
        String listener = "localhost";
        boolean am_initiator = false;
        boolean am_both = true;
        if (args.length > 0) {
            am_both = false;
            initiator = args[0];
            listener = args[1];
            am_initiator = initiator.equalsIgnoreCase("localhost");
        }
        System.out.println("B2J engine transport test");
        int port = 29000;
        int RUNS = 30;
        long[] times = new long[30];
        Arrays.fill(times, -1L);
        boolean forever = true;
        int count = 0;
        while (forever) {
            ++count;
            int time_index = 0;
            if (port >= 29900) {
                port = 29000;
            }
            SessionAddress address = new SessionAddress(initiator, ++port, port, listener, port, port);
            address.setRequiresMultipleStreams(true);
            address.setRequiresLinkReconnection(true);
            address.setStartupFailureAbortTimeout(60000L);
            address.setReconnectionFailureAbortTimeout(120000L);
            int n = time_index++;
            times[n] = times[n] + TransportTest.testSession(count, address, am_both, am_initiator);
        }
        System.out.println("\n\n----- ALL RUNS COMPLETED SUCCESSFULLY, WAITING FOR ANY FURTHER PRINTOUTS...");
        try {
            Thread.sleep(6000L);
        }
        catch (Exception exception) {}
        System.out.println("\n\n----- TIMING INFO FOR ALL RUNS:");
        int k = 0;
        while (k < times.length) {
            if (times[k] != -1L) {
                times[k] = times[k] / (long)RUNS;
                System.out.println("----- Timer for " + k + ": " + times[k] + "ms");
            }
            ++k;
        }
    }

    public static void testSessionAddressSerialisation(SessionAddress address) {
        try {
            String serialised = SessionAddress.toString(address);
            SessionAddress deserialised = SessionAddress.fromString(serialised);
            if (deserialised.equals(address)) {
                System.out.println("----- Session serialised and deserialised OK");
            } else {
                System.out.println("----- Session serialised and deserialised incorrectly");
                System.out.println(serialised);
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println("----- An error occurred while serialising and deserialising the Session: " + e);
            e.printStackTrace();
        }
    }

    public static long testSession(int count, SessionAddress address, boolean am_both, boolean am_initiator) {
        System.out.println("\n\n----- Test session " + count + " for " + address + "\n");
        TransportTest.testSessionAddressSerialisation(address);
        TestThread server = null;
        TestThread client = null;
        if (address.getListenerPortMaximum() != address.getListenerPortMinimum()) {
            System.out.println("----- Address requires port scanning");
            if (am_both) {
                System.out.println("----- Address requires port scanning but cannot pass bound address to unknown process");
                return 0L;
            }
            server = new TestThread(address, "Listener", false);
            while (server.err == null && server.session == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            while (server.err == null && server.session.getActualAddress() == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            System.out.println("----- Actual address found: " + server.session.getActualAddress());
            client = new TestThread(server.session.getActualAddress(), "Initiator", true);
        } else {
            System.out.println("----- Address specifies an exact port");
            if (am_both || !am_initiator) {
                server = new TestThread(address, "Listener", false);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            if (am_both || am_initiator) {
                client = new TestThread(address, "Initiator", true);
            }
        }
        try {
            if (am_both || !am_initiator) {
                server.join();
            }
            if (am_both || am_initiator) {
                client.join();
            }
        }
        catch (Exception exception) {}
        long time_taken = 0L;
        time_taken = am_both ? (server.time_ms + client.time_ms) / 2L : (am_initiator ? client.time_ms : server.time_ms);
        if (am_both && (server.err != null || client.err != null)) {
            System.out.println("\n----- Test session FAILED (" + time_taken + "ms)\n\n");
            if (server.err != null) {
                server.err.printStackTrace();
            }
            if (client.err != null) {
                client.err.printStackTrace();
            }
            System.exit(0);
        }
        if ((am_both || !am_initiator) && server.err != null) {
            System.out.println("\n----- Test Listener session FAILED (" + time_taken + "ms)\n\n");
            if (server.err != null) {
                server.err.printStackTrace();
            }
            System.exit(0);
        }
        if ((am_both || am_initiator) && client.err != null) {
            System.out.println("\n----- Test Initiator session FAILED (" + time_taken + "ms)\n\n");
            if (client.err != null) {
                client.err.printStackTrace();
            }
            System.exit(0);
        }
        System.out.println("\n----- Test session SUCCEEDED (" + time_taken + "ms)\n\n");
        return time_taken;
    }

    public static void writeFinish(String name, Session session) throws Exception {
        StreamUtils.writeBoolean(session.getOutputStream((short)0), true);
        session.getOutputStream((short)0).flush();
    }

    public static void readFinish(String name, Session session) throws Exception {
        StreamUtils.readBoolean(session.getInputStream((short)0));
    }

    public static void writeData(String name, Session session) throws Exception {
        OutputStream outstream = session.getOutputStream((short)0);
        int i = 0;
        while (i < test_doubles.length) {
            StreamUtils.writeDouble(outstream, test_doubles[i]);
            ++i;
        }
        outstream.flush();
    }

    public static void readData(String name, Session session) throws Exception {
        InputStream instream = session.getInputStream((short)0);
        int i = 0;
        while (i < test_doubles.length) {
            double tmp = StreamUtils.readDouble(instream);
            if (tmp != test_doubles[i]) {
                throw new Exception("----- double mismatch, " + tmp + " != " + test_doubles[i]);
            }
            ++i;
        }
    }

    public static class TestThread
    extends Thread {
        Throwable err;
        SessionAddress address;
        boolean initiator = false;
        Session session;
        String name;
        long time_ms = 0L;

        public TestThread(SessionAddress address, String name, boolean initiator) {
            this.address = address;
            this.initiator = initiator;
            this.name = name;
            this.start();
        }

        public void run() {
            try {
                this.session = SessionFactory.newSession(this.address, this.initiator);
                this.runEx(this.session);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.err = t;
            }
        }

        public void runEx(Session session) throws Exception {
            System.out.println("----- " + this.name + " session transport " + session.getTransportImplementationName());
            session.begin();
            System.out.println("----- " + this.name + " session connected " + session.getActualAddress());
            this.time_ms = System.currentTimeMillis();
            int k = 0;
            while (k < 20000) {
                TransportTest.writeData(this.name, session);
                TransportTest.readData(this.name, session);
                ++k;
            }
            System.out.println("----- " + this.name + " Wrote and Read all data OK");
            TransportTest.writeFinish(this.name, session);
            TransportTest.readFinish(this.name, session);
            this.time_ms = System.currentTimeMillis() - this.time_ms;
            session.end(200L, 200L);
        }
    }
}

