/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.xml.internal.w3c;

import org.eclipse.stp.b2j.core.xml.internal.w3c.Attr;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NamedNodeMap;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;

public class Element
extends Node {
    NamedNodeMap attributes = new NamedNodeMap(this);
    String name;

    public Element(Node node, String name) {
        super(node, -1);
        this.name = name;
    }

    public String getAttribute(String name) {
        String s = (String)this.attributes.get(name);
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttribute(localName);
    }

    public Attr getAttributeNode(String name) {
        Attr at = new Attr(this, name, this.getAttribute(name));
        at.setStartLine(this.getStartLine());
        at.setEndLine(this.getEndLine());
        return at;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeNode(localName);
    }

    public NodeList getElementsByTagName(String name) {
        NodeList list = this.getDepthFirstList();
        this.filterList(list, Node.ELEMENT_NODE);
        if (!name.equals("*")) {
            this.filterList(list, name);
        }
        return list;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagName(localName);
    }

    public String getTagName() {
        return this.name;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.hasAttribute(localName);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(localName);
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        this.attributes.remove(oldAttr.getName());
        return oldAttr;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.setAttribute(qualifiedName, value);
    }

    public Attr setAttributeNode(Attr newAttr) {
        this.setAttribute(newAttr.getName(), newAttr.getValue());
        return newAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.setAttributeNode(newAttr);
    }

    public String getNodeName() {
        return this.name;
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String value) {
    }

    public short getNodeType() {
        return Node.ELEMENT_NODE;
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    Node cloneNode(Node parent) {
        Element element = new Element(parent, this.name);
        element.attributes.putAll(this.attributes);
        return element;
    }
}

