/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal.cactus;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.jst.server.core.internal.cactus.WebTestableResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleArtifactAdapterDelegate;

public class CactusModuleArtifactAdapterDelegate
extends ModuleArtifactAdapterDelegate {
    private static final String SERVLET_TEST_CASE_TYPE = "org.apache.cactus.ServletTestCase";
    private static final String SUITE_METHOD = "suite";
    private static final String TEST_CLASS_NAME = "junit.framework.Test";

    public IModuleArtifact getModuleArtifact(Object obj) {
        String methodName = "";
        if (obj instanceof IMethod) {
            IMethod method = (IMethod)obj;
            methodName = method.getElementName();
            obj = method.getCompilationUnit();
        }
        if (obj instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
            String testClassName = CactusModuleArtifactAdapterDelegate.getClassNameForType(resource, SERVLET_TEST_CASE_TYPE);
            String projectName = resource.getProject().getName();
            if (testClassName != null) {
                return new WebTestableResource(CactusModuleArtifactAdapterDelegate.getModule(resource.getProject()), false, projectName, testClassName, methodName);
            }
        }
        return null;
    }

    public static String getClassNameForType(IResource resource, String superType) {
        IPath path;
        IProject project;
        block12: {
            if (resource == null) {
                return null;
            }
            project = resource.getProject();
            path = resource.getFullPath();
            if (project.hasNature("org.eclipse.jdt.core.javanature") && path != null) break block12;
            return null;
        }
        try {
            IJavaElement javaElement;
            IType[] types;
            IClasspathEntry[] classPathEntry;
            IPath outputPath;
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            if (!javaProject.isOpen()) {
                javaProject.open((IProgressMonitor)new NullProgressMonitor());
            }
            if ((outputPath = javaProject.getOutputLocation()) != null && "class".equals(path.getFileExtension()) && outputPath.isPrefixOf(path)) {
                int count = outputPath.segmentCount();
                path = path.removeFirstSegments(count);
            }
            if ((classPathEntry = javaProject.getResolvedClasspath(true)) != null) {
                int size = classPathEntry.length;
                int i = 0;
                while (i < size) {
                    IPath classPath = classPathEntry[i].getPath();
                    if (classPath.isPrefixOf(path)) {
                        int count = classPath.segmentCount();
                        path = path.removeFirstSegments(count);
                        i += size;
                    }
                    ++i;
                }
            }
            if ((types = CactusModuleArtifactAdapterDelegate.getTypes(javaElement = javaProject.findElement(path))) != null) {
                int size2 = types.length;
                int i = 0;
                while (i < size2) {
                    if (CactusModuleArtifactAdapterDelegate.hasSuperclass(types[i], superType) || CactusModuleArtifactAdapterDelegate.hasSuiteMethod(types[i])) {
                        return types[i].getFullyQualifiedName();
                    }
                    ++i;
                }
            }
            return null;
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Unexpected exception: " + e);
            return null;
        }
    }

    private static boolean hasSuiteMethod(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int size = methods.length;
        int i = 0;
        while (i < size) {
            String returnType;
            IMethod method = methods[i];
            if (method.getParameterNames().length == 0 && method.getElementName().equals(SUITE_METHOD) && TEST_CLASS_NAME.equals(returnType = CactusModuleArtifactAdapterDelegate.getFullyQualifiedTypeForMangledType(method.getReturnType(), type))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IType[] getTypes(IJavaElement element) {
        block3: {
            try {
                if (element.getElementType() == 5) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return ((ICompilationUnit)element).getAllTypes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSuperclass(IType type, String superClassName) {
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] superClasses = hierarchy.getAllSuperclasses(type);
            int size = superClasses.length;
            int i = 0;
            while (true) {
                if (i >= size) {
                    return false;
                }
                if (superClassName.equals(superClasses[i].getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static IModule getModule(IProject project) {
        IModule deployable = null;
        for (IModule next : Arrays.asList(ServerUtil.getModules((String)"jst.web"))) {
            if (!(next instanceof IModule) || !(deployable = next).getProject().equals((Object)project)) continue;
            return deployable;
        }
        return null;
    }

    private static String getFullyQualifiedTypeForMangledType(String type, IType declaringType) throws JavaModelException {
        type = Signature.toString((String)type);
        return CactusModuleArtifactAdapterDelegate.getFullyQualifiedTypeForType(type, declaringType);
    }

    private static String getFullyQualifiedTypeForType(String type, IType declaringType) throws JavaModelException {
        String[][] resolvedTypes = declaringType.resolveType(type);
        if (resolvedTypes.length != 1) {
            Trace.trace((byte)1, "The type cannot be unambigiously resolved. Need to handle this case");
        }
        String[] resolvedType = resolvedTypes[0];
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < resolvedType.length - 1) {
            buffer.append(resolvedType[i]);
            buffer.append('.');
            ++i;
        }
        buffer.append(resolvedType[resolvedType.length - 1]);
        return buffer.toString();
    }
}

