/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11AddPartAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetExistingMessageAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetNewMessageAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Operation;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddFaultParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddInputParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddOutputParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11ReorderParametersCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.visitor.W11FindInnerElementVisitor;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddFaultAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddOperationAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDeleteAction;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ModelDiagnosticInfo;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObjectListener;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IOperation;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.visitor.WSDLVisitorForParameters;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider;
import org.eclipse.xsd.XSDElementDeclaration;

public class W11MessageReference
extends WSDLBaseAdapter
implements IMessageReference,
IASDObjectListener {
    protected int messageKind = -1;
    protected List parameters = null;
    protected List otherThingsToListenTo = null;
    protected List diagnosticMessages = new ArrayList();

    public W11MessageReference(int messageKind) {
        this.messageKind = messageKind;
    }

    public IOperation getOwnerOperation() {
        return (IOperation)((Object)this.owner);
    }

    public MessageReference getMessageReference() {
        return (MessageReference)this.target;
    }

    protected void computeMessageKind() {
        if (this.getMessageReference() instanceof Input) {
            this.messageKind = 1;
        } else if (this.getMessageReference() instanceof Output) {
            this.messageKind = 2;
        } else if (this.getMessageReference() instanceof Fault) {
            this.messageKind = 3;
        }
    }

    public int getKind() {
        if (this.messageKind == -1) {
            this.computeMessageKind();
        }
        return this.messageKind;
    }

    public String getName() {
        MessageReference messageRef = this.getMessageReference();
        if (messageRef.getName() != null) {
            return messageRef.getName();
        }
        return "";
    }

    public List getParameters() {
        ArrayList parameters = new ArrayList();
        EList parts = new ArrayList();
        MessageReference messageRef = this.getMessageReference();
        if (messageRef != null && messageRef.getEMessage() != null && messageRef.getEMessage().getEParts() != null) {
            parts = messageRef.getEMessage().getEParts();
        }
        this.populateAdapterList((List)parts, parameters);
        this.otherThingsToListenTo = new ArrayList();
        WSDLVisitorForParameters visitorForParameters = new WSDLVisitorForParameters();
        visitorForParameters.visitMessageReference(messageRef);
        this.populateAdapterList(visitorForParameters.concreteComponents, this.otherThingsToListenTo);
        this.populateAdapterList(visitorForParameters.thingsToListenTo, this.otherThingsToListenTo);
        Iterator i = this.otherThingsToListenTo.iterator();
        while (i.hasNext()) {
            Adapter adapter = (Adapter)i.next();
            if (!(adapter instanceof IASDObject)) continue;
            IASDObject asdObject = (IASDObject)adapter;
            asdObject.registerListener(this);
        }
        return parameters;
    }

    public void propertyChanged(Object object, String property) {
        this.clearParameters();
        this.notifyListeners(this, null);
    }

    protected void clearParameters() {
        if (this.otherThingsToListenTo != null) {
            Iterator i = this.otherThingsToListenTo.iterator();
            while (i.hasNext()) {
                Adapter adapter = (Adapter)i.next();
                if (!(adapter instanceof IASDObject)) continue;
                IASDObject asdObject = (IASDObject)adapter;
                asdObject.unregisterListener(this);
            }
        }
        this.parameters = null;
        this.otherThingsToListenTo = null;
    }

    public void notifyChanged(Notification msg) {
        this.clearParameters();
        super.notifyChanged(msg);
    }

    public String[] getActions(Object object) {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add(ASDAddOperationAction.ID);
        actions.addAll(((W11Operation)this.getOwnerOperation()).getValidInputOutpuActions());
        actions.add(ASDAddFaultAction.ID);
        actions.add(W11AddPartAction.ID);
        actions.add(ASDDeleteAction.ID);
        actions.add("SUBMENU_START_ID: " + Messages._UI_ACTION_SET_MESSAGE);
        actions.add(W11SetNewMessageAction.ID);
        actions.add(W11SetExistingMessageAction.ID);
        actions.add("SUBMENU_END_ID: ");
        String[] actionIDs = new String[actions.size()];
        int index = 0;
        while (index < actions.size()) {
            actionIDs[index] = (String)actions.get(index);
            ++index;
        }
        return actionIDs;
    }

    public Command getReorderParametersCommand(IParameter leftSibling, IParameter rightSibling, IParameter movingParameter) {
        return new W11ReorderParametersCommand(leftSibling, rightSibling, movingParameter);
    }

    public Command getAddParamterCommand() {
        W11TopLevelElementCommand command = null;
        Operation operation = (Operation)this.getMessageReference().eContainer();
        command = this.getKind() == 1 ? new W11AddInputParameterCommand(operation) : (this.getKind() == 2 ? new W11AddOutputParameterCommand(operation) : new W11AddFaultParameterCommand(operation, (Fault)this.getMessageReference()));
        return command;
    }

    public Image getImage() {
        if (this.getKind() == 1) {
            return WSDLEditorPlugin.getInstance().getImage("icons/input_obj.gif");
        }
        if (this.getKind() == 2) {
            return WSDLEditorPlugin.getInstance().getImage("icons/output_obj.gif");
        }
        if (this.getKind() == 3) {
            return WSDLEditorPlugin.getInstance().getImage("icons/fault_obj.gif");
        }
        return null;
    }

    public String getText() {
        if (this.getKind() == 1) {
            return "input";
        }
        if (this.getKind() == 2) {
            return "output";
        }
        if (this.getKind() == 3) {
            return this.getName();
        }
        return "";
    }

    public List getParameters2() {
        return this.getSimplifiedDiagnosticMessages();
    }

    public List getSimplifiedParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
            this.otherThingsToListenTo = new ArrayList();
            WSDLVisitorForParameters visitorForParameters = new WSDLVisitorForParameters();
            visitorForParameters.visitMessageReference(this.getMessageReference());
            this.populateAdapterList(visitorForParameters.concreteComponents, this.parameters);
            this.populateAdapterList(visitorForParameters.thingsToListenTo, this.otherThingsToListenTo);
            Iterator i = this.otherThingsToListenTo.iterator();
            while (i.hasNext()) {
                Adapter adapter = (Adapter)i.next();
                if (!(adapter instanceof IASDObject)) continue;
                IASDObject asdObject = (IASDObject)adapter;
                asdObject.registerListener(this);
            }
        }
        return this.parameters;
    }

    public ITreeElement[] getChildren() {
        return ITreeElement.EMPTY_LIST;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public ITreeElement getParent() {
        return null;
    }

    private void processAdvancedW11MessageReference() {
        this.diagnosticMessages = new ArrayList();
        MessageReference messageRef = (MessageReference)this.getTarget();
        EList parts = new ArrayList();
        if (messageRef.getEMessage() != null && messageRef.getEMessage().getEParts() != null) {
            parts = messageRef.getEMessage().getEParts();
        }
        if (messageRef.getEMessage() == null) {
            this.addErrorDiagnosticMessage(this.getUndefinedArg1String("message"));
        } else if (parts.size() <= 0) {
            Object[] args = new String[]{"part"};
            this.addWarningDiagnosticMessage(this.getStringForKey("_UI_LABEL_NO_OBJECT_SPECIFIED_ARG1", args));
        }
    }

    private void processSimplifiedW11MessageReference() {
        this.diagnosticMessages = new ArrayList();
        MessageReference messageRef = (MessageReference)this.getTarget();
        if (messageRef == null || messageRef.getEMessage() == null) {
            this.addErrorDiagnosticMessage(this.getUndefinedArg1String("message"));
        } else if (messageRef.getEMessage().getEParts().size() <= 0) {
            this.addWarningDiagnosticMessage(this.getNoParametersSpecifiedString());
        } else {
            Part part = (Part)messageRef.getEMessage().getEParts().get(0);
            XSDElementDeclaration xsdElement = part.getElementDeclaration();
            if (xsdElement == null || xsdElement.getSchema() == null) {
                this.addErrorDiagnosticMessage(this.getUndefinedArg1String("element"));
            } else {
                MyInnerElementVisitor visitor = new MyInnerElementVisitor();
                visitor.findErrorsAndWarnings(xsdElement);
                this.diagnosticMessages.addAll(visitor.getDiagnosticMessages());
            }
        }
    }

    private void addErrorDiagnosticMessage(String txt) {
        this.diagnosticMessages.add(new ModelDiagnosticInfo(txt, ModelDiagnosticInfo.ERROR_TYPE, null));
    }

    private void addWarningDiagnosticMessage(String txt) {
        this.diagnosticMessages.add(new ModelDiagnosticInfo(txt, ModelDiagnosticInfo.WARNING_TYPE, null));
    }

    public List getDiagnosticMessages() {
        this.processAdvancedW11MessageReference();
        return this.diagnosticMessages;
    }

    public List getSimplifiedDiagnosticMessages() {
        this.processSimplifiedW11MessageReference();
        return this.diagnosticMessages;
    }

    private String getUndefinedArg1String(String arg) {
        Object[] args = new String[]{arg};
        String newString = this.getStringForKey("_UI_LABEL_UNDEFINED_ARG1", args);
        return newString;
    }

    private String getNoParametersSpecifiedString() {
        String string = null;
        Object[] args = new String[]{};
        string = this.getStringForKey("_UI_LABEL_NO_PARAMETERS_SPECIFIED", args);
        return string;
    }

    private String getStringForKey(String key, Object[] args) {
        String newString = "";
        newString = Messages.getString(key, args);
        ProductCustomizationProvider object = WSDLEditorPlugin.getInstance().getProductCustomizationProvider();
        if (object instanceof ProductCustomizationProvider) {
            ProductCustomizationProvider productCustomizationProvider = object;
            String customizedString = "";
            customizedString = args == null ? productCustomizationProvider.getProductString(key) : productCustomizationProvider.getProductString(key, args);
            if (customizedString != null && !customizedString.equals("")) {
                newString = customizedString;
            }
        }
        if (newString == null) {
            newString = "";
        }
        return newString;
    }

    private class MyInnerElementVisitor
    extends W11FindInnerElementVisitor {
        private List diagMessages = new ArrayList();

        private MyInnerElementVisitor() {
        }

        public void findErrorsAndWarnings(XSDElementDeclaration xsdElement) {
            XSDElementDeclaration innerElement;
            if (xsdElement.getTypeDefinition() == null || xsdElement.getTypeDefinition().getSchema() == null) {
                this.diagMessages.add(new ModelDiagnosticInfo(W11MessageReference.this.getUndefinedArg1String("type"), ModelDiagnosticInfo.ERROR_TYPE, null));
            }
            if ((innerElement = super.getInnerXSDElement(xsdElement)).equals(xsdElement)) {
                this.diagMessages.add(new ModelDiagnosticInfo(W11MessageReference.this.getNoParametersSpecifiedString(), ModelDiagnosticInfo.WARNING_TYPE, null));
            }
        }

        public List getDiagnosticMessages() {
            return this.diagMessages;
        }
    }
}

