/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.util.IOpenExternalEditorHelper;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.wst.xsd.ui.internal.dialogs.IOpenInNewEditor;
import org.eclipse.wst.xsd.ui.internal.dialogs.XSDGraphViewerDialog;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;

public class W11OpenExternalEditorHelper
implements IOpenExternalEditorHelper,
IOpenInNewEditor {
    private Object object;
    private IFile wsdlFile;

    public W11OpenExternalEditorHelper(IFile wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public void setModel(Object object) {
        this.object = object;
    }

    public void openExternalEditor() {
        Notifier notifier;
        Object openOnModel;
        if (this.object instanceof WSDLBaseAdapter && (openOnModel = this.getModelToOpenOn(notifier = ((WSDLBaseAdapter)this.object).getTarget())) instanceof XSDConcreteComponent) {
            XSDConcreteComponent xsdComponent = (XSDConcreteComponent)openOnModel;
            XSDSchema schema = this.getSchema(xsdComponent);
            if (schema.eResource() instanceof WSDLResourceImpl) {
                String fileName = schema.eResource().getURI().lastSegment();
                if (fileName == null) {
                    fileName = "WSDL";
                }
                String editorName = String.valueOf(Messages._UI_LABEL_INLINE_SCHEMA_OF) + fileName;
                XSDGraphViewerDialog.openNonXSDResourceSchema((XSDConcreteComponent)xsdComponent, (XSDSchema)schema, (String)editorName);
            } else {
                XSDGraphViewerDialog.openXSDEditor((XSDConcreteComponent)xsdComponent);
            }
        }
    }

    public void openXSDEditor() {
        this.openExternalEditor();
    }

    protected XSDSchema getSchema(XSDConcreteComponent xsdComponent) {
        Notifier notifier;
        XSDSchema schema = xsdComponent.getSchema();
        if (schema == null && (notifier = ((WSDLBaseAdapter)this.object).getTarget()) instanceof XSDConcreteComponent) {
            schema = ((XSDConcreteComponent)notifier).getSchema();
        }
        return schema;
    }

    public boolean linkApplicable() {
        IParameter param;
        String prefix;
        boolean applicable = true;
        if (this.object instanceof IParameter && (prefix = (param = (IParameter)this.object).getComponentNameQualifier()) != null && prefix.equals("http://www.w3.org/2001/XMLSchema")) {
            applicable = false;
        }
        return applicable;
    }

    protected Object getModelToOpenOn(Object object) {
        if (object instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElement = ((XSDElementDeclaration)object).getResolvedElementDeclaration();
            return xsdElement.getTypeDefinition();
        }
        if (object instanceof Part) {
            XSDElementDeclaration elementOrType = ((Part)object).getElementDeclaration();
            if (elementOrType == null) {
                elementOrType = ((Part)object).getTypeDefinition();
            }
            return elementOrType;
        }
        return object;
    }

    protected boolean isInlineSchema(IFile file) {
        return file.getFullPath().equals((Object)this.wsdlFile.getFullPath());
    }

    public boolean isValid() {
        XSDConcreteComponent xsdComponent;
        XSDSchema schema;
        Notifier notifier;
        Object openOnModel;
        if (this.object instanceof WSDLBaseAdapter && (openOnModel = this.getModelToOpenOn(notifier = ((WSDLBaseAdapter)this.object).getTarget())) instanceof XSDConcreteComponent && ((XSDConcreteComponent)openOnModel).getElement() != null && (schema = this.getSchema(xsdComponent = (XSDConcreteComponent)openOnModel)) != null) {
            String schemaLocation = URIHelper.removePlatformResourceProtocol((String)schema.getSchemaLocation());
            Path schemaPath = new Path(schemaLocation);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
            if (file != null && file.exists()) {
                return true;
            }
        }
        return false;
    }

    public void showPreview() {
        Object xsdModel = null;
        String title = "";
        String info = "";
        Notifier notifier = ((WSDLBaseAdapter)this.object).getTarget();
        xsdModel = this.getModelToOpenOn(notifier);
        if (xsdModel instanceof XSDNamedComponent) {
            XSDNamedComponent namedComponent = (XSDNamedComponent)xsdModel;
            title = namedComponent.getName();
            info = namedComponent.getTargetNamespace();
        }
        if (this.isValid() && xsdModel != null) {
            XSDGraphViewerDialog dialog = new XSDGraphViewerDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, info, xsdModel, "org.eclipse.wst.wsdl.ui.preview");
            dialog.setOpenExternalEditor((IOpenInNewEditor)this);
            dialog.open();
        }
    }
}

