/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

public final class FloatInfo {
    private float _value = 0.0f;
    private String _identifier = null;
    private short _type = 0;

    public FloatInfo(String text) {
        this.parse(text);
    }

    void parse(String text) {
        StringBuffer bufValue = new StringBuffer();
        StringBuffer bufIdent = new StringBuffer();
        boolean bNum = true;
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (bNum) {
                if ('0' <= c && c <= '9' || c == '.' || c == '+' || c == '-') {
                    bufValue.append(c);
                } else {
                    bufIdent.append(c);
                    bNum = false;
                }
            } else {
                bufIdent.append(c);
            }
            ++i;
        }
        String valueStr = bufValue.toString();
        this._value = Float.valueOf(valueStr).floatValue();
        this._identifier = bufIdent.toString();
        this._type = FloatInfo.getFloatValueType(valueStr, this._identifier);
    }

    public float getValue() {
        return this._value;
    }

    String getIdentifier() {
        return this._identifier;
    }

    public short getValueType() {
        return this._type;
    }

    static short getFloatValueType(String value, String ident) {
        int valueType = (ident = ident.toLowerCase()).length() == 0 ? (value.indexOf(46) >= 0 ? 1 : 26) : (ident.equals("%") ? 2 : (ident.equalsIgnoreCase("em") ? 3 : (ident.equalsIgnoreCase("ex") ? 4 : (ident.equalsIgnoreCase("px") ? 5 : (ident.equalsIgnoreCase("cm") ? 6 : (ident.equalsIgnoreCase("mm") ? 7 : (ident.equalsIgnoreCase("in") ? 8 : (ident.equalsIgnoreCase("pt") ? 9 : (ident.equalsIgnoreCase("pc") ? 10 : (ident.equalsIgnoreCase("deg") ? 11 : (ident.equalsIgnoreCase("rad") ? 12 : (ident.equalsIgnoreCase("grad") ? 13 : (ident.equalsIgnoreCase("ms") ? 14 : (ident.equalsIgnoreCase("s") ? 15 : (ident.equalsIgnoreCase("hz") ? 16 : (ident.equalsIgnoreCase("khz") ? 17 : 18))))))))))))))));
        return (short)valueType;
    }
}

