/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;

public class HTMLSpecialCharHelper {
    private static Logger _log = PDPlugin.getLogger(HTMLSpecialCharHelper.class);
    private static Hashtable _table = new Hashtable(256);
    private static Hashtable _reverse;

    static {
        _table.put(new Integer(34), "&quot;");
        _table.put(new Integer(38), "&amp;");
        _table.put(new Integer(60), "&lt;");
        _table.put(new Integer(62), "&gt;");
        _table.put(new Integer(160), "&nbsp;");
        _table.put(new Integer(161), "&iexcl;");
        _table.put(new Integer(162), "&cent;");
        _table.put(new Integer(163), "&pound;");
        _table.put(new Integer(164), "&curren;");
        _table.put(new Integer(165), "&yen;");
        _table.put(new Integer(166), "&brvbar;");
        _table.put(new Integer(167), "&sect;");
        _table.put(new Integer(168), "&uml;");
        _table.put(new Integer(169), "&copy;");
        _table.put(new Integer(170), "&ordf;");
        _table.put(new Integer(171), "&laquo;");
        _table.put(new Integer(172), "&not;");
        _table.put(new Integer(173), "&shy;");
        _table.put(new Integer(174), "&reg;");
        _table.put(new Integer(175), "&macr;");
        _table.put(new Integer(176), "&deg;");
        _table.put(new Integer(177), "&plusmn;");
        _table.put(new Integer(178), "&sup2;");
        _table.put(new Integer(179), "&sup3;");
        _table.put(new Integer(180), "&acute;");
        _table.put(new Integer(181), "&micro;");
        _table.put(new Integer(182), "&para;");
        _table.put(new Integer(183), "&middot;");
        _table.put(new Integer(184), "&cedil;");
        _table.put(new Integer(185), "&sup1;");
        _table.put(new Integer(186), "&ordm;");
        _table.put(new Integer(187), "&raquo;");
        _table.put(new Integer(188), "&frac14;");
        _table.put(new Integer(189), "&frac12;");
        _table.put(new Integer(190), "&frac34;");
        _table.put(new Integer(191), "&iquest;");
        _table.put(new Integer(192), "&Agrave;");
        _table.put(new Integer(193), "&Aacute;");
        _table.put(new Integer(194), "&Acirc;");
        _table.put(new Integer(195), "&Atilde;");
        _table.put(new Integer(196), "&Auml;");
        _table.put(new Integer(197), "&Aring;");
        _table.put(new Integer(198), "&AElig;");
        _table.put(new Integer(199), "&Ccedil;");
        _table.put(new Integer(200), "&Egrave;");
        _table.put(new Integer(201), "&Eacute;");
        _table.put(new Integer(202), "&Ecirc;");
        _table.put(new Integer(203), "&Euml;");
        _table.put(new Integer(204), "&Igrave;");
        _table.put(new Integer(205), "&Iacute;");
        _table.put(new Integer(206), "&Icirc;");
        _table.put(new Integer(207), "&Iuml;");
        _table.put(new Integer(208), "&ETH;");
        _table.put(new Integer(209), "&Ntilde;");
        _table.put(new Integer(210), "&Ograve;");
        _table.put(new Integer(211), "&Oacute;");
        _table.put(new Integer(212), "&Ocirc;");
        _table.put(new Integer(213), "&Otilde;");
        _table.put(new Integer(214), "&Ouml;");
        _table.put(new Integer(215), "&times;");
        _table.put(new Integer(216), "&Oslash;");
        _table.put(new Integer(217), "&Ugrave;");
        _table.put(new Integer(218), "&Uacute;");
        _table.put(new Integer(219), "&Ucirc;");
        _table.put(new Integer(220), "&Uuml;");
        _table.put(new Integer(221), "&Yacute;");
        _table.put(new Integer(222), "&THORN;");
        _table.put(new Integer(223), "&szlig;");
        _table.put(new Integer(224), "&agrave;");
        _table.put(new Integer(225), "&aacute;");
        _table.put(new Integer(226), "&acirc;");
        _table.put(new Integer(227), "&atilde;");
        _table.put(new Integer(228), "&auml;");
        _table.put(new Integer(229), "&aring;");
        _table.put(new Integer(230), "&aelig;");
        _table.put(new Integer(231), "&ccedil;");
        _table.put(new Integer(232), "&egrave;");
        _table.put(new Integer(233), "&eacute;");
        _table.put(new Integer(234), "&ecirc;");
        _table.put(new Integer(235), "&euml;");
        _table.put(new Integer(236), "&igrave;");
        _table.put(new Integer(237), "&iacute;");
        _table.put(new Integer(238), "&icirc;");
        _table.put(new Integer(239), "&iuml;");
        _table.put(new Integer(240), "&eth;");
        _table.put(new Integer(241), "&ntilde;");
        _table.put(new Integer(242), "&ograve;");
        _table.put(new Integer(243), "&oacute;");
        _table.put(new Integer(244), "&ocirc;");
        _table.put(new Integer(245), "&otilde;");
        _table.put(new Integer(246), "&ouml;");
        _table.put(new Integer(247), "&divide;");
        _table.put(new Integer(248), "&oslash;");
        _table.put(new Integer(249), "&ugrave;");
        _table.put(new Integer(250), "&uacute;");
        _table.put(new Integer(251), "&ucirc;");
        _table.put(new Integer(252), "&uuml;");
        _table.put(new Integer(253), "&yacute;");
        _table.put(new Integer(254), "&thorn;");
        _table.put(new Integer(255), "&yuml;");
        _table.put(new Integer(402), "&fnof;");
        _table.put(new Integer(913), "&Alpha;");
        _table.put(new Integer(914), "&Beta;");
        _table.put(new Integer(915), "&Gamma;");
        _table.put(new Integer(916), "&Delta;");
        _table.put(new Integer(917), "&Epsilon;");
        _table.put(new Integer(918), "&Zeta;");
        _table.put(new Integer(919), "&Eta;");
        _table.put(new Integer(920), "&Theta;");
        _table.put(new Integer(921), "&Iota;");
        _table.put(new Integer(922), "&Kappa;");
        _table.put(new Integer(923), "&Lambda;");
        _table.put(new Integer(924), "&Mu;");
        _table.put(new Integer(925), "&Nu;");
        _table.put(new Integer(926), "&Xi;");
        _table.put(new Integer(927), "&Omicron;");
        _table.put(new Integer(928), "&Pi;");
        _table.put(new Integer(929), "&Rho;");
        _table.put(new Integer(931), "&Sigma;");
        _table.put(new Integer(932), "&Tau;");
        _table.put(new Integer(933), "&Upsilon;");
        _table.put(new Integer(934), "&Phi;");
        _table.put(new Integer(935), "&Chi;");
        _table.put(new Integer(936), "&Psi;");
        _table.put(new Integer(937), "&Omega;");
        _table.put(new Integer(945), "&alpha;");
        _table.put(new Integer(946), "&beta;");
        _table.put(new Integer(947), "&gamma;");
        _table.put(new Integer(948), "&delta;");
        _table.put(new Integer(949), "&epsilon;");
        _table.put(new Integer(950), "&zeta;");
        _table.put(new Integer(951), "&eta;");
        _table.put(new Integer(952), "&theta;");
        _table.put(new Integer(953), "&iota;");
        _table.put(new Integer(954), "&kappa;");
        _table.put(new Integer(955), "&lambda;");
        _table.put(new Integer(956), "&mu;");
        _table.put(new Integer(957), "&nu;");
        _table.put(new Integer(958), "&xi;");
        _table.put(new Integer(959), "&omicron;");
        _table.put(new Integer(960), "&pi;");
        _table.put(new Integer(961), "&rho;");
        _table.put(new Integer(962), "&sigmaf;");
        _table.put(new Integer(963), "&sigma;");
        _table.put(new Integer(964), "&tau;");
        _table.put(new Integer(965), "&upsilon;");
        _table.put(new Integer(966), "&phi;");
        _table.put(new Integer(967), "&chi;");
        _table.put(new Integer(968), "&psi;");
        _table.put(new Integer(969), "&omega;");
        _table.put(new Integer(977), "&thetasym;");
        _table.put(new Integer(978), "&upsih;");
        _table.put(new Integer(982), "&piv;");
        _table.put(new Integer(8226), "&bull;");
        _table.put(new Integer(8230), "&hellip;");
        _table.put(new Integer(8242), "&prime;");
        _table.put(new Integer(8243), "&Prime;");
        _table.put(new Integer(8254), "&oline;");
        _table.put(new Integer(8260), "&frasl;");
        _table.put(new Integer(8472), "&weierp;");
        _table.put(new Integer(8465), "&image;");
        _table.put(new Integer(8476), "&real;");
        _table.put(new Integer(8482), "&trade;");
        _table.put(new Integer(8501), "&alefsym;");
        _table.put(new Integer(8592), "&larr;");
        _table.put(new Integer(8593), "&uarr;");
        _table.put(new Integer(8594), "&rarr;");
        _table.put(new Integer(8595), "&darr;");
        _table.put(new Integer(8596), "&harr;");
        _table.put(new Integer(8629), "&crarr;");
        _table.put(new Integer(8656), "&lArr;");
        _table.put(new Integer(8657), "&uArr;");
        _table.put(new Integer(8658), "&rArr;");
        _table.put(new Integer(8659), "&dArr;");
        _table.put(new Integer(8660), "&hArr;");
        _table.put(new Integer(8704), "&forall;");
        _table.put(new Integer(8706), "&part;");
        _table.put(new Integer(8707), "&exist;");
        _table.put(new Integer(8709), "&empty;");
        _table.put(new Integer(8711), "&nabla;");
        _table.put(new Integer(8712), "&isin;");
        _table.put(new Integer(8713), "&notin;");
        _table.put(new Integer(8715), "&ni;");
        _table.put(new Integer(8719), "&prod;");
        _table.put(new Integer(8722), "&sum;");
        _table.put(new Integer(8722), "&minus;");
        _table.put(new Integer(8727), "&lowast;");
        _table.put(new Integer(8730), "&radic;");
        _table.put(new Integer(8733), "&prop;");
        _table.put(new Integer(8734), "&infin;");
        _table.put(new Integer(8736), "&ang;");
        _table.put(new Integer(8869), "&and;");
        _table.put(new Integer(8870), "&or;");
        _table.put(new Integer(8745), "&cap;");
        _table.put(new Integer(8746), "&cup;");
        _table.put(new Integer(8747), "&int;");
        _table.put(new Integer(8756), "&there4;");
        _table.put(new Integer(8764), "&sim;");
        _table.put(new Integer(8773), "&cong;");
        _table.put(new Integer(8773), "&asymp;");
        _table.put(new Integer(8800), "&ne;");
        _table.put(new Integer(8801), "&equiv;");
        _table.put(new Integer(8804), "&le;");
        _table.put(new Integer(8805), "&ge;");
        _table.put(new Integer(8834), "&sub;");
        _table.put(new Integer(8835), "&sup;");
        _table.put(new Integer(8836), "&nsub;");
        _table.put(new Integer(8838), "&sube;");
        _table.put(new Integer(8839), "&supe;");
        _table.put(new Integer(8853), "&oplus;");
        _table.put(new Integer(8855), "&otimes;");
        _table.put(new Integer(8869), "&perp;");
        _table.put(new Integer(8901), "&sdot;");
        _table.put(new Integer(8968), "&lceil;");
        _table.put(new Integer(8969), "&rceil;");
        _table.put(new Integer(8970), "&lfloor;");
        _table.put(new Integer(8971), "&rfloor;");
        _table.put(new Integer(9001), "&lang;");
        _table.put(new Integer(9002), "&rang;");
        _table.put(new Integer(9674), "&loz;");
        _table.put(new Integer(9824), "&spades;");
        _table.put(new Integer(9827), "&clubs;");
        _table.put(new Integer(9829), "&hearts;");
        _table.put(new Integer(9830), "&diams;");
        _table.put(new Integer(338), "&OElig;");
        _table.put(new Integer(339), "&oelig;");
        _table.put(new Integer(352), "&Scaron;");
        _table.put(new Integer(353), "&scaron;");
        _table.put(new Integer(376), "&Yuml;");
        _table.put(new Integer(710), "&circ;");
        _table.put(new Integer(732), "&tilde;");
        _table.put(new Integer(8194), "&ensp;");
        _table.put(new Integer(8195), "&emsp;");
        _table.put(new Integer(8201), "&thinsp;");
        _table.put(new Integer(8204), "&zwnj;");
        _table.put(new Integer(8205), "&zwj;");
        _table.put(new Integer(8206), "&lrm;");
        _table.put(new Integer(8207), "&rlm;");
        _table.put(new Integer(8211), "&ndash;");
        _table.put(new Integer(151), "&mdash;");
        _table.put(new Integer(8216), "&lsquo;");
        _table.put(new Integer(8217), "&rsquo;");
        _table.put(new Integer(8218), "&sbquo;");
        _table.put(new Integer(8220), "&ldquo;");
        _table.put(new Integer(8221), "&rdquo;");
        _table.put(new Integer(8222), "&bdquo;");
        _table.put(new Integer(8224), "&dagger;");
        _table.put(new Integer(8225), "&Dagger;");
        _table.put(new Integer(8240), "&permil;");
        _table.put(new Integer(8249), "&lsaquo;");
        _table.put(new Integer(8250), "&rsaquo;");
        _table.put(new Integer(8364), "&euro;");
        _reverse = new Hashtable(256);
        Enumeration e = _table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = (String)_table.get(key);
            _reverse.put(value, key);
            _reverse.put(value.substring(0, value.length() - 1), key);
        }
    }

    public static String getSpecial(int ch) {
        return (String)_table.get(new Integer(ch));
    }

    public static int getSpecial(String str) {
        Integer result = (Integer)_reverse.get(str);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public static void encode(String str, int start, int end, Writer writer) throws IOException {
        int i = start;
        while (i < end) {
            char ch = str.charAt(i);
            String special = HTMLSpecialCharHelper.getSpecial(ch);
            if (special != null) {
                writer.write(special);
            } else if ((ch & 0xFF) != 0) {
                writer.write("&#");
                writer.write(Integer.toString(ch));
                writer.write(";");
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    public static StringBuffer encode(String str, StringBuffer result) {
        return HTMLSpecialCharHelper.encode(str, 0, str.length(), result);
    }

    public static StringBuffer encode(String str, int start, int end, StringBuffer result) {
        int i = start;
        while (i < end) {
            char ch = str.charAt(i);
            String special = HTMLSpecialCharHelper.getSpecial(ch);
            if (special != null) {
                result.append(special);
            } else if ((ch & 0xFF00) != 0) {
                result.append("&#");
                result.append(Integer.toString(ch));
                result.append(";");
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result;
    }

    public static StringBuffer decode(String str, StringBuffer buffer) throws RuntimeException {
        return HTMLSpecialCharHelper.decode(str, 0, str.length(), buffer);
    }

    public static StringBuffer decode(String str, int start, int end, StringBuffer buffer) throws RuntimeException {
        int pos = start;
        do {
            char ch;
            if ((ch = str.charAt(pos)) == '&') {
                int stop = str.indexOf(59, pos + 1);
                if (stop < 0 || stop >= end) {
                    _log.error("HTMLSpecialCharHelper.3");
                    throw new RuntimeException("HTMLSpecialCharHelper.2");
                }
                String sp = str.substring(pos, stop + 1);
                int special = HTMLSpecialCharHelper.getSpecial(sp);
                if (special != -1) {
                    buffer.append((char)special);
                } else {
                    ch = sp.charAt(1);
                    if (ch != '#') {
                        throw new RuntimeException("HTMLSpecialCharHelper.1");
                    }
                    try {
                        buffer.append((char)Integer.parseInt(sp.substring(2, sp.length() - 1)));
                    }
                    catch (NumberFormatException ex) {
                        _log.info("HTMLSpecialCharHelper.0", (Throwable)ex);
                        throw new RuntimeException("illegal: " + sp);
                    }
                }
                pos = stop + 1;
                continue;
            }
            buffer.append(ch);
            ++pos;
        } while (pos < end);
        return buffer;
    }

    public static int decodeEntity(String entityRef) {
        Integer result = (Integer)_reverse.get(entityRef);
        if (result != null) {
            return result;
        }
        if (entityRef.length() >= 2 && entityRef.charAt(1) == '#') {
            String s = entityRef.substring(2);
            if (s.endsWith(";")) {
                s = s.substring(0, s.length() - 1);
            }
            try {
                return Integer.parseInt(s);
            }
            catch (Exception exception) {}
        }
        return -1;
    }
}

