/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dDebugOptions;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RouterHelper;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class ObliqueRouter
extends BendpointConnectionRouter {
    private ArrayListMap selfRelConnections = new ArrayListMap();
    private ArrayListMap intersectingShapesConnections = new ArrayListMap();
    public static final int ROUTER_FLAG_SKIPNORMALIZATION = 1;
    protected int routerFlags = 0;
    protected static final int SELFRELSIZEINIT = 62;
    protected static final int SELFRELSIZEINCR = 10;

    public boolean isAvoidingObstructions(Connection conn) {
        if (conn instanceof PolylineConnectionEx) {
            return ((PolylineConnectionEx)conn).isAvoidObstacleRouting();
        }
        return false;
    }

    public boolean isClosestDistance(Connection conn) {
        if (conn instanceof PolylineConnectionEx) {
            return ((PolylineConnectionEx)conn).isClosestDistanceRouting();
        }
        return false;
    }

    protected boolean isReorienting(Connection conn) {
        return conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor().getOwner() == null;
    }

    public final void route(Connection conn) {
        if (conn.isVisible()) {
            this.routeBendpoints(conn);
        }
    }

    public void routeBendpoints(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        PointList points = this.calculateBendPoints(conn);
        this.routeLine(conn, 0, points);
        conn.setPoints(points);
    }

    protected PointList calculateBendPoints(Connection conn) {
        PointList points = new PointList();
        points = this.isAvoidingObstructions(conn) ? RouterHelper.getInstance().routeAroundObstructions(conn) : (this.isClosestDistance(conn) ? RouterHelper.getInstance().routeClosestDistance(conn) : RouterHelper.getInstance().routeFromConstraint(conn));
        return points;
    }

    protected boolean removePointsInViews(Connection conn, PointList newLine) {
        boolean bChanged = false;
        if (conn == null || newLine == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            Trace.throwing((Plugin)Draw2dPlugin.getInstance(), (String)Draw2dDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"removePointsInViews()", (Throwable)iae);
            throw iae;
        }
        if (newLine.size() < 3) {
            return false;
        }
        IFigure sourceOwner = conn.getSourceAnchor().getOwner();
        IFigure targetOwner = conn.getTargetAnchor().getOwner();
        if (sourceOwner == null) {
            return false;
        }
        if (targetOwner == null) {
            return false;
        }
        PointList startPolygon = null;
        if (!(sourceOwner instanceof Connection)) {
            startPolygon = this.getFigurePolygon(sourceOwner, conn);
        }
        PointList endPolygon = null;
        if (!(targetOwner instanceof Connection)) {
            endPolygon = this.getFigurePolygon(targetOwner, conn);
        }
        PointList newPoints = new PointList(newLine.size());
        int i = 0;
        while (i < newLine.size()) {
            Point pt = newLine.getPoint(i);
            if (i == 0 || i == newLine.size() - 1) {
                newPoints.addPoint(pt);
            } else if (!(startPolygon != null && PointListUtilities.containsPoint(startPolygon, pt) || endPolygon != null && PointListUtilities.containsPoint(endPolygon, pt))) {
                newPoints.addPoint(pt);
            } else {
                bChanged = true;
            }
            ++i;
        }
        if (newPoints.size() != newLine.size()) {
            newLine.removeAllPoints();
            i = 0;
            while (i < newPoints.size()) {
                newLine.addPoint(new Point(newPoints.getPoint(i)));
                ++i;
            }
        }
        return bChanged;
    }

    protected PointList getFigurePolygon(IFigure owner, Connection conn) {
        PointList polygon = new PointList();
        if (owner instanceof IPolygonAnchorableFigure) {
            PointList points = ((IPolygonAnchorableFigure)owner).getPolygonPoints();
            int index = 0;
            while (index < points.size()) {
                Point point = points.getPoint(index).getCopy();
                owner.translateToAbsolute((Translatable)point);
                conn.translateToRelative((Translatable)point);
                polygon.addPoint(point);
                ++index;
            }
        } else {
            Rectangle rect = owner.getBounds().getCopy();
            owner.translateToAbsolute((Translatable)rect);
            conn.translateToRelative((Translatable)rect);
            polygon.addPoint(rect.getTopLeft());
            polygon.addPoint(rect.getTopRight());
            polygon.addPoint(rect.getBottomRight());
            polygon.addPoint(rect.getBottomLeft());
            polygon.addPoint(rect.getTopLeft());
        }
        return polygon;
    }

    public void routeLine(Connection conn, int nestedRoutingDepth, PointList newLine) {
        if (!this.checkSelfRelConnection(conn, newLine) && !this.checkShapesIntersect(conn, newLine)) {
            this.removePointsInViews(conn, newLine);
        }
        this.resetEndPointsToEdge(conn, newLine);
    }

    protected boolean checkShapesIntersect(Connection conn, PointList newLine) {
        if (conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor().getOwner() == null) {
            return false;
        }
        if (newLine.size() < 3) {
            PrecisionRectangle sourceBounds = new PrecisionRectangle(conn.getSourceAnchor().getOwner().getBounds());
            PrecisionRectangle targetBounds = new PrecisionRectangle(conn.getTargetAnchor().getOwner().getBounds());
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)sourceBounds);
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)targetBounds);
            if (sourceBounds.intersects((Rectangle)targetBounds) && !sourceBounds.contains((Rectangle)targetBounds) && !targetBounds.contains((Rectangle)sourceBounds)) {
                this.getVerticesForIntersectingShapes(conn, newLine);
                return true;
            }
        } else {
            this.removeIntersectingShapesConnection(conn);
        }
        return false;
    }

    private int getSourcePositionFromConnectionRectangle(Rectangle connRectangle, Rectangle sourceRect, int position) {
        Dimension diff = null;
        switch (position) {
            case 9: {
                diff = connRectangle.getBottomRight().getDifference(sourceRect.getTopLeft());
                if (diff.width == 0) {
                    return 16;
                }
                return 4;
            }
            case 17: {
                diff = connRectangle.getBottomLeft().getDifference(sourceRect.getTopRight());
                if (diff.width == 0) {
                    return 8;
                }
                return 4;
            }
            case 20: {
                diff = connRectangle.getTopLeft().getDifference(sourceRect.getBottomRight());
                if (diff.width == 0) {
                    return 8;
                }
                return 1;
            }
            case 12: {
                diff = connRectangle.getTopRight().getDifference(sourceRect.getBottomLeft());
                if (diff.width == 0) {
                    return 16;
                }
                return 1;
            }
        }
        return 0;
    }

    private void getConnectionPoints(Rectangle connRect, int position, int sourcePosition, PointList line) {
        line.removeAllPoints();
        switch (position) {
            case 9: {
                if (sourcePosition == 16) {
                    line.addPoint(connRect.getTopRight());
                    line.addPoint(connRect.getTopLeft());
                    line.addPoint(connRect.getBottomLeft());
                    break;
                }
                line.addPoint(connRect.getBottomLeft());
                line.addPoint(connRect.getTopLeft());
                line.addPoint(connRect.getTopRight());
                break;
            }
            case 17: {
                if (sourcePosition == 8) {
                    line.addPoint(connRect.getTopLeft());
                    line.addPoint(connRect.getTopRight());
                    line.addPoint(connRect.getBottomRight());
                    break;
                }
                line.addPoint(connRect.getBottomRight());
                line.addPoint(connRect.getTopRight());
                line.addPoint(connRect.getTopLeft());
                break;
            }
            case 20: {
                if (sourcePosition == 8) {
                    line.addPoint(connRect.getBottomLeft());
                    line.addPoint(connRect.getBottomRight());
                    line.addPoint(connRect.getTopRight());
                    break;
                }
                line.addPoint(connRect.getTopRight());
                line.addPoint(connRect.getBottomRight());
                line.addPoint(connRect.getBottomLeft());
                break;
            }
            case 12: {
                if (sourcePosition == 16) {
                    line.addPoint(connRect.getBottomRight());
                    line.addPoint(connRect.getBottomLeft());
                    line.addPoint(connRect.getTopLeft());
                    break;
                }
                line.addPoint(connRect.getTopLeft());
                line.addPoint(connRect.getBottomLeft());
                line.addPoint(connRect.getBottomRight());
            }
        }
    }

    private void absDimension(Dimension d) {
        d.width = Math.abs(d.width);
        d.height = Math.abs(d.height);
    }

    private void getVerticesForIntersectingShapes(Connection conn, PointList newLine) {
        Dimension diffVector;
        Object key = this.getIntersectingShapesConnectionKey(conn);
        int nSelfIncr = 0;
        int nIndex = 0;
        ArrayList connectionList = this.intersectingShapesConnections.get(key);
        if (connectionList != null) {
            if (!connectionList.contains(conn)) {
                this.intersectingShapesConnections.put(key, conn);
                connectionList = this.intersectingShapesConnections.get(key);
            }
            nIndex = connectionList.indexOf(conn);
            assert (nIndex >= 0);
        } else {
            this.intersectingShapesConnections.put(key, conn);
        }
        PrecisionPoint selfrelsizeincr = new PrecisionPoint(10, 0);
        boolean isFeedbackConn = RouterHelper.getInstance().isFeedback(conn);
        if (!isFeedbackConn) {
            selfrelsizeincr = (PrecisionPoint)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeincr);
        }
        IFigure sourceFig = conn.getSourceAnchor().getOwner();
        PrecisionRectangle sourceRect = new PrecisionRectangle(sourceFig.getBounds());
        sourceFig.translateToAbsolute((Translatable)sourceRect);
        conn.translateToRelative((Translatable)sourceRect);
        IFigure targetFig = conn.getTargetAnchor().getOwner();
        PrecisionRectangle targetRect = new PrecisionRectangle(targetFig.getBounds());
        targetFig.translateToAbsolute((Translatable)targetRect);
        conn.translateToRelative((Translatable)targetRect);
        PrecisionRectangle union = sourceRect.getPreciseCopy().union(targetRect);
        nSelfIncr = selfrelsizeincr.x * nIndex;
        Rectangle intersection = sourceRect.getCopy().intersect((Rectangle)targetRect);
        Rectangle connArea = new Rectangle();
        int position = 0;
        int minArea = 0;
        Point unionTopLeft = union.getTopLeft();
        Point unionTopRight = union.getTopRight();
        Point unionBottomRight = union.getBottomRight();
        Point unionBottomLeft = union.getBottomLeft();
        if (!unionTopLeft.equals((Object)sourceRect.getTopLeft()) && !unionTopLeft.equals((Object)targetRect.getTopLeft())) {
            diffVector = unionTopLeft.getDifference(intersection.getTopLeft());
            this.absDimension(diffVector);
            int areaTopLeft = diffVector.getArea();
            if (minArea == 0 || minArea > areaTopLeft) {
                position = 9;
                connArea.setSize(diffVector);
                connArea.setLocation(unionTopLeft.x, unionTopLeft.y);
                minArea = areaTopLeft;
            }
        }
        if (!unionTopRight.equals((Object)sourceRect.getTopRight()) && !unionTopRight.equals((Object)targetRect.getTopRight())) {
            diffVector = unionTopRight.getDifference(intersection.getTopRight());
            this.absDimension(diffVector);
            int areaTopRight = diffVector.getArea();
            if (minArea == 0 || minArea > areaTopRight) {
                position = 17;
                connArea.setSize(diffVector);
                connArea.setLocation(unionTopRight.x - connArea.width, unionTopRight.y);
                minArea = areaTopRight;
            }
        }
        if (!unionBottomRight.equals((Object)sourceRect.getBottomRight()) && !unionBottomRight.equals((Object)targetRect.getBottomRight())) {
            diffVector = unionBottomRight.getDifference(intersection.getBottomRight());
            this.absDimension(diffVector);
            int areaBottomRight = diffVector.getArea();
            if (minArea == 0 || minArea > areaBottomRight) {
                position = 20;
                connArea.setSize(diffVector);
                connArea.setLocation(unionBottomRight.x - connArea.width, unionBottomRight.y - connArea.height);
                minArea = areaBottomRight;
            }
        }
        if (!unionBottomLeft.equals((Object)sourceRect.getBottomLeft()) && !unionBottomLeft.equals((Object)targetRect.getBottomLeft())) {
            diffVector = unionBottomLeft.getDifference(intersection.getBottomLeft());
            this.absDimension(diffVector);
            int areaBottomLeft = diffVector.getArea();
            if (minArea == 0 || minArea > areaBottomLeft) {
                position = 12;
                connArea.setSize(diffVector);
                connArea.setLocation(unionBottomLeft.x, unionBottomLeft.y - connArea.height);
                minArea = areaBottomLeft;
            }
        }
        int sourcePosition = this.getSourcePositionFromConnectionRectangle(connArea, (Rectangle)sourceRect, position);
        PrecisionPoint translateExpansion = new PrecisionPoint(Math.max(connArea.width, connArea.height), 0);
        if (!isFeedbackConn) {
            IMapMode mm = MapModeUtil.getMapMode((IFigure)conn);
            translateExpansion = (PrecisionPoint)mm.LPtoDP((Translatable)translateExpansion);
            translateExpansion.preciseX = Math.pow(translateExpansion.preciseX, 0.8);
            translateExpansion = (PrecisionPoint)mm.DPtoLP((Translatable)translateExpansion);
        } else {
            translateExpansion.preciseX = Math.pow(translateExpansion.preciseX, 0.8);
        }
        translateExpansion.updateInts();
        this.getPrimaryPreciseConnectionArea(connArea, translateExpansion.x, position);
        connArea.expand(nSelfIncr, nSelfIncr);
        this.getConnectionPoints(connArea, position, sourcePosition, newLine);
        Point ptS2 = newLine.getPoint(0);
        Point ptS1 = conn.getSourceAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptS1);
        Point ptAbsS2 = new Point(ptS2);
        conn.translateToAbsolute((Translatable)ptAbsS2);
        Point ptEdge = conn.getSourceAnchor().getLocation(ptAbsS2);
        conn.translateToRelative((Translatable)ptEdge);
        ptS1 = ObliqueRouter.getStraightEdgePoint(ptEdge, ptS1, ptS2);
        Point ptE2 = newLine.getPoint(newLine.size() - 1);
        Point ptE1 = conn.getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptE1);
        Point ptAbsE2 = new Point(ptE2);
        conn.translateToAbsolute((Translatable)ptAbsE2);
        ptEdge = conn.getTargetAnchor().getLocation(ptAbsE2);
        conn.translateToRelative((Translatable)ptEdge);
        ptE1 = ObliqueRouter.getStraightEdgePoint(ptEdge, ptE1, ptE2);
        newLine.insertPoint(ptS1, 0);
        newLine.insertPoint(ptE1, newLine.size());
    }

    private void getPrimaryPreciseConnectionArea(Rectangle r, int size, int positionOfConnArea) {
        r.expand(size, size);
        if (r.width < r.height) {
            r.height -= size;
            if ((positionOfConnArea & 4) != 0) {
                r.y += size;
            }
        } else {
            r.width -= size;
            if ((positionOfConnArea & 0x10) != 0) {
                r.x += size;
            }
        }
    }

    protected static Point getStraightEdgePoint(Point ptEdge, Point ptRef1, Point ptRef2) {
        LineSeg lineSeg = new LineSeg(ptRef1, ptRef2);
        Point ptProj = lineSeg.perpIntersect(ptEdge.x, ptEdge.y);
        if (Math.abs(ptProj.x - ptRef2.x) < Math.abs(ptProj.y - ptRef2.y)) {
            ptProj.x = ptRef2.x;
        } else {
            ptProj.y = ptRef2.y;
        }
        return ptProj;
    }

    protected void resetEndPointsToEdge(Connection conn, PointList newLine) {
        RouterHelper.getInstance().resetEndPointsToEdge(conn, newLine);
    }

    protected boolean checkSelfRelConnection(Connection conn, PointList newLine) {
        if (conn.getSourceAnchor().getOwner() == conn.getTargetAnchor().getOwner() && newLine.size() < 4) {
            this.getSelfRelVertices(conn, newLine);
            return true;
        }
        this.removeSelfRelConnection(conn);
        return false;
    }

    private void removeSelfRelConnection(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null || conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor().getOwner() == null) {
            return;
        }
        ArrayListKey connectionKey = new ArrayListKey(conn);
        ArrayList connectionList = this.selfRelConnections.get(connectionKey);
        if (connectionList != null) {
            int index = connectionList.indexOf(conn);
            if (index == -1) {
                return;
            }
            this.selfRelConnections.remove(connectionKey, conn);
        }
    }

    private void removeIntersectingShapesConnection(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null || conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor().getOwner() == null) {
            return;
        }
        Object key = this.getIntersectingShapesConnectionKey(conn);
        ArrayList connectionList = this.intersectingShapesConnections.get(key);
        if (connectionList != null) {
            int index = connectionList.indexOf(conn);
            if (index == -1) {
                return;
            }
            this.intersectingShapesConnections.remove(key, conn);
        }
    }

    private Object getIntersectingShapesConnectionKey(Connection conn) {
        return new Integer(conn.getSourceAnchor().getOwner().hashCode() ^ conn.getTargetAnchor().getOwner().hashCode());
    }

    protected void getSelfRelVertices(Connection conn, PointList newLine) {
        if (conn.getSourceAnchor().getOwner() == null) {
            return;
        }
        ArrayListKey connectionKey = new ArrayListKey(conn);
        int nSelfIncr = 0;
        int nIndex = 0;
        ArrayList connectionList = this.selfRelConnections.get(connectionKey);
        if (connectionList != null) {
            if (!connectionList.contains(conn)) {
                this.selfRelConnections.put(connectionKey, conn);
                connectionList = this.selfRelConnections.get(connectionKey);
            }
            nIndex = connectionList.indexOf(conn);
            assert (nIndex >= 0);
        } else {
            this.selfRelConnections.put(connectionKey, conn);
        }
        Dimension selfrelsizeincr = new Dimension(10, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            selfrelsizeincr = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeincr);
        }
        IFigure owner = conn.getSourceAnchor().getOwner();
        Rectangle bBox = owner.getClientArea();
        owner.translateToAbsolute((Translatable)bBox);
        conn.translateToRelative((Translatable)bBox);
        nSelfIncr = selfrelsizeincr.width * (nIndex / 8);
        newLine.removeAllPoints();
        switch (nIndex % 8) {
            case 0: {
                this.getCornerSelfRelVertices(conn, bBox, newLine, nSelfIncr, 1, 1, bBox.getBottomRight());
                break;
            }
            case 1: {
                this.getVerticalSelfRelVertices(conn, bBox, newLine, nSelfIncr, 1, bBox.getBottom());
                break;
            }
            case 2: {
                this.getCornerSelfRelVertices(conn, bBox, newLine, nSelfIncr, -1, 1, bBox.getBottomLeft());
                break;
            }
            case 3: {
                this.getHorizontalSelfRelVertices(conn, bBox, newLine, nSelfIncr, -1, bBox.getLeft());
                break;
            }
            case 4: {
                this.getCornerSelfRelVertices(conn, bBox, newLine, nSelfIncr, -1, -1, bBox.getTopLeft());
                break;
            }
            case 5: {
                this.getVerticalSelfRelVertices(conn, bBox, newLine, nSelfIncr, -1, bBox.getTop());
                break;
            }
            case 6: {
                this.getCornerSelfRelVertices(conn, bBox, newLine, nSelfIncr, 1, -1, bBox.getTopRight());
                break;
            }
            case 7: {
                this.getHorizontalSelfRelVertices(conn, bBox, newLine, nSelfIncr, 1, bBox.getRight());
            }
        }
        Point ptS2 = newLine.getPoint(0);
        Point ptS1 = conn.getSourceAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptS1);
        Point ptAbsS2 = new Point(ptS2);
        conn.translateToAbsolute((Translatable)ptAbsS2);
        Point ptEdge = conn.getSourceAnchor().getLocation(ptAbsS2);
        conn.translateToRelative((Translatable)ptEdge);
        ptS1 = ObliqueRouter.getStraightEdgePoint(ptEdge, ptS1, ptS2);
        Point ptE2 = newLine.getPoint(newLine.size() - 1);
        Point ptE1 = conn.getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptE1);
        Point ptAbsE2 = new Point(ptE2);
        conn.translateToAbsolute((Translatable)ptAbsE2);
        ptEdge = conn.getTargetAnchor().getLocation(ptAbsE2);
        conn.translateToRelative((Translatable)ptEdge);
        ptE1 = ObliqueRouter.getStraightEdgePoint(ptEdge, ptE1, ptE2);
        newLine.setPoint(ptS1, 0);
        newLine.setPoint(ptE1, newLine.size() - 1);
    }

    private void getCornerSelfRelVertices(Connection conn, Rectangle bBox, PointList newLine, int nOffset, int nXDir, int nYDir, Point ptOrient) {
        int x = ptOrient.x;
        int y = bBox.getCenter().y + nYDir * bBox.height / 4;
        Point p1 = new Point(x, y);
        newLine.addPoint(p1);
        Dimension selfrelsizeinit = new Dimension(62, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            selfrelsizeinit = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeinit);
        }
        int xNew = x + nXDir * (selfrelsizeinit.width + nOffset);
        Point p2 = new Point(xNew, y);
        newLine.addPoint(p2);
        int yNew = ptOrient.y + nYDir * (selfrelsizeinit.width + nOffset);
        Point p3 = new Point(xNew, yNew);
        newLine.addPoint(p3);
        xNew = ptOrient.x - nXDir * bBox.width / 4;
        Point p4 = new Point(xNew, yNew);
        newLine.addPoint(p4);
        yNew = ptOrient.y;
        Point p5 = new Point(xNew, yNew);
        newLine.addPoint(p5);
    }

    private void getVerticalSelfRelVertices(Connection conn, Rectangle bBox, PointList newLine, int nOffset, int nDir, Point ptOrient) {
        int nWidth = bBox.width / 4;
        int x = ptOrient.x - nWidth / 2;
        int y = ptOrient.y;
        Point p1 = new Point(x, y);
        newLine.addPoint(p1);
        Dimension selfrelsizeinit = new Dimension(62, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            selfrelsizeinit = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeinit);
        }
        int yNew = y + nDir * (selfrelsizeinit.width + nOffset);
        Point p2 = new Point(x, yNew);
        newLine.addPoint(p2);
        int xNew = ptOrient.x + nWidth / 2;
        Point p3 = new Point(xNew, yNew);
        newLine.addPoint(p3);
        yNew = ptOrient.y;
        Point p4 = new Point(xNew, yNew);
        newLine.addPoint(p4);
    }

    private void getHorizontalSelfRelVertices(Connection conn, Rectangle bBox, PointList newLine, int nOffset, int nDir, Point ptOrient) {
        int nHeight = bBox.height / 4;
        int y = ptOrient.y - nHeight / 2;
        int x = ptOrient.x;
        Point p1 = new Point(x, y);
        newLine.addPoint(p1);
        Dimension selfrelsizeinit = new Dimension(62, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            selfrelsizeinit = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeinit);
        }
        int xNew = x + nDir * (selfrelsizeinit.width + nOffset);
        Point p2 = new Point(xNew, y);
        newLine.addPoint(p2);
        int yNew = ptOrient.y + nHeight / 2;
        Point p3 = new Point(xNew, yNew);
        newLine.addPoint(p3);
        xNew = ptOrient.x;
        Point p4 = new Point(xNew, yNew);
        newLine.addPoint(p4);
    }

    public void remove(Connection connection) {
        super.remove(connection);
        RouterHelper.getInstance().remove(connection);
        this.removeSelfRelConnection(connection);
        this.removeIntersectingShapesConnection(connection);
    }

    public void invalidate(Connection connection) {
        super.invalidate(connection);
        RouterHelper.getInstance().invalidate(connection);
    }

    public void setConstraint(Connection connection, Object constraint) {
        super.setConstraint(connection, constraint);
        RouterHelper.getInstance().setConstraint(connection, constraint);
    }

    private class ArrayListKey {
        private ConnectionAnchor connectAnchor1;
        private ConnectionAnchor connectAnchor2;

        ArrayListKey(Connection conn) {
            this.connectAnchor1 = conn.getSourceAnchor();
            this.connectAnchor2 = conn.getTargetAnchor();
        }

        public ConnectionAnchor getSourceAnchor() {
            return this.connectAnchor1;
        }

        public ConnectionAnchor getTargetAnchor() {
            return this.connectAnchor2;
        }

        public int hashCode() {
            return this.connectAnchor1.hashCode() ^ this.connectAnchor2.hashCode();
        }

        public boolean equals(Object object) {
            boolean isEqual = false;
            if (object instanceof ArrayListKey) {
                ArrayListKey listKey = (ArrayListKey)object;
                ConnectionAnchor lk1 = listKey.getSourceAnchor();
                ConnectionAnchor lk2 = listKey.getTargetAnchor();
                isEqual = lk1.equals(this.connectAnchor1) && lk2.equals(this.connectAnchor2) || lk1.equals(this.connectAnchor2) && lk2.equals(this.connectAnchor1);
            }
            return isEqual;
        }
    }

    public static class ArrayListMap {
        private HashMap map = new HashMap();

        public ArrayList get(Object key) {
            Object value = this.map.get(key);
            if (value == null) {
                return null;
            }
            if (value instanceof ArrayList) {
                return (ArrayList)value;
            }
            ArrayList v = new ArrayList(1);
            v.add(value);
            return v;
        }

        public void put(Object key, Object value) {
            Object arrayListObject = this.map.get(key);
            if (arrayListObject == null) {
                this.map.put(key, value);
                return;
            }
            if (arrayListObject instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)arrayListObject;
                if (!arrayList.contains(value)) {
                    arrayList.add(value);
                }
                return;
            }
            if (arrayListObject != value) {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(arrayListObject);
                arrayList.add(value);
                this.map.put(key, arrayList);
            }
        }

        public void remove(Object key, Object value) {
            Object arrayListObject = this.map.get(key);
            if (arrayListObject != null) {
                if (arrayListObject instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)arrayListObject;
                    arrayList.remove(value);
                    if (arrayList.isEmpty()) {
                        this.map.remove(key);
                    }
                    return;
                }
                this.map.remove(key);
            }
        }

        public int size() {
            return this.map.size();
        }
    }
}

