/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.editor.IServerEditorPageSectionFactory;
import org.eclipse.wst.server.ui.internal.editor.IServerEditorPartFactory;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorCore;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;

public abstract class ServerEditorPart
extends EditorPart {
    public static final int PROP_ERROR = 5;
    private String errorMessage = null;
    private Map<String, List<ServerEditorSection>> sectionToInsertionId = null;
    private List<ServerEditorSection> sections = null;
    private ServerResourceCommandManager commandManager;
    private FormToolkit toolkit;
    protected IServerWorkingCopy server;
    protected boolean readOnly;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setErrorMessage(String error) {
        if (error == null && this.errorMessage == null) {
            return;
        }
        if (error != null && error.equals(this.errorMessage)) {
            return;
        }
        this.errorMessage = error;
        super.firePropertyChange(5);
    }

    public void updateErrorMessage() {
        super.firePropertyChange(5);
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            for (ServerEditorSection section : this.getSections()) {
                String error = section.getErrorMessage();
                if (error == null) continue;
                return error;
            }
        }
        return this.errorMessage;
    }

    public IStatus[] getSaveStatus() {
        IStatus[] status;
        Iterator iterator = this.getSections().iterator();
        ArrayList<IStatus> list = new ArrayList<IStatus>();
        while (iterator.hasNext()) {
            ServerEditorSection section = (ServerEditorSection)iterator.next();
            status = section.getSaveStatus();
            if (status == null) continue;
            int size = status.length;
            int i = 0;
            while (i < size) {
                list.add(status[i]);
                ++i;
            }
        }
        int size = list.size();
        status = new IStatus[size];
        list.toArray(status);
        return status;
    }

    private List getSections() {
        if (this.sections == null) {
            this.sections = new ArrayList<ServerEditorSection>();
            this.sectionToInsertionId = new HashMap<String, List<ServerEditorSection>>();
            ServerEditor serverEditor = this.commandManager.getServerEditor();
            for (IServerEditorPageSectionFactory factory : ServerEditorCore.getServerEditorPageSectionFactories()) {
                ServerEditorSection section;
                String insertionId = factory.getInsertionId();
                IServerEditorPartFactory pageFactory = serverEditor.getPageFactory(this);
                if (!pageFactory.supportsInsertionId(insertionId)) continue;
                String serverTypeId = null;
                if (this.server != null && this.server.getServerType() != null) {
                    serverTypeId = this.server.getServerType().getId();
                }
                if (serverTypeId == null || !factory.supportsType(serverTypeId) || !factory.shouldCreateSection(this.server) || (section = factory.createSection()) == null) continue;
                section.setServerEditorPart(this);
                this.sections.add(section);
                List<ServerEditorSection> list = null;
                try {
                    list = this.sectionToInsertionId.get(insertionId);
                }
                catch (Exception exception) {}
                if (list == null) {
                    list = new ArrayList<ServerEditorSection>();
                }
                list.add(section);
                this.sectionToInsertionId.put(insertionId, list);
            }
        }
        return this.sections;
    }

    private List getSections(String insertionId) {
        if (insertionId == null) {
            return null;
        }
        this.getSections();
        ArrayList<ServerEditorSection> list = new ArrayList<ServerEditorSection>();
        try {
            List<ServerEditorSection> sections2 = this.sectionToInsertionId.get(insertionId);
            if (sections2 != null) {
                Iterator<ServerEditorSection> iterator = sections2.iterator();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
        }
        catch (Exception exception) {}
        return list;
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof IServerEditorPartInput) {
            IServerEditorPartInput sepi = (IServerEditorPartInput)input;
            this.server = sepi.getServer();
            this.commandManager = ((ServerEditorPartInput)sepi).getServerCommandManager();
            this.readOnly = sepi.isServerReadOnly();
        }
        for (ServerEditorSection section : this.getSections()) {
            section.init(site, input);
        }
    }

    public void execute(IUndoableOperation operation) {
        this.commandManager.execute(operation);
    }

    public IServerWorkingCopy getServer() {
        return this.server;
    }

    public void insertSections(Composite parent, String id) {
        if (id == null) {
            return;
        }
        for (ServerEditorSection section : this.getSections(id)) {
            section.createSection(parent);
        }
    }

    public void dispose() {
        super.dispose();
        for (ServerEditorSection section : this.getSections()) {
            section.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        this.commandManager = null;
        this.sectionToInsertionId = null;
        this.sections = null;
    }

    protected FormToolkit getFormToolkit(Display display) {
        if (this.toolkit == null) {
            this.toolkit = new FormToolkit(display);
        }
        return this.toolkit;
    }
}

