/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;

public class GlobalCommandManager {
    private static final int MAX_HISTORY = 200;
    protected List<ServerResourceCommand> undoList = new ArrayList<ServerResourceCommand>();
    protected int undoSaveIndex = 0;
    protected List<ServerResourceCommand> redoList = new ArrayList<ServerResourceCommand>();
    protected Map<String, CommandManagerInfo> commandManagers = new HashMap<String, CommandManagerInfo>();
    protected List<PropertyChangeListener> propertyListeners;
    public static final String PROP_DIRTY = "dirtyState";
    public static final String PROP_UNDO = "undoAction";
    public static final String PROP_REDO = "redoAction";
    public static final String PROP_RELOAD = "reload";
    protected static GlobalCommandManager instance;

    public static GlobalCommandManager getInstance() {
        if (instance == null) {
            instance = new GlobalCommandManager();
        }
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            int size = this.propertyListeners.size();
            PropertyChangeListener[] pcl = new PropertyChangeListener[size];
            this.propertyListeners.toArray(pcl);
            int i = 0;
            while (i < size) {
                try {
                    pcl[i].propertyChange(event);
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public void getCommandManager(String id) {
        CommandManagerInfo info;
        Trace.trace((byte)4, "Getting command manager for " + id);
        try {
            info = this.commandManagers.get(id);
            if (info != null) {
                ++info.count;
                return;
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not find existing command manager", e);
        }
        Trace.trace((byte)4, "Creating new command manager for " + id);
        try {
            info = new CommandManagerInfo();
            info.count = 1;
            info.id = id;
            IServer server = null;
            if (id != null) {
                server = ServerCore.findServer((String)id);
            }
            if (server != null) {
                info.wc = server.createWorkingCopy();
            }
            info.isDirty = false;
            info.isReadOnly = false;
            this.commandManagers.put(id, info);
            this.updateTimestamps(id);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not obtain command manager", e);
        }
    }

    public void releaseCommandManager(String id) {
        Trace.trace((byte)4, "Releasing command manager for " + id);
        try {
            CommandManagerInfo info = this.commandManagers.get(id);
            if (info != null) {
                --info.count;
                if (info.count == 0) {
                    this.commandManagers.remove(id);
                    this.clearUndoList(id);
                    this.clearRedoList(id);
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not release command manager", e);
        }
    }

    public void reload(String id) {
        try {
            CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
            if (info != null) {
                IServer server = null;
                if (id != null) {
                    server = ServerCore.findServer((String)id);
                }
                if (server != null) {
                    info.wc = server.createWorkingCopy();
                }
                this.firePropertyChangeEvent(PROP_RELOAD, id, null);
            }
            this.clearUndoList(id);
            this.clearRedoList(id);
            this.undoSaveIndex = this.undoList.size();
            this.setDirtyState(id, false);
            this.updateTimestamps(id);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not release command manager", e);
        }
    }

    protected CommandManagerInfo getExistingCommandManagerInfo(String id) {
        try {
            return this.commandManagers.get(id);
        }
        catch (Exception exception) {
            Trace.trace((byte)3, "Could not find existing command manager info");
            return null;
        }
    }

    public boolean isOnlyCommandManager(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        return info != null && info.count == 1;
    }

    protected IServerEditorPartInput getPartInput(String serverId, ServerResourceCommandManager serverCommandManager) {
        CommandManagerInfo serverInfo = null;
        IServerWorkingCopy server = null;
        boolean serverReadOnly = false;
        if (serverId != null) {
            serverInfo = this.getExistingCommandManagerInfo(serverId);
            if (serverInfo == null) {
                return null;
            }
            server = serverInfo.wc;
            serverReadOnly = serverInfo.isReadOnly;
        }
        return new ServerEditorPartInput(serverCommandManager, server, serverReadOnly);
    }

    protected IServerWorkingCopy getServerResource(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return null;
        }
        return info.wc;
    }

    public void executeCommand(String id, IUndoableOperation command) {
        if (!command.canUndo() && !this.undoList.isEmpty() && ServerUIPlugin.getPreferences().getPromptBeforeIrreversibleChange()) {
            try {
                Shell shell;
                Display d = Display.getCurrent();
                if (d == null) {
                    d = Display.getDefault();
                }
                if (!MessageDialog.openConfirm((Shell)(shell = d.getActiveShell()), (String)Messages.editorServerEditor, (String)Messages.editorPromptIrreversible)) {
                    return;
                }
            }
            catch (Exception exception) {}
        }
        ServerResourceCommand src = new ServerResourceCommand();
        src.id = id;
        src.command = command;
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            return;
        }
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return;
        }
        if (command.canUndo()) {
            this.addToUndoList(src);
        } else {
            this.undoSaveIndex = -1;
            this.clearUndoList(id);
        }
        this.clearRedoList(id);
        this.setDirtyState(id, true);
    }

    private void addToUndoList(ServerResourceCommand src) {
        this.undoList.add(src);
        if (this.undoList.size() > 200) {
            this.undoList.remove(0);
        }
        this.firePropertyChangeEvent(PROP_UNDO, src.id, null);
    }

    private void clearUndoList(String id) {
        int i = 0;
        boolean modified = false;
        while (i < this.undoList.size()) {
            ServerResourceCommand src = this.undoList.get(i);
            if (src.id.equals(id)) {
                modified = true;
                this.undoList.remove(i);
                continue;
            }
            ++i;
        }
        if (modified) {
            this.firePropertyChangeEvent(PROP_UNDO, id, null);
        }
    }

    private void clearRedoList(String id) {
        int i = 0;
        boolean modified = false;
        while (i < this.redoList.size()) {
            ServerResourceCommand src = this.redoList.get(i);
            if (src.id.equals(id)) {
                this.redoList.remove(i);
                modified = true;
                continue;
            }
            ++i;
        }
        if (modified) {
            this.firePropertyChangeEvent(PROP_REDO, id, null);
        }
    }

    protected boolean canUndo(String a, String b) {
        for (ServerResourceCommand src : this.undoList) {
            if (src.id != a && src.id != b) continue;
            return true;
        }
        return false;
    }

    protected boolean canRedo(String a, String b) {
        for (ServerResourceCommand src : this.redoList) {
            if (src.id != a && src.id != b) continue;
            return true;
        }
        return false;
    }

    public IUndoableOperation getUndoCommand(String a) {
        int size = this.undoList.size();
        int i = size - 1;
        while (i >= 0) {
            ServerResourceCommand src = this.undoList.get(i);
            if (src.id == a) {
                return src.command;
            }
            --i;
        }
        return null;
    }

    public IUndoableOperation getRedoCommand(String a) {
        int size = this.redoList.size();
        int i = size - 1;
        while (i >= 0) {
            ServerResourceCommand src = this.redoList.get(i);
            if (src.id == a) {
                return src.command;
            }
            --i;
        }
        return null;
    }

    public boolean isDirty(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return false;
        }
        return info.isDirty;
    }

    public boolean isReadOnly(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return false;
        }
        return info.isReadOnly;
    }

    public void setReadOnly(String id, boolean readOnly) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return;
        }
        if (info.isReadOnly == readOnly) {
            return;
        }
        info.isReadOnly = readOnly;
        this.firePropertyChangeEvent(PROP_RELOAD, id, null);
    }

    public boolean areFilesReadOnly(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return false;
        }
        return this.getReadOnlyFiles(id).length > 0;
    }

    private void setDirtyState(String id, boolean dirty) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info.isDirty == dirty) {
            return;
        }
        info.isDirty = dirty;
        this.firePropertyChangeEvent(PROP_DIRTY, id, null);
    }

    protected void undo(String a) {
        ServerResourceCommand src = null;
        for (ServerResourceCommand src2 : this.undoList) {
            if (src2.id != a) continue;
            src = src2;
        }
        if (src == null) {
            return;
        }
        try {
            src.command.undo(null, null);
        }
        catch (ExecutionException executionException) {}
        this.undoList.remove(src);
        this.firePropertyChangeEvent(PROP_UNDO, src.id, null);
        this.redoList.add(src);
        this.firePropertyChangeEvent(PROP_REDO, src.id, null);
        if (this.undoSaveIndex == this.undoList.size()) {
            this.setDirtyState(src.id, false);
        } else {
            this.setDirtyState(src.id, true);
        }
    }

    protected void redo(String a) {
        ServerResourceCommand src = null;
        for (ServerResourceCommand src2 : this.redoList) {
            if (src2.id != a) continue;
            src = src2;
        }
        if (src == null) {
            return;
        }
        try {
            src.command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            return;
        }
        this.redoList.remove(src);
        this.firePropertyChangeEvent(PROP_REDO, src.id, null);
        this.undoList.add(src);
        this.firePropertyChangeEvent(PROP_UNDO, src.id, null);
        if (this.undoSaveIndex == this.undoList.size()) {
            this.setDirtyState(src.id, false);
        } else {
            this.setDirtyState(src.id, true);
        }
    }

    public void resourceSaved(String id) {
        this.undoSaveIndex = this.undoList.size();
        this.setDirtyState(id, false);
    }

    public static IFile[] getReadOnlyFiles(IServerAttributes server) {
        try {
            ArrayList<IFile> list = new ArrayList<IFile>();
            IFile file = ((Server)server).getFile();
            if (file != null) {
                list.add(file);
            }
            IFile[] files = new IFile[list.size()];
            list.toArray(files);
            return files;
        }
        catch (Exception e) {
            Trace.trace((byte)3, "getReadOnlyFiles", e);
            return null;
        }
    }

    protected IFile[] getServerResourceFiles(String id) {
        if (id == null) {
            return new IFile[0];
        }
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return new IFile[0];
        }
        return GlobalCommandManager.getReadOnlyFiles((IServerAttributes)info.wc);
    }

    protected IFile[] getReadOnlyFiles(String id) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        IFile[] files = this.getServerResourceFiles(id);
        int size = files.length;
        int i = 0;
        while (i < size) {
            if (files[i].isReadOnly()) {
                list.add(files[i]);
            }
            ++i;
        }
        IFile[] fileList = new IFile[list.size()];
        list.toArray(fileList);
        return fileList;
    }

    public void updateTimestamps(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return;
        }
        info.fileMap = new HashMap<IFile, Long>();
        IFile[] files = this.getServerResourceFiles(id);
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                File f;
                if (files[i] != null && (f = files[i].getLocation().toFile()) != null) {
                    long time = f.lastModified();
                    info.fileMap.put(files[i], new Long(time));
                }
                ++i;
            }
        }
        info.timestamp = GlobalCommandManager.getTimestamp(info);
    }

    protected static int getTimestamp(CommandManagerInfo info) {
        IServer server = info.wc.getOriginal();
        if (server != null) {
            return ((Server)server).getTimestamp();
        }
        return -1;
    }

    protected boolean hasChanged(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return false;
        }
        IFile[] files = this.getServerResourceFiles(id);
        int size = files.length;
        int count = 0;
        int i = 0;
        while (i < size) {
            ++count;
            File f = files[i].getLocation().toFile();
            try {
                Long time = info.fileMap.get(files[i]);
                if (time.longValue() != f.lastModified()) {
                    return true;
                }
            }
            catch (Exception exception) {
                return true;
            }
            ++i;
        }
        int timestamp = GlobalCommandManager.getTimestamp(info);
        if (info.timestamp != timestamp) {
            return true;
        }
        return count != info.fileMap.size();
    }

    class CommandManagerInfo {
        int count;
        boolean isDirty;
        boolean isReadOnly;
        String id;
        IServerWorkingCopy wc;
        Map<IFile, Long> fileMap;
        int timestamp;

        CommandManagerInfo() {
        }
    }

    class ServerResourceCommand {
        IUndoableOperation command;
        String id;

        ServerResourceCommand() {
        }
    }
}

