/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.DeleteAction;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleSloshAction;
import org.eclipse.wst.server.ui.internal.view.servers.MonitorServerPortAction;
import org.eclipse.wst.server.ui.internal.view.servers.OpenAction;
import org.eclipse.wst.server.ui.internal.view.servers.PropertiesAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishCleanAction;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.RenameAction;
import org.eclipse.wst.server.ui.internal.view.servers.RestartModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.ServerActionHelper;
import org.eclipse.wst.server.ui.internal.view.servers.ServerTableViewer;
import org.eclipse.wst.server.ui.internal.view.servers.ServersViewDropAdapter;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;
import org.eclipse.wst.server.ui.internal.view.servers.StartModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.UpdateStatusAction;

public class ServersView
extends ViewPart {
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    protected Action noneAction = new Action(Messages.dialogMonitorNone){};
    protected int[] cols;
    protected Tree treeTable;
    protected ServerTableViewer tableViewer;
    protected Action[] actions;
    protected Action actionModifyModules;
    protected Action actionProperties;

    protected SelectionListener getHeaderListener(final int col) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServersView.this.tableViewer == null) {
                    return;
                }
                TreeColumn column = (TreeColumn)e.widget;
                ServersView.this.tableViewer.resortTable(column, col);
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.treeTable = new Tree(parent, 66308);
        this.treeTable.setHeaderVisible(true);
        this.treeTable.setLinesVisible(false);
        this.treeTable.setLayoutData((Object)new GridData(1808));
        this.treeTable.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.treeTable, "org.eclipse.wst.server.ui.svcp0000");
        TreeColumn column = new TreeColumn(this.treeTable, 4);
        column.setText(Messages.viewServer);
        column.setWidth(this.cols[0]);
        column.addSelectionListener(this.getHeaderListener(0));
        this.treeTable.setSortColumn(column);
        this.treeTable.setSortDirection(128);
        TreeColumn column2 = new TreeColumn(this.treeTable, 4);
        column2.setText(Messages.viewState);
        column2.setWidth(this.cols[1]);
        column2.addSelectionListener(this.getHeaderListener(1));
        TreeColumn column3 = new TreeColumn(this.treeTable, 4);
        column3.setText(Messages.viewStatus);
        column3.setWidth(this.cols[2]);
        column3.addSelectionListener(this.getHeaderListener(2));
        this.deferInitialization();
    }

    private void deferInitialization() {
        TreeItem item = new TreeItem(this.treeTable, 0);
        item.setText(Messages.viewInitializing);
        this.tableViewer = new ServerTableViewer(this, this.treeTable);
        this.initializeActions((ISelectionProvider)this.tableViewer);
        Job job = new Job(Messages.jobInitializingServersView){

            public IStatus run(IProgressMonitor monitor) {
                IServer[] servers = ServerCore.getServers();
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    ((Server)servers[i]).getAllModules().iterator();
                    ++i;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            ServersView.this.deferredInitialize();
                        }
                        catch (Exception exception) {}
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void deferredInitialize() {
        this.tableViewer.initialize();
        this.treeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                try {
                    TreeItem item = ServersView.this.treeTable.getSelection()[0];
                    Object data = item.getData();
                    if (!(data instanceof IServer)) {
                        return;
                    }
                    IServer server = (IServer)data;
                    ServerUIPlugin.editServer(server);
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Could not open server", e);
                }
            }
        });
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        final Shell shell = this.treeTable.getShell();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServersView.this.fillContextMenu(shell, mgr);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.treeTable);
        this.treeTable.setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.initDragAndDrop();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.cols = new int[3];
        int i = 0;
        while (i < 3) {
            Integer in;
            this.cols[i] = 200;
            if (memento != null && (in = memento.getInteger(TAG_COLUMN_WIDTH + i)) != null && in > 5) {
                this.cols[i] = in;
            }
            ++i;
        }
    }

    public void saveState(IMemento memento) {
        TreeColumn[] tc = this.treeTable.getColumns();
        int i = 0;
        while (i < 3) {
            int width = tc[i].getWidth();
            if (width != 0) {
                memento.putInteger(TAG_COLUMN_WIDTH + i, width);
            }
            ++i;
        }
    }

    protected void selectServerProcess(Object process) {
        Viewer viewer;
        IDebugView view;
        IViewPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.findView("org.eclipse.debug.ui.DebugView")) != null && (view = (IDebugView)part.getAdapter(IDebugView.class)) != null && (viewer = view.getViewer()) != null) {
            viewer.setSelection((ISelection)new StructuredSelection(process));
        }
    }

    public void initializeActions(ISelectionProvider provider) {
        Shell shell = this.getSite().getShell();
        this.actions = new Action[6];
        this.actions[0] = new StartAction(shell, provider, "debug");
        this.actions[1] = new StartAction(shell, provider, "run");
        this.actions[2] = new StartAction(shell, provider, "profile");
        this.actions[3] = new StopAction(shell, provider);
        this.actions[4] = new PublishAction(shell, provider);
        this.actions[5] = new PublishCleanAction(shell, provider);
        this.actionModifyModules = new ModuleSloshAction(shell, provider);
        this.actionProperties = new PropertiesAction(shell, provider);
        IToolBarManager cm = this.getViewSite().getActionBars().getToolBarManager();
        int i = 0;
        while (i < this.actions.length - 1) {
            cm.add((IAction)this.actions[i]);
            ++i;
        }
    }

    protected void fillContextMenu(Shell shell, IMenuManager menu) {
        IServer server = null;
        IModule[] module = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            Object obj = iterator.next();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)obj;
                server = ms.server;
                module = ms.module;
            }
            if (iterator.hasNext()) {
                server = null;
                module = null;
            }
        }
        MenuManager newMenu = new MenuManager(Messages.actionNew);
        ServerActionHelper.fillNewContextMenu(null, (ISelection)selection, (IMenuManager)newMenu);
        menu.add((IContributionItem)newMenu);
        if (server != null && module == null) {
            menu.add((IAction)new OpenAction(server));
            menu.add((IAction)new UpdateStatusAction(server));
            menu.add((IContributionItem)new Separator());
        } else {
            menu.add((IContributionItem)new Separator());
        }
        if (server != null) {
            if (module == null) {
                menu.add((IAction)new DeleteAction(shell, server));
                menu.add((IAction)new RenameAction(shell, this.tableViewer, (ISelectionProvider)this.tableViewer));
            } else if (module.length == 1) {
                menu.add((IAction)new RemoveModuleAction(shell, server, module[0]));
            }
            menu.add((IContributionItem)new Separator());
        }
        if (server != null && module == null) {
            int i = 0;
            while (i < this.actions.length) {
                menu.add((IAction)this.actions[i]);
                ++i;
            }
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.actionModifyModules);
            if (server.getServerType() != null) {
                final MenuManager menuManager = new MenuManager(Messages.actionMonitor);
                final IServer server2 = server;
                final Shell shell2 = shell;
                menuManager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        ServerPort[] ports;
                        menuManager.removeAll();
                        if (server2.getAdapter(ServerDelegate.class) != null && (ports = server2.getServerPorts(null)) != null) {
                            int size = ports.length;
                            int i = 0;
                            while (i < size) {
                                if (!ports[i].isAdvanced()) {
                                    menuManager.add((IAction)new MonitorServerPortAction(shell2, server2, ports[i]));
                                }
                                ++i;
                            }
                        }
                        if (menuManager.isEmpty()) {
                            menuManager.add((IAction)ServersView.this.noneAction);
                        }
                    }
                });
                this.noneAction.setEnabled(false);
                menuManager.add((IAction)this.noneAction);
                menu.add((IContributionItem)menuManager);
            }
        }
        if (server != null && module != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)new StartModuleAction(server, module));
            menu.add((IAction)new StopModuleAction(server, module));
            menu.add((IAction)new RestartModuleAction(server, module));
        }
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        if (server != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.actionProperties);
        }
    }

    public void setFocus() {
        if (this.treeTable != null) {
            this.treeTable.setFocus();
        }
    }

    protected void initDragAndDrop() {
        int ops = 1;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        this.tableViewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new ServersViewDropAdapter((Viewer)this.tableViewer));
    }
}

