/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.extension.ExtensionUtility;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeComposite;
import org.eclipse.wst.server.ui.internal.viewers.DefaultViewerSorter;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeTreeLabelProvider;

public class ServerTypeComposite
extends AbstractTreeComposite {
    protected IServerType selection;
    protected ServerTypeSelectionListener listener;
    protected ServerTypeTreeContentProvider contentProvider;
    protected boolean initialSelection = true;
    protected IModuleType moduleType;
    protected String serverTypeId;
    protected boolean isLocalhost;
    protected boolean includeIncompatibleVersions;

    public ServerTypeComposite(Composite parent, IModuleType moduleType, String serverTypeId, ServerTypeSelectionListener listener2) {
        super(parent);
        this.listener = listener2;
        this.moduleType = moduleType;
        this.serverTypeId = serverTypeId;
        this.contentProvider = new ServerTypeTreeContentProvider(moduleType, serverTypeId);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        ServerTypeTreeLabelProvider labelProvider = new ServerTypeTreeLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    ServerTypeComposite.this.treeViewer.refresh(true);
                } else {
                    obj = ServerUIPlugin.adaptLabelChangeObjects(obj);
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        ServerTypeComposite.this.treeViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ServerTypeComposite.this.getSelection(event.getSelection());
                if (obj instanceof IServerType) {
                    ServerTypeComposite.this.selection = (IServerType)obj;
                    ServerTypeComposite.this.setDescription(ServerTypeComposite.this.selection.getDescription());
                } else {
                    ServerTypeComposite.this.selection = null;
                    ServerTypeComposite.this.setDescription("");
                }
                ServerTypeComposite.this.listener.serverTypeSelected(ServerTypeComposite.this.selection);
            }
        });
        this.treeViewer.setSorter((ViewerSorter)new DefaultViewerSorter());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.initialSelection) {
            this.initialSelection = false;
            if (this.contentProvider.getInitialSelection() != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.contentProvider.getInitialSelection()), true);
            }
        }
    }

    public boolean setHost(boolean newHost) {
        if (this.isLocalhost == newHost) {
            return false;
        }
        this.isLocalhost = newHost;
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider.setLocalhost(this.isLocalhost);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(sel, true);
        return true;
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider.setIncludeIncompatibleVersions(b);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(sel, true);
    }

    protected String getDescriptionLabel() {
        return null;
    }

    protected String getTitleLabel() {
        return Messages.serverTypeCompLabel;
    }

    public IServerType getSelectedServerType() {
        return this.selection;
    }

    public void refresh() {
        ISelection sel = this.treeViewer.getSelection();
        this.treeViewer.setContentProvider((IContentProvider)new ServerTypeTreeContentProvider(this.moduleType, this.serverTypeId));
        this.treeViewer.setSelection(sel);
    }

    protected String getDetailsLabel() {
        return Messages.installableServerLink;
    }

    private void closeWizard(Composite comp) {
        if (comp == null || comp.isDisposed()) {
            return;
        }
        Composite c = comp.getParent();
        if (c instanceof Shell) {
            Shell s = (Shell)c;
            s.close();
        }
        this.closeWizard(c);
    }

    protected void detailsSelected() {
        if (ExtensionUtility.launchExtensionWizard(this.getShell(), Messages.wizNewInstallableServerTitle, Messages.wizNewInstallableServerDescription)) {
            this.closeWizard(this);
        }
    }

    public static interface ServerTypeSelectionListener {
        public void serverTypeSelected(IServerType var1);
    }
}

