/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.breakpointproviders;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.breakpointproviders.AbstractBreakpointProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JavaBreakpointProvider
extends AbstractBreakpointProvider {
    private static final String getTypeName(IResource res) {
        IPath path = res.getFullPath();
        path = path.segmentCount() > 2 ? path.removeFirstSegments(2) : path.removeFirstSegments(1);
        String typeName = path.toString().replace('/', '.');
        if (res.getFileExtension() != null) {
            typeName = typeName.substring(0, typeName.lastIndexOf(46));
        }
        return typeName;
    }

    public IStatus addBreakpoint(IDocument document, IEditorInput input, int lineNumber, int offset) throws CoreException {
        IResource res;
        int pos = this.getValidPosition(document, lineNumber);
        if (pos != -2 && (res = this.getEditorInputResource(input)) != null) {
            String typeName = JavaBreakpointProvider.getTypeName(res);
            try {
                JDIDebugModel.createLineBreakpoint((IResource)res, (String)typeName, (int)lineNumber, (int)pos, (int)pos, (int)0, (boolean)true, null);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return new Status(0, "org.eclipse.jst.jsp.ui", 0, JSPUIMessages.OK, null);
    }

    public boolean canAddBreakpoint(IDocument document, IEditorInput input, Node node, int lineNumber, int offset) {
        IFile res = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        Document doc = null;
        if (this.getSourceEditingTextTools() instanceof IDOMSourceEditingTextTools) {
            doc = ((IDOMSourceEditingTextTools)this.getSourceEditingTextTools()).getDOMDocument();
        }
        return res != null && !this.isBreakpointExist((IResource)res, lineNumber) && this.isValidPosition(document, lineNumber) && JavaBreakpointProvider.getPageLanguage(doc) == 1;
    }

    public IResource getResource(IEditorInput input) {
        return this.getEditorInputResource(input);
    }

    private boolean isBreakpointExist(IResource res, int lineNumber) {
        try {
            return JDIDebugModel.lineBreakpointExists((String)JavaBreakpointProvider.getTypeName(res), (int)lineNumber) != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isValidPosition(IDocument idoc, int lineNumber) {
        return this.getValidPosition(idoc, lineNumber) != -2;
    }
}

