/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.creation.core.command;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.core.utils.FacetContainerUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.axis2.creation.core.data.DataModel;
import org.eclipse.jst.ws.axis2.creation.core.messages.Axis2CreationUIMessages;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class Axis2TDServiceCreationCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private String project;

    public Axis2TDServiceCreationCommand(DataModel model, IWebService ws, String project) {
        this.model = model;
        this.project = project;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        try {
            String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            String currentDynamicWebProjectDir = FacetContainerUtils.getProjectRoot((String)this.model.getWebProjectName()).toOSString();
            String matadataDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)".metadata");
            String matadataPluginsDir = FileUtils.addAnotherNodeToPath((String)matadataDir, (String)".plugins");
            String matadataAxis2Dir = FileUtils.addAnotherNodeToPath((String)matadataPluginsDir, (String)"org.eclipse.jst.ws.axis2");
            String tempServicesDir = FileUtils.addAnotherNodeToPath((String)matadataAxis2Dir, (String)"services");
            this.model.setPathToWebServicesTempDir(tempServicesDir);
            String currentservicesDirectory = FileUtils.addAnotherNodeToPath((String)tempServicesDir, (String)this.model.getServiceName());
            String metaInfDirectory = FileUtils.addAnotherNodeToPath((String)currentservicesDirectory, (String)"META-INF");
            FileUtils.createDirectorys((String)currentservicesDirectory);
            FileUtils.createDirectorys((String)metaInfDirectory);
            String currentProjectResourcesDirString = FileUtils.addAnotherNodeToPath((String)currentDynamicWebProjectDir, (String)"resources");
            File currentProjectResourcesDir = new File(currentProjectResourcesDirString);
            if (!currentProjectResourcesDir.exists()) {
                currentProjectResourcesDir.mkdir();
            }
            FileUtils.copyDirectory((File)currentProjectResourcesDir, (File)new File(metaInfDirectory));
            String classesDirectory = null;
            IPath projectRoot = FacetContainerUtils.getProjectRoot((String)this.project);
            IPath defaultClassesSubDirectory = ResourceUtils.getJavaOutputLocation((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.project));
            IPath defaultClassesSubDirectoryWithoutProjectRoot = ResourceUtils.getJavaOutputLocation((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.project)).removeFirstSegments(1).makeAbsolute();
            classesDirectory = projectRoot.toOSString().contains(FacetContainerUtils.getWorkspace().toOSString()) ? FacetContainerUtils.getWorkspace().append(defaultClassesSubDirectory).toOSString() : projectRoot.append(defaultClassesSubDirectoryWithoutProjectRoot).toOSString();
            FileUtils.copyDirectory((File)new File(classesDirectory), (File)new File(currentservicesDirectory));
        }
        catch (IOException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2CreationUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2CreationUIMessages.ERROR_INVALID_SERVICE_CREATION, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }
}

