/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class Trace {
    public static final byte CONFIG = 0;
    public static final byte INFO = 1;
    public static final byte WARNING = 2;
    public static final byte SEVERE = 3;
    public static final byte FINER = 4;
    public static final byte FINEST = 5;
    public static final byte RESOURCES = 6;
    public static final byte EXTENSION_POINT = 7;
    public static final byte LISTENERS = 8;
    public static final byte RUNTIME_TARGET = 9;
    public static final byte PERFORMANCE = 10;
    public static final byte PUBLISHING = 11;
    private static final String[] levelNames = new String[]{"CONFIG   ", "INFO     ", "WARNING  ", "SEVERE   ", "FINER    ", "FINEST   ", "RESOURCES", "EXTENSION", "LISTENERS", "TARGET   ", "PERF     ", "PUBLISH  "};
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");

    private Trace() {
    }

    public static void trace(int level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(int level, String s, Throwable t) {
        if (s == null) {
            return;
        }
        if (level == 3) {
            ServerPlugin.log((IStatus)new Status(4, "org.eclipse.wst.server.core", s, t));
        }
        if (!ServerPlugin.getInstance().isDebugging()) {
            return;
        }
        StringBuffer sb = new StringBuffer("org.eclipse.wst.server.core");
        sb.append(" ");
        sb.append(levelNames[level]);
        sb.append(" ");
        sb.append(sdf.format(new Date()));
        sb.append(" ");
        sb.append(s);
        System.out.println(sb.toString());
        if (t != null) {
            t.printStackTrace();
        }
    }
}

