/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal.facets;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Messages;

public final class FacetUtil {
    private FacetUtil() {
    }

    public static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        if (id == null) {
            return null;
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (id.equals(runtimes[i].getId())) {
                return runtimes[i];
            }
            ++i;
        }
        return null;
    }

    public static org.eclipse.wst.common.project.facet.core.runtime.IRuntime getRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getId();
        if (id == null) {
            return null;
        }
        Set runtimes = RuntimeManager.getRuntimes();
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime2 : runtimes) {
            if (!id.equals(runtime2.getProperty("id"))) continue;
            return runtime2;
        }
        return null;
    }

    public static final IStatus verifyFacets(IProject project, IServer server) {
        if (server == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorNoRuntime, null);
        }
        IRuntime runtime = server.getRuntime();
        if (runtime == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorNoRuntime, null);
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime2 = FacetUtil.getRuntime(runtime);
        if (runtime2 == null) {
            return Status.OK_STATUS;
        }
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                if (runtime2.supports(facet)) continue;
                return new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorFacet, (Object)facet.getProjectFacet().getLabel(), (Object)facet.getVersionString()), null);
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }
}

