/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.adapters.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.actions.AddFieldAction;
import org.eclipse.wst.xsd.ui.internal.adt.actions.BaseDirectEditAction;
import org.eclipse.wst.xsd.ui.internal.adt.actions.BaseSelectionAction;
import org.eclipse.wst.xsd.ui.internal.adt.actions.DeleteAction;
import org.eclipse.wst.xsd.ui.internal.adt.actions.SetInputToGraphView;
import org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction;
import org.eclipse.wst.xsd.ui.internal.adt.design.DesignViewGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootContentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ADTMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.adt.editor.EditorMode;
import org.eclipse.wst.xsd.ui.internal.adt.editor.EditorModeManager;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ADTContentOutlinePage;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.TypeVizEditorMode;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDAnyAttributeAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDAnyElementAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDAttributeDeclarationAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDAttributeGroupDefinitionAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDComplexTypeDefinitionAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDModelGroupAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDModelGroupDefinitionAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDSchemaDirectiveAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDSimpleTypeDefinitionAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.DeleteXSDConcreteComponentAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.OpenInNewEditor;
import org.eclipse.wst.xsd.ui.internal.common.actions.SetMultiplicityAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.SetTypeAction;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.IDocumentChangedNotifier;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDComplexTypeBaseTypeEditManager;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.editor.XSDFileEditorInput;
import org.eclipse.wst.xsd.ui.internal.editor.XSDSelectionMapper;
import org.eclipse.wst.xsd.ui.internal.editor.XSDSubstitutionGroupEditManager;
import org.eclipse.wst.xsd.ui.internal.editor.XSDTabbedPropertySheetPage;
import org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.navigation.DesignViewNavigationLocation;
import org.eclipse.wst.xsd.ui.internal.navigation.MultiPageEditorTextSelectionNavigationLocation;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter;
import org.eclipse.wst.xsd.ui.internal.utils.OpenOnSelectionHelper;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InternalXSDMultiPageEditor
extends ADTMultiPageEditor
implements ITabbedPropertySheetPageContributor,
INavigationLocationProvider {
    IStructuredModel structuredModel;
    XSDSchema xsdSchema;
    XSDModelAdapter schemaNodeAdapter;
    private OutlineTreeSelectionChangeListener fOutlineListener;
    private SourceEditorSelectionListener fSourceEditorSelectionListener;
    private XSDSelectionManagerSelectionListener fXSDSelectionListener;
    private InternalDocumentChangedNotifier internalDocumentChangedNotifier = new InternalDocumentChangedNotifier();
    private static final String XSD_EDITOR_MODE_EXTENSION_ID = "org.eclipse.wst.xsd.ui.editorModes";
    private XSDPreferenceStoreListener xsdPreferenceStoreListener;
    protected OpenOnSelectionHelper openOnSelectionHelper;
    boolean doUpdateSourceLocation = false;
    private static final String DEFAULT_EDITOR_MODE_ID = "org.eclipse.wst.xsd.ui.defaultEditorModeId";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public IModel buildModel() {
        try {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof XSDFileEditorInput) {
                this.xsdSchema = ((XSDFileEditorInput)editorInput).getSchema();
                this.model = (IModel)XSDAdapterFactory.getInstance().adapt((Notifier)this.xsdSchema);
            }
            IDOMDocument document = null;
            IDocument doc = this.structuredTextEditor.getDocumentProvider().getDocument((Object)this.getEditorInput());
            if (doc instanceof IStructuredDocument) {
                IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(doc);
                if (model == null) {
                    model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)doc);
                }
                this.structuredModel = model;
                document = ((IDOMModel)model).getDocument();
            }
            Assert.isNotNull(document);
            if (this.model != null) {
                return this.model;
            }
            this.xsdSchema = XSDModelAdapter.lookupOrCreateSchema(document);
            this.model = (IModel)XSDAdapterFactory.getInstance().adapt((Notifier)this.xsdSchema);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.model;
    }

    public void dispose() {
        if (this.structuredModel != null) {
            this.structuredModel.releaseFromEdit();
            this.structuredModel = null;
        }
        if (this.schemaNodeAdapter != null) {
            this.schemaNodeAdapter.clear();
            this.schemaNodeAdapter = null;
        }
        if (this.fOutlinePage != null && this.fOutlineListener != null) {
            this.fOutlinePage.removeSelectionChangedListener((ISelectionChangedListener)this.fOutlineListener);
        }
        this.getSelectionManager().removeSelectionChangedListener(this.fXSDSelectionListener);
        XSDEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.xsdPreferenceStoreListener);
        this.xsdPreferenceStoreListener = null;
        super.dispose();
    }

    protected void initializeGraphicalViewer() {
        RootContentEditPart root = new RootContentEditPart();
        if (!(this.getEditorInput() instanceof XSDFileEditorInput)) {
            root.setModel(this.model);
        }
        this.graphicalViewer.setContents((EditPart)root);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.graphicalViewer.getKeyHandler().put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        EditPartFactory editPartFactory = this.getEditorModeManager().getCurrentMode().getEditPartFactory();
        this.graphicalViewer.setEditPartFactory(editPartFactory);
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            XSDTabbedPropertySheetPage page = new XSDTabbedPropertySheetPage(this);
            return page;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.getSelectionManager();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.xsd.XSDSchema");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return this.xsdSchema;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            Object adapter = super.getAdapter(type);
            if (adapter != null) {
                IContentOutlinePage page = (IContentOutlinePage)adapter;
                this.fOutlineListener = new OutlineTreeSelectionChangeListener();
                page.addSelectionChangedListener((ISelectionChangedListener)this.fOutlineListener);
                return page;
            }
        } else {
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (type == clazz5) {
                IEditorInput editorInput = this.getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                    XSDSchema[] schemas = new XSDSchema[]{this.xsdSchema};
                    return new XSDElementReferenceEditManager(fileEditorInput.getFile(), schemas);
                }
            } else {
                Class<?> clazz6 = class$5;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$5 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz6) {
                    IEditorInput editorInput = this.getEditorInput();
                    if (editorInput instanceof IFileEditorInput) {
                        IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                        XSDSchema[] schemas = new XSDSchema[]{this.xsdSchema};
                        return new XSDTypeReferenceEditManager(fileEditorInput.getFile(), schemas);
                    }
                } else {
                    Class<?> clazz7 = class$6;
                    if (clazz7 == null) {
                        try {
                            clazz7 = class$6 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDComplexTypeBaseTypeEditManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (type == clazz7) {
                        IEditorInput editorInput = this.getEditorInput();
                        if (editorInput instanceof IFileEditorInput) {
                            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                            XSDSchema[] schemas = new XSDSchema[]{this.xsdSchema};
                            return new XSDComplexTypeBaseTypeEditManager(fileEditorInput.getFile(), schemas);
                        }
                    } else {
                        Class<?> clazz8 = class$7;
                        if (clazz8 == null) {
                            try {
                                clazz8 = class$7 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDSubstitutionGroupEditManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (type == clazz8) {
                            IEditorInput editorInput = this.getEditorInput();
                            if (editorInput instanceof IFileEditorInput) {
                                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                                XSDSchema[] schemas = new XSDSchema[]{this.xsdSchema};
                                return new XSDSubstitutionGroupEditManager(fileEditorInput.getFile(), schemas);
                            }
                        } else {
                            Class<?> clazz9 = class$8;
                            if (clazz9 == null) {
                                try {
                                    clazz9 = class$8 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (type == clazz9) {
                                return this.getTextEditor();
                            }
                            Class<?> clazz10 = class$9;
                            if (clazz10 == null) {
                                try {
                                    clazz10 = class$9 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.ISelectionMapper");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (type == clazz10) {
                                return new XSDSelectionMapper();
                            }
                            Class<?> clazz11 = class$10;
                            if (clazz11 == null) {
                                try {
                                    clazz11 = class$10 = Class.forName("org.eclipse.wst.xsd.ui.internal.common.properties.sections.IDocumentChangedNotifier");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (type == clazz11) {
                                return this.internalDocumentChangedNotifier;
                            }
                            Class<?> clazz12 = class$11;
                            if (clazz12 == null) {
                                try {
                                    clazz12 = class$11 = Class.forName("org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (type == clazz12) {
                                return XSDEditorPlugin.getPlugin().getProductCustomizationProvider();
                            }
                        }
                    }
                }
            }
        }
        return super.getAdapter(type);
    }

    public String getContributorId() {
        return "org.eclipse.wst.xsd.ui.internal.editor";
    }

    public XSDSchema getXSDSchema() {
        return this.xsdSchema;
    }

    public void openOnGlobalReference(XSDConcreteComponent comp) {
        XSDNamedComponent namedComponent = this.openOnSelectionHelper.openOnGlobalReference(comp);
        if (namedComponent == null) {
            namedComponent = this.getXSDSchema();
        }
        XSDBaseAdapter adapter = (XSDBaseAdapter)XSDAdapterFactory.getInstance().adapt((Notifier)namedComponent);
        this.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)adapter));
        IAction action = this.getActionRegistry().getAction((Object)SetInputToGraphView.ID);
        if (action != null) {
            action.run();
        }
    }

    public OpenOnSelectionHelper getOpenOnSelectionHelper() {
        return this.openOnSelectionHelper;
    }

    protected void createPages() {
        super.createPages();
        this.openOnSelectionHelper = new OpenOnSelectionHelper(this.getTextEditor(), this.getXSDSchema());
        ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
        this.fSourceEditorSelectionListener = new SourceEditorSelectionListener();
        if (provider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
        } else {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
        }
        this.fXSDSelectionListener = new XSDSelectionManagerSelectionListener();
        this.getSelectionManager().addSelectionChangedListener(this.fXSDSelectionListener);
        this.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)this.getModel()));
        this.xsdPreferenceStoreListener = new XSDPreferenceStoreListener();
        XSDEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.xsdPreferenceStoreListener);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        BaseSelectionAction action = new AddFieldAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)action);
        action = new DeleteAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)action);
        action = new AddXSDElementAction((IWorkbenchPart)this, AddXSDElementAction.ID, Messages._UI_ACTION_ADD_ELEMENT, false);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/XSDElement.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDElementAction((IWorkbenchPart)this, AddXSDElementAction.REF_ID, Messages._UI_ACTION_ADD_ELEMENT_REF, true);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz2 = class$12;
        if (clazz2 == null) {
            try {
                clazz2 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz2, (String)"icons/XSDElementRef.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDModelGroupAction((IWorkbenchPart)this, XSDCompositor.SEQUENCE_LITERAL, AddXSDModelGroupAction.SEQUENCE_ID);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz3 = class$12;
        if (clazz3 == null) {
            try {
                clazz3 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz3, (String)"icons/XSDSequence.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDModelGroupAction((IWorkbenchPart)this, XSDCompositor.CHOICE_LITERAL, AddXSDModelGroupAction.CHOICE_ID);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz4 = class$12;
        if (clazz4 == null) {
            try {
                clazz4 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz4, (String)"icons/XSDChoice.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDModelGroupAction((IWorkbenchPart)this, XSDCompositor.ALL_LITERAL, AddXSDModelGroupAction.ALL_ID);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz5 = class$12;
        if (clazz5 == null) {
            try {
                clazz5 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz5, (String)"icons/XSDAll.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDModelGroupDefinitionAction((IWorkbenchPart)this, false);
        action.setId("AddXSDModelGroupDefinitionAction");
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz6 = class$12;
        if (clazz6 == null) {
            try {
                clazz6 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz6, (String)"icons/XSDGroup.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDModelGroupDefinitionAction((IWorkbenchPart)this, true);
        action.setId("AddXSDModelGroupDefinitionRefAction");
        action.setSelectionProvider(this.getSelectionManager());
        action.setImageDescriptor(XSDEditorPlugin.getImageDescriptor("icons/obj16/XSDGroupRef.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDComplexTypeDefinitionAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz7 = class$12;
        if (clazz7 == null) {
            try {
                clazz7 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz7, (String)"icons/XSDComplexType.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDSimpleTypeDefinitionAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz8 = class$12;
        if (clazz8 == null) {
            try {
                clazz8 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz8, (String)"icons/XSDSimpleType.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDAttributeDeclarationAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz9 = class$12;
        if (clazz9 == null) {
            try {
                clazz9 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz9, (String)"icons/XSDAttribute.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDAttributeDeclarationAction((IWorkbenchPart)this, AddXSDAttributeDeclarationAction.REF_ID, Messages._UI_ACTION_ADD_ATTRIBUTE_REF, true);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz10 = class$12;
        if (clazz10 == null) {
            try {
                clazz10 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz10, (String)"icons/XSDAttributeRef.gif"));
        registry.registerAction((IAction)action);
        action = new OpenInNewEditor((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)action);
        action = new ShowPropertiesViewAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new AddXSDAttributeGroupDefinitionAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz11 = class$12;
        if (clazz11 == null) {
            try {
                clazz11 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz11, (String)"icons/XSDAttributeGroup.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDAttributeGroupDefinitionAction((IWorkbenchPart)this, AddXSDAttributeGroupDefinitionAction.REF_ID);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz12 = class$12;
        if (clazz12 == null) {
            try {
                clazz12 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz12, (String)"icons/XSDAttributeGroupRef.gif"));
        registry.registerAction((IAction)action);
        action = new DeleteXSDConcreteComponentAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)action);
        action = new AddXSDAnyElementAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz13, (String)"icons/XSDAny.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDAnyAttributeAction((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz14 = class$12;
        if (clazz14 == null) {
            try {
                clazz14 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz14, (String)"icons/XSDAnyAttribute.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDSchemaDirectiveAction((IWorkbenchPart)this, AddXSDSchemaDirectiveAction.INCLUDE_ID, Messages._UI_ACTION_ADD_INCLUDE);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz15 = class$12;
        if (clazz15 == null) {
            try {
                clazz15 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz15, (String)"icons/XSDInclude.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDSchemaDirectiveAction((IWorkbenchPart)this, AddXSDSchemaDirectiveAction.IMPORT_ID, Messages._UI_ACTION_ADD_IMPORT);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz16 = class$12;
        if (clazz16 == null) {
            try {
                clazz16 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz16, (String)"icons/XSDImport.gif"));
        registry.registerAction((IAction)action);
        action = new AddXSDSchemaDirectiveAction((IWorkbenchPart)this, AddXSDSchemaDirectiveAction.REDEFINE_ID, Messages._UI_ACTION_ADD_REDEFINE);
        action.setSelectionProvider(this.getSelectionManager());
        Class<?> clazz17 = class$12;
        if (clazz17 == null) {
            try {
                clazz17 = class$12 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz17, (String)"icons/XSDRedefine.gif"));
        registry.registerAction((IAction)action);
        SetTypeAction setNewComplexTypeAction = new SetTypeAction(Messages._UI_ACTION_NEW, "SetTypeAction_AddType", (IWorkbenchPart)this);
        setNewComplexTypeAction.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)setNewComplexTypeAction);
        SetTypeAction setExistingTypeAction = new SetTypeAction(Messages._UI_ACTION_BROWSE, "SetTypeAction_ExistingType", (IWorkbenchPart)this);
        setExistingTypeAction.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)setExistingTypeAction);
        this.addMultiplicityMenu(registry);
        PrintAction printAction = new PrintAction((IWorkbenchPart)this);
        registry.registerAction((IAction)printAction);
        BaseDirectEditAction directEditAction = new BaseDirectEditAction((IEditorPart)this);
        directEditAction.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)directEditAction);
    }

    protected void addMultiplicityMenu(ActionRegistry registry) {
        SetMultiplicityAction oneMultiplicity = new SetMultiplicityAction((IWorkbenchPart)this, "1..1 (" + Messages._UI_LABEL_REQUIRED + ")", SetMultiplicityAction.REQUIRED_ID);
        oneMultiplicity.setMaxOccurs(1);
        oneMultiplicity.setMinOccurs(1);
        oneMultiplicity.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)oneMultiplicity);
        SetMultiplicityAction zeroOrMoreMultiplicity = new SetMultiplicityAction((IWorkbenchPart)this, "0..* (" + Messages._UI_LABEL_ZERO_OR_MORE + ")", SetMultiplicityAction.ZERO_OR_MORE_ID);
        zeroOrMoreMultiplicity.setMaxOccurs(-1);
        zeroOrMoreMultiplicity.setMinOccurs(0);
        zeroOrMoreMultiplicity.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)zeroOrMoreMultiplicity);
        SetMultiplicityAction zeroOrOneMultiplicity = new SetMultiplicityAction((IWorkbenchPart)this, "0..1 (" + Messages._UI_LABEL_OPTIONAL + ")", SetMultiplicityAction.ZERO_OR_ONE_ID);
        zeroOrOneMultiplicity.setMaxOccurs(1);
        zeroOrOneMultiplicity.setMinOccurs(0);
        zeroOrOneMultiplicity.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)zeroOrOneMultiplicity);
        SetMultiplicityAction oneOrMoreMultiplicity = new SetMultiplicityAction((IWorkbenchPart)this, "1..* (" + Messages._UI_LABEL_ONE_OR_MORE + ")", SetMultiplicityAction.ONE_OR_MORE_ID);
        oneOrMoreMultiplicity.setMaxOccurs(-1);
        oneOrMoreMultiplicity.setMinOccurs(1);
        oneOrMoreMultiplicity.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)oneOrMoreMultiplicity);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        boolean bl = this.doUpdateSourceLocation = newPageIndex == SOURCE_PAGE_INDEX;
        if (this.doUpdateSourceLocation && this.fXSDSelectionListener != null) {
            this.fXSDSelectionListener.doSetSelection();
        }
    }

    public INavigationLocation createEmptyNavigationLocation() {
        if (this.getActivePage() == 0) {
            return new DesignViewNavigationLocation((IEditorPart)this);
        }
        return new MultiPageEditorTextSelectionNavigationLocation((ITextEditor)this.getTextEditor(), false);
    }

    public INavigationLocation createNavigationLocation() {
        if (this.getActivePage() == DESIGN_PAGE_INDEX) {
            try {
                RootContentEditPart rootContentEditPart;
                Object input;
                RootEditPart rootEditPart = this.graphicalViewer.getRootEditPart();
                EditPart editPart = rootEditPart.getContents();
                if (editPart instanceof RootContentEditPart && (input = (rootContentEditPart = (RootContentEditPart)editPart).getInput()) instanceof Adapter) {
                    XSDConcreteComponent concreteComponent = (XSDConcreteComponent)((Adapter)input).getTarget();
                    return new DesignViewNavigationLocation((IEditorPart)this, concreteComponent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
        return new MultiPageEditorTextSelectionNavigationLocation((ITextEditor)this.getTextEditor(), true);
    }

    public void editorModeChanged(EditorMode newEditorMode) {
        TreeViewer treeViewer;
        ADTContentOutlinePage outline;
        IContentProvider provider;
        EditPartFactory editPartFactory = newEditorMode.getEditPartFactory();
        if (editPartFactory != null) {
            this.graphicalViewer.setEditPartFactory(editPartFactory);
            if (this.graphicalViewer instanceof DesignViewGraphicalViewer) {
                DesignViewGraphicalViewer viewer = (DesignViewGraphicalViewer)this.graphicalViewer;
                IADTObject input = viewer.getInput();
                viewer.setInput(null);
                viewer.setInput(input);
                this.floatingToolbar.setEditPartFactory(editPartFactory);
                this.floatingToolbar.setModel(this.getModel());
                this.floatingToolbar.refresh(!(input instanceof IModel));
                Control control = this.graphicalViewer.getControl();
                if (control instanceof Composite) {
                    Composite parent = ((Composite)control).getParent();
                    parent.layout();
                }
            }
        }
        if ((provider = newEditorMode.getOutlineProvider()) != null && (outline = (ADTContentOutlinePage)this.getContentOutlinePage()) != null && (treeViewer = outline.getTreeViewer()) != null) {
            outline.getTreeViewer().setContentProvider(provider);
            outline.getTreeViewer().refresh();
        }
    }

    protected EditorModeManager createEditorModeManager() {
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final ProductCustomizationProvider productCustomizationProvider = (ProductCustomizationProvider)this.getAdapter(clazz);
        EditorModeManager manager = new EditorModeManager(XSD_EDITOR_MODE_EXTENSION_ID){

            public void init() {
                if (productCustomizationProvider == null || productCustomizationProvider.isEditorModeApplicable("org.eclipse.wst.xsd.ui.typeviz")) {
                    this.addMode(new TypeVizEditorMode());
                }
                super.init();
            }

            protected EditorMode getDefaultMode() {
                EditorMode editorMode;
                String defaultModeId = XSDEditorPlugin.getPlugin().getPreferenceStore().getString(InternalXSDMultiPageEditor.DEFAULT_EDITOR_MODE_ID);
                if (defaultModeId != null && (editorMode = this.getEditorMode(defaultModeId)) != null) {
                    return editorMode;
                }
                return super.getDefaultMode();
            }
        };
        manager.setProductCustomizationProvider(productCustomizationProvider);
        return manager;
    }

    protected void storeCurrentModePreference(String id) {
        XSDEditorPlugin.getPlugin().getPreferenceStore().setValue(DEFAULT_EDITOR_MODE_ID, id);
    }

    class InternalDocumentChangedNotifier
    implements IDocumentChangedNotifier {
        List list = new ArrayList();

        InternalDocumentChangedNotifier() {
        }

        public void addListener(INodeAdapter adapter) {
            this.list.add(adapter);
        }

        public void removeListener(INodeAdapter adapter) {
            this.list.remove(adapter);
        }

        public void notifyListeners(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            ArrayList clone = new ArrayList(this.list.size());
            clone.addAll(this.list);
            Iterator i = clone.iterator();
            while (i.hasNext()) {
                INodeAdapter adapter = (INodeAdapter)i.next();
                adapter.notifyChanged(notifier, eventType, changedFeature, oldValue, newValue, pos);
            }
        }
    }

    class OutlineTreeSelectionChangeListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private ISelection getXSDSelection(ISelection selection) {
            IStructuredSelection structuredSelection;
            Object o;
            StructuredSelection sel = null;
            if (selection instanceof IStructuredSelection && (o = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
                sel = new StructuredSelection(o);
            }
            return sel;
        }

        private Object getObjectForOtherModel(Object object) {
            Node node = null;
            if (object instanceof Node) {
                node = (Node)object;
            } else if (object instanceof XSDComponent) {
                node = ((XSDComponent)object).getElement();
            } else if (object instanceof CategoryAdapter) {
                node = ((CategoryAdapter)object).getXSDSchema().getElement();
            } else if (object instanceof XSDBaseAdapter && ((XSDBaseAdapter)object).getTarget() instanceof XSDConcreteComponent) {
                node = ((XSDConcreteComponent)((XSDBaseAdapter)object).getTarget()).getElement();
            }
            if (!(node instanceof IDOMNode)) {
                node = null;
            }
            return node;
        }

        public void doubleClick(DoubleClickEvent event) {
            if (InternalXSDMultiPageEditor.this.getSelectionManager() != null && InternalXSDMultiPageEditor.this.getSelectionManager().getEnableNotify()) {
                ISelection selection = this.getXSDSelection(event.getSelection());
                if (selection != null) {
                    InternalXSDMultiPageEditor.this.getSelectionManager().setSelection(selection, (ISelectionProvider)InternalXSDMultiPageEditor.this.fOutlinePage);
                }
                if (InternalXSDMultiPageEditor.this.getTextEditor() != null && selection instanceof IStructuredSelection) {
                    int start = -1;
                    int length = 0;
                    Object o = ((IStructuredSelection)selection).getFirstElement();
                    if (o != null) {
                        o = this.getObjectForOtherModel(o);
                    }
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o).getEndOffset() - start;
                    }
                    if (start > -1) {
                        InternalXSDMultiPageEditor.this.getTextEditor().selectAndReveal(start, length);
                    }
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (InternalXSDMultiPageEditor.this.getSelectionManager() != null && InternalXSDMultiPageEditor.this.getSelectionManager().getEnableNotify() && (selection = this.getXSDSelection(event.getSelection())) != null) {
                InternalXSDMultiPageEditor.this.getSelectionManager().setSelection(selection, (ISelectionProvider)InternalXSDMultiPageEditor.this.fOutlinePage);
            }
        }
    }

    private class SourceEditorSelectionListener
    implements ISelectionChangedListener {
        private SourceEditorSelectionListener() {
        }

        private Object getXSDNode(Object object) {
            XSDConcreteComponent modelObject;
            Node node;
            Element element = null;
            if (object instanceof Node && (node = (Node)object) != null) {
                if (node.getNodeType() == 1) {
                    element = (Element)node;
                } else if (node.getNodeType() == 2) {
                    element = ((Attr)node).getOwnerElement();
                }
            }
            Element o = element;
            if (element != null && (modelObject = InternalXSDMultiPageEditor.this.getXSDSchema().getCorrespondingComponent(element)) != null) {
                o = modelObject;
                o = XSDAdapterFactory.getInstance().adapt((Notifier)modelObject);
            }
            return o;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (InternalXSDMultiPageEditor.this.getSelectionManager().getEnableNotify() && InternalXSDMultiPageEditor.this.getActivePage() == 1 && (selection = event.getSelection()) instanceof IStructuredSelection) {
                ArrayList<Object> xsdSelections = new ArrayList<Object>();
                Iterator i = ((IStructuredSelection)selection).iterator();
                while (i.hasNext()) {
                    Object domNode = i.next();
                    Object xsdNode = this.getXSDNode(domNode);
                    if (xsdNode == null) continue;
                    xsdSelections.add(xsdNode);
                }
                if (!xsdSelections.isEmpty()) {
                    StructuredSelection xsdSelection = new StructuredSelection(xsdSelections);
                    InternalXSDMultiPageEditor.this.getSelectionManager().setSelection((ISelection)xsdSelection, InternalXSDMultiPageEditor.this.getTextEditor().getSelectionProvider());
                }
            }
        }
    }

    protected class XSDPreferenceStoreListener
    implements IPropertyChangeListener {
        protected XSDPreferenceStoreListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getProperty();
            if ("org.eclipse.wst.xsd.ui.showExternals".equals(property)) {
                ((GraphicalEditPart)InternalXSDMultiPageEditor.this.graphicalViewer.getContents()).getFigure().invalidateTree();
                InternalXSDMultiPageEditor.this.graphicalViewer.getContents().refresh();
            }
        }
    }

    private class XSDSelectionManagerSelectionListener
    implements ISelectionChangedListener {
        private XSDSelectionManagerSelectionListener() {
        }

        private Object getObjectForOtherModel(Object object) {
            Node node = null;
            if (object instanceof Node) {
                node = (Node)object;
            } else if (object instanceof XSDComponent) {
                node = ((XSDComponent)object).getElement();
            } else if (object instanceof CategoryAdapter) {
                node = ((CategoryAdapter)object).getXSDSchema().getElement();
            } else if (object instanceof XSDBaseAdapter) {
                if (((XSDBaseAdapter)object).getTarget() instanceof XSDConcreteComponent) {
                    node = ((XSDConcreteComponent)((XSDBaseAdapter)object).getTarget()).getElement();
                }
            } else if (object instanceof String) {
                String uriFragment = (String)object;
                Resource resource = InternalXSDMultiPageEditor.this.xsdSchema.eResource();
                EObject modelObject = resource.getEObject(uriFragment);
                if (modelObject != null && modelObject instanceof XSDComponent) {
                    XSDComponent component = (XSDComponent)modelObject;
                    node = component.getElement();
                }
            }
            if (!(node instanceof IDOMNode)) {
                node = null;
            }
            return node;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            IWorkbenchPage page;
            boolean makeSelection = true;
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getActivePart() instanceof InternalXSDMultiPageEditor && InternalXSDMultiPageEditor.this.getActiveEditor() instanceof StructuredTextEditor) {
                makeSelection = false;
            }
            if (event.getSource() != InternalXSDMultiPageEditor.this.getTextEditor().getSelectionProvider() && makeSelection && (selection = event.getSelection()) instanceof IStructuredSelection) {
                ArrayList<Object> otherModelObjectList = new ArrayList<Object>();
                Iterator i = ((IStructuredSelection)selection).iterator();
                while (i.hasNext()) {
                    Object modelObject = i.next();
                    Object otherModelObject = this.getObjectForOtherModel(modelObject);
                    if (otherModelObject == null) continue;
                    otherModelObjectList.add(otherModelObject);
                }
                if (!otherModelObjectList.isEmpty() && InternalXSDMultiPageEditor.this.getActivePage() == SOURCE_PAGE_INDEX) {
                    StructuredSelection nodeSelection = new StructuredSelection(otherModelObjectList);
                    InternalXSDMultiPageEditor.this.getTextEditor().getSelectionProvider().setSelection((ISelection)nodeSelection);
                }
            }
        }

        public void doSetSelection() {
            Object firstElement;
            Object otherModelObject;
            ISelection iSelection = InternalXSDMultiPageEditor.this.getSelectionManager().getSelection();
            if (iSelection != null && (otherModelObject = this.getObjectForOtherModel(firstElement = ((StructuredSelection)iSelection).getFirstElement())) != null) {
                StructuredSelection nodeSelection = new StructuredSelection(otherModelObject);
                InternalXSDMultiPageEditor.this.getTextEditor().getSelectionProvider().setSelection((ISelection)nodeSelection);
            }
        }
    }
}

