/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xsd.ui.internal.util.DocumentAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class ModelReconcileAdapter
extends DocumentAdapter
implements IModelStateListener {
    protected boolean handlingNotifyChanged = false;
    protected List listeners = new ArrayList();

    public ModelReconcileAdapter(Document document) {
        super(document);
    }

    public void addListener(INodeAdapter listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(INodeAdapter listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        ArrayList list = new ArrayList(this.listeners);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            INodeAdapter adapter = (INodeAdapter)i.next();
            adapter.notifyChanged(notifier, eventType, changedFeature, oldValue, newValue, pos);
        }
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        if (!this.handlingNotifyChanged) {
            this.handlingNotifyChanged = true;
            try {
                this.handleNotifyChange(notifier, eventType, feature, oldValue, newValue, index);
                this.notifyListeners(notifier, eventType, feature, oldValue, newValue, index);
            }
            catch (Exception exception) {}
            this.handlingNotifyChanged = false;
        }
    }

    protected void handleNodeChanged(Node node) {
    }

    public void handleNotifyChange(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        Node node = (Node)notifier;
        switch (eventType) {
            case 2: {
                if (!(newValue instanceof Element)) break;
                Element element = (Element)newValue;
                this.adapt(element);
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 4: {
                this.handleNodeChanged(node);
                break;
            }
            case 5: {
                if (feature instanceof Text) break;
                this.handleNodeChanged(node);
            }
        }
    }

    public void modelAboutToBeChanged(IStructuredModel model) {
    }

    public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
    }

    public void modelChanged(IStructuredModel model) {
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
    }

    public void modelReinitialized(IStructuredModel structuredModel) {
    }

    public void modelResourceDeleted(IStructuredModel model) {
    }

    public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
    }
}

