/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;
import org.eclipse.jpt.utility.internal.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedObject<E>
implements Cloneable,
Serializable {
    private E value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedObject(E value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedObject(E value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedObject() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E value() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(E value) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.value != value) {
                this.value = value;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(null);
        }
    }

    public Object mutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(E x) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value != x) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIsNot(E x) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value == x) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNotNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetValue(E x) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot(x);
            this.setValue(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilNotNull();
            this.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(E x, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            block5: {
                if (timeout != 0L) break block5;
                this.waitUntilValueIs(x);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.value != x && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.value == x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIsNot(E x, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            block5: {
                if (timeout != 0L) break block5;
                this.waitUntilValueIsNot(x);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.value == x && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.value != x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(null, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNotNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIsNot(null, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(E x, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIsNot(x, timeout);
            if (success) {
                this.setValue(x);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilNotNull(timeout);
            if (success) {
                this.setValue(null);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedObject<E> clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                SynchronizedObject clone = (SynchronizedObject)super.clone();
                return clone;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SynchronizedObject)) {
            return false;
        }
        E thisValue = this.value();
        E otherValue = ((SynchronizedObject)obj).value();
        return thisValue == null ? otherValue == null : thisValue.equals(otherValue);
    }

    public int hashCode() {
        E temp = this.value();
        return temp == null ? 0 : temp.hashCode();
    }

    public String toString() {
        return String.valueOf(this.value());
    }
}

