/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model;

import java.awt.EventQueue;
import java.io.Serializable;
import org.eclipse.jpt.utility.internal.model.ChangeEventDispatcher;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.TreeChangeListener;

public class AWTChangeEventDispatcher
implements ChangeEventDispatcher,
Serializable {
    private static ChangeEventDispatcher INSTANCE;
    private static final long serialVersionUID = 1L;

    public static synchronized ChangeEventDispatcher instance() {
        if (INSTANCE == null) {
            INSTANCE = new AWTChangeEventDispatcher();
        }
        return INSTANCE;
    }

    private AWTChangeEventDispatcher() {
    }

    public void stateChanged(final StateChangeListener listener, final StateChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.stateChanged(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.stateChanged(event);
                }

                public String toString() {
                    return "stateChanged";
                }
            });
        }
    }

    public void propertyChanged(final PropertyChangeListener listener, final PropertyChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.propertyChanged(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.propertyChanged(event);
                }

                public String toString() {
                    return "propertyChanged";
                }
            });
        }
    }

    public void itemsAdded(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsAdded(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.itemsAdded(event);
                }

                public String toString() {
                    return "itemsAdded (Collection)";
                }
            });
        }
    }

    public void itemsRemoved(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsRemoved(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.itemsRemoved(event);
                }

                public String toString() {
                    return "itemsRemoved (Collection)";
                }
            });
        }
    }

    public void collectionCleared(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.collectionCleared(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.collectionCleared(event);
                }

                public String toString() {
                    return "collectionCleared";
                }
            });
        }
    }

    public void collectionChanged(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.collectionChanged(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.collectionChanged(event);
                }

                public String toString() {
                    return "collectionChanged";
                }
            });
        }
    }

    public void itemsAdded(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsAdded(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.itemsAdded(event);
                }

                public String toString() {
                    return "itemsAdded (List)";
                }
            });
        }
    }

    public void itemsRemoved(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsRemoved(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.itemsRemoved(event);
                }

                public String toString() {
                    return "itemsRemoved (List)";
                }
            });
        }
    }

    public void itemsReplaced(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsReplaced(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.itemsReplaced(event);
                }

                public String toString() {
                    return "itemsReplaced (List)";
                }
            });
        }
    }

    public void itemsMoved(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsMoved(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.itemsMoved(event);
                }

                public String toString() {
                    return "itemsMoved (List)";
                }
            });
        }
    }

    public void listCleared(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.listCleared(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.listCleared(event);
                }

                public String toString() {
                    return "listCleared";
                }
            });
        }
    }

    public void listChanged(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.listChanged(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.listChanged(event);
                }

                public String toString() {
                    return "listChanged";
                }
            });
        }
    }

    public void nodeAdded(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.nodeAdded(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.nodeAdded(event);
                }

                public String toString() {
                    return "nodeAdded";
                }
            });
        }
    }

    public void nodeRemoved(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.nodeRemoved(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.nodeRemoved(event);
                }

                public String toString() {
                    return "nodeRemoved";
                }
            });
        }
    }

    public void treeCleared(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.treeCleared(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.treeCleared(event);
                }

                public String toString() {
                    return "treeCleared";
                }
            });
        }
    }

    public void treeChanged(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.treeChanged(event);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listener.treeChanged(event);
                }

                public String toString() {
                    return "treeChanged";
                }
            });
        }
    }

    private void invoke(Runnable r) {
        EventQueue.invokeLater(r);
    }

    private Object readResolve() {
        return AWTChangeEventDispatcher.instance();
    }
}

