/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.event;

import org.eclipse.jpt.utility.internal.model.event.ChangeEvent;

public class PropertyChangeEvent
extends ChangeEvent {
    private final String propertyName;
    private final Object oldValue;
    private final Object newValue;
    private static final long serialVersionUID = 1L;

    public PropertyChangeEvent(Object source, String propertyName, Object oldValue, Object newValue) {
        super(source);
        if (propertyName == null) {
            throw new NullPointerException();
        }
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String propertyName() {
        return this.propertyName;
    }

    public Object oldValue() {
        return this.oldValue;
    }

    public Object newValue() {
        return this.newValue;
    }

    public String aspectName() {
        return this.propertyName;
    }

    public PropertyChangeEvent cloneWithSource(Object newSource) {
        return new PropertyChangeEvent(newSource, this.propertyName, this.oldValue, this.newValue);
    }

    public PropertyChangeEvent cloneWithSource(Object newSource, String newPropertyName) {
        return new PropertyChangeEvent(newSource, newPropertyName, this.oldValue, this.newValue);
    }
}

