/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.listener;

import java.lang.reflect.Method;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ReflectiveChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;

class SingleMethodReflectiveChangeListener
extends ReflectiveChangeListener
implements StateChangeListener,
PropertyChangeListener {
    private final Method method;
    private final boolean methodIsZeroArgument;

    SingleMethodReflectiveChangeListener(Object target, Method method) {
        super(target);
        this.method = method;
        this.methodIsZeroArgument = method.getParameterTypes().length == 0;
    }

    public void stateChanged(StateChangeEvent event) {
        if (this.methodIsZeroArgument) {
            ClassTools.executeMethod(this.method, this.target, EMPTY_STATE_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.executeMethod(this.method, this.target, new StateChangeEvent[]{event});
        }
    }

    public void propertyChanged(PropertyChangeEvent event) {
        if (this.methodIsZeroArgument) {
            ClassTools.executeMethod(this.method, this.target, EMPTY_PROPERTY_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.executeMethod(this.method, this.target, new PropertyChangeEvent[]{event});
        }
    }
}

