/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeEventDispatcher;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.node.DefaultProblem;
import org.eclipse.jpt.utility.internal.node.Node;
import org.eclipse.jpt.utility.internal.node.NodeModel;
import org.eclipse.jpt.utility.internal.node.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeModel
extends AbstractModel
implements NodeModel {
    private volatile Node parent;
    private volatile String comment;
    public static final String COMMENT_PROPERTY = "comment";
    private volatile boolean dirty;
    private volatile boolean dirtyBranch;
    private List<Problem> problems;
    private static final Object[] EMPTY_PROBLEM_MESSAGE_ARGUMENTS = new Object[0];
    private List<Problem> branchProblems;
    private static final Map<Class<? extends AbstractNodeModel>, Set<String>> transientAspectNameSets = new Hashtable<Class<? extends AbstractNodeModel>, Set<String>>();
    private static final Map<Class<? extends AbstractNodeModel>, Set<String>> nonValidatedAspectNameSets = new Hashtable<Class<? extends AbstractNodeModel>, Set<String>>();

    protected AbstractNodeModel(Node parent) {
        this.initialize(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.comment = "";
        this.dirty = true;
        this.dirtyBranch = true;
        this.problems = new Vector<Problem>();
        this.branchProblems = new Vector<Problem>();
    }

    protected void initialize(Node parentNode) {
        this.checkParent(parentNode);
        this.parent = parentNode;
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new ChangeSupport(this){
            private static final long serialVersionUID = 1L;

            protected ChangeEventDispatcher dispatcher() {
                return AbstractNodeModel.this.changeEventDispatcher();
            }

            protected ChangeSupport buildChildChangeSupport() {
                return AbstractNodeModel.this.buildChildChangeSupport();
            }

            protected void sourceChanged(String aspectName) {
                super.sourceChanged(aspectName);
                AbstractNodeModel.this.aspectChanged(aspectName);
            }
        };
    }

    protected ChangeSupport buildChildChangeSupport() {
        return new ChangeSupport(this){
            private static final long serialVersionUID = 1L;

            protected ChangeEventDispatcher dispatcher() {
                return AbstractNodeModel.this.changeEventDispatcher();
            }

            protected ChangeSupport buildChildChangeSupport() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final Node parent() {
        return this.parent;
    }

    protected void checkParent(Node parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException("The parent node cannot be null");
        }
    }

    @Override
    public final Iterator<Node> children() {
        ArrayList<Node> children = new ArrayList<Node>();
        this.addChildrenTo(children);
        return children.iterator();
    }

    protected void addChildrenTo(List<Node> list) {
    }

    @Override
    public final boolean isDescendantOf(Node node) {
        return this == node || this.parentIsDescendantOf(node);
    }

    protected boolean parentIsDescendantOf(Node node) {
        return this.parent != null && this.parent.isDescendantOf(node);
    }

    public final Iterator<Node> branchReferences() {
        ArrayList<Node> branchReferences = new ArrayList<Node>(1000);
        this.addBranchReferencesTo(branchReferences);
        return branchReferences.iterator();
    }

    @Override
    public final void addBranchReferencesTo(Collection<Node> branchReferences) {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.addBranchReferencesTo(branchReferences);
        }
    }

    public final Iterator<Node> allNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>(1000);
        this.addAllNodesTo(nodes);
        return nodes.iterator();
    }

    @Override
    public final void addAllNodesTo(Collection<Node> nodes) {
        nodes.add(this);
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.addAllNodesTo(nodes);
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.nodeRemoved(node);
        }
    }

    protected boolean nodeIsDescendantOf(Node node1, Node node2) {
        return node1 != null && node1.isDescendantOf(node2);
    }

    @Override
    public void nodeRenamed(Node node) {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.nodeRenamed(node);
        }
    }

    public final String comment() {
        return this.comment;
    }

    public final void setComment(String comment) {
        String old = this.comment;
        this.comment = comment;
        this.firePropertyChanged(COMMENT_PROPERTY, old, comment);
    }

    @Override
    public ChangeEventDispatcher changeEventDispatcher() {
        if (this.parent == null) {
            throw new IllegalStateException("This node should not be firing change events during its construction.");
        }
        return this.parent.changeEventDispatcher();
    }

    @Override
    public void setChangeEventDispatcher(ChangeEventDispatcher changeEventDispatcher) {
        if (this.parent == null) {
            throw new IllegalStateException("This root node should implement #setChangeEventDispatcher(ChangeEventDispatcher).");
        }
        throw new UnsupportedOperationException("Only root nodes implement #setChangeEventDispatcher(ChangeEventDispatcher).");
    }

    protected void aspectChanged(String aspectName) {
        if (this.aspectIsPersistent(aspectName)) {
            this.markDirty();
        }
        if (this.aspectChangeRequiresValidation(aspectName)) {
            this.validator().validate();
        }
    }

    @Override
    public Node.Validator validator() {
        if (this.parent == null) {
            throw new IllegalStateException("This node should not be firing change events during its construction.");
        }
        return this.parent.validator();
    }

    @Override
    public void setValidator(Node.Validator validator) {
        if (this.parent == null) {
            throw new IllegalStateException("This root node should implement #setValidator(Node.Validator).");
        }
        throw new UnsupportedOperationException("Only root nodes implement #setValidator(Node.Validator).");
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public final boolean isDirtyBranch() {
        return this.dirtyBranch;
    }

    public final boolean isClean() {
        return !this.dirty;
    }

    public final boolean isCleanBranch() {
        return !this.dirtyBranch;
    }

    private void setIsDirtyBranch(boolean dirtyBranch) {
        boolean old = this.dirtyBranch;
        this.dirtyBranch = dirtyBranch;
        this.firePropertyChanged("dirtyBranch", old, dirtyBranch);
    }

    private void markDirty() {
        this.dirty = true;
        this.markBranchDirty();
    }

    @Override
    public void markBranchDirty() {
        if (this.dirtyBranch) {
            return;
        }
        this.setIsDirtyBranch(true);
        this.markParentBranchDirty();
    }

    protected void markParentBranchDirty() {
        if (this.parent != null) {
            this.parent.markBranchDirty();
        }
    }

    @Override
    public final void markEntireBranchDirty() {
        this.markDirty();
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.markEntireBranchDirty();
        }
    }

    public final void markEntireBranchClean() {
        this.cascadeMarkEntireBranchClean();
        this.markParentBranchCleanIfPossible();
    }

    protected void markParentBranchCleanIfPossible() {
        if (this.parent != null) {
            this.parent.markBranchCleanIfPossible();
        }
    }

    @Override
    public final void cascadeMarkEntireBranchClean() {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.cascadeMarkEntireBranchClean();
        }
        this.dirty = false;
        this.setIsDirtyBranch(false);
    }

    @Override
    public final void markBranchCleanIfPossible() {
        if (this.dirty) {
            return;
        }
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            if (!child.isDirtyBranch()) continue;
            return;
        }
        this.setIsDirtyBranch(false);
        this.markParentBranchCleanIfPossible();
    }

    private boolean aspectIsPersistent(String aspectName) {
        return !this.aspectIsTransient(aspectName);
    }

    private boolean aspectIsTransient(String aspectName) {
        return this.transientAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> transientAspectNames() {
        Map<Class<? extends AbstractNodeModel>, Set<String>> map = transientAspectNameSets;
        synchronized (map) {
            Set<String> transientAspectNames = transientAspectNameSets.get(this.getClass());
            if (transientAspectNames == null) {
                transientAspectNames = new HashSet<String>();
                this.addTransientAspectNamesTo(transientAspectNames);
                transientAspectNameSets.put(this.getClass(), transientAspectNames);
            }
            return transientAspectNames;
        }
    }

    protected void addTransientAspectNamesTo(Set<String> transientAspectNames) {
        transientAspectNames.add("dirtyBranch");
        transientAspectNames.add("branchProblems");
        transientAspectNames.add("hasBranchProblems");
    }

    public final Iterator<Node> allDirtyNodes() {
        return new FilteringIterator<Node>(this.allNodes()){

            @Override
            protected boolean accept(Object o) {
                return o instanceof AbstractNodeModel && ((AbstractNodeModel)o).isDirty();
            }
        };
    }

    public final Iterator<Problem> problems() {
        return new CloneIterator<Problem>(this.problems);
    }

    public final int problemsSize() {
        return this.problems.size();
    }

    public final boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @Override
    public final ListIterator<Problem> branchProblems() {
        return new CloneListIterator<Problem>(this.branchProblems);
    }

    @Override
    public final int branchProblemsSize() {
        return this.branchProblems.size();
    }

    @Override
    public final boolean hasBranchProblems() {
        return !this.branchProblems.isEmpty();
    }

    @Override
    public final boolean containsBranchProblem(Problem problem) {
        return this.branchProblems.contains(problem);
    }

    protected final Problem buildProblem(String messageKey, Object[] messageArguments) {
        return new DefaultProblem(this, messageKey, messageArguments);
    }

    protected final Problem buildProblem(String messageKey) {
        return this.buildProblem(messageKey, EMPTY_PROBLEM_MESSAGE_ARGUMENTS);
    }

    protected final Problem buildProblem(String messageKey, Object messageArgument) {
        return this.buildProblem(messageKey, new Object[]{messageArgument});
    }

    protected final Problem buildProblem(String messageKey, Object messageArgument1, Object messageArgument2) {
        return this.buildProblem(messageKey, new Object[]{messageArgument1, messageArgument2});
    }

    protected final Problem buildProblem(String messageKey, Object messageArgument1, Object messageArgument2, Object messageArgument3) {
        return this.buildProblem(messageKey, new Object[]{messageArgument1, messageArgument2, messageArgument3});
    }

    @Override
    public void validateBranch() {
        if (this.validateBranchInternal()) {
            this.rebuildParentBranchProblems();
        }
    }

    protected void rebuildParentBranchProblems() {
        if (this.parent != null) {
            this.parent.rebuildBranchProblems();
        }
    }

    @Override
    public boolean validateBranchInternal() {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.validateBranchInternal();
        }
        this.problems.clear();
        this.addProblemsTo(this.problems);
        return this.checkBranchProblems();
    }

    protected void addProblemsTo(List<Problem> currentProblems) {
    }

    private boolean checkBranchProblems() {
        Vector<Problem> oldBranchProblems = new Vector<Problem>(this.branchProblems);
        int oldSize = this.branchProblems.size();
        this.branchProblems.clear();
        this.branchProblems.addAll(this.problems);
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.addBranchProblemsTo(this.branchProblems);
        }
        int newSize = this.branchProblems.size();
        if (oldSize == 0 && newSize != 0) {
            this.firePropertyChanged("hasBranchProblems", false, true);
        } else if (oldSize != 0 && newSize == 0) {
            this.firePropertyChanged("hasBranchProblems", true, false);
        }
        if (oldBranchProblems.equals(this.branchProblems)) {
            return false;
        }
        this.fireListChanged("branchProblems");
        return true;
    }

    @Override
    public final void addBranchProblemsTo(List<Problem> list) {
        list.addAll(this.branchProblems);
    }

    @Override
    public final void rebuildBranchProblems() {
        if (!this.checkBranchProblems()) {
            throw new IllegalStateException("we should not get here unless our \"branch\" problems have changed");
        }
        this.rebuildParentBranchProblems();
    }

    @Override
    public final void clearAllBranchProblems() {
        if (this.clearAllBranchProblemsInternal()) {
            this.rebuildParentBranchProblems();
        }
    }

    @Override
    public final boolean clearAllBranchProblemsInternal() {
        if (this.branchProblems.isEmpty()) {
            return false;
        }
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.clearAllBranchProblemsInternal();
        }
        this.problems.clear();
        this.branchProblems.clear();
        this.firePropertyChanged("hasBranchProblems", true, false);
        this.fireListChanged("branchProblems");
        return true;
    }

    private boolean aspectChangeRequiresValidation(String aspectName) {
        return !this.aspectChangeDoesNotRequireValidation(aspectName);
    }

    private boolean aspectChangeDoesNotRequireValidation(String aspectName) {
        return this.nonValidatedAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> nonValidatedAspectNames() {
        Map<Class<? extends AbstractNodeModel>, Set<String>> map = nonValidatedAspectNameSets;
        synchronized (map) {
            Set<String> nonValidatedAspectNames = nonValidatedAspectNameSets.get(this.getClass());
            if (nonValidatedAspectNames == null) {
                nonValidatedAspectNames = new HashSet<String>();
                this.addNonValidatedAspectNamesTo(nonValidatedAspectNames);
                nonValidatedAspectNameSets.put(this.getClass(), nonValidatedAspectNames);
            }
            return nonValidatedAspectNames;
        }
    }

    protected void addNonValidatedAspectNamesTo(Set<String> nonValidatedAspectNames) {
        nonValidatedAspectNames.add(COMMENT_PROPERTY);
        nonValidatedAspectNames.add("dirtyBranch");
        nonValidatedAspectNames.add("branchProblems");
        nonValidatedAspectNames.add("hasBranchProblems");
    }

    @Override
    public int compareTo(Node node) {
        return DEFAULT_COMPARATOR.compare(this, node);
    }

    @Override
    public final String toString() {
        return super.toString();
    }
}

