/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.actions.ResourceActionDelegate;

public class FormatActionDelegate
extends ResourceActionDelegate {
    private MultiStatus fErrorStatus = new MultiStatus("org.eclipse.wst.sse.ui", 4, SSEUIMessages.FormatActionDelegate_errorStatusMessage, null);

    protected void format(IProgressMonitor monitor, IFile file) {
        try {
            IContentType contentType;
            IStructuredFormatProcessor formatProcessor;
            monitor.beginTask("", 100);
            IContentDescription contentDescription = file.getContentDescription();
            monitor.worked(5);
            if (!(contentDescription == null || (formatProcessor = this.getFormatProcessor((contentType = contentDescription.getContentType()).getId())) == null || monitor != null && monitor.isCanceled())) {
                String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_3, (Object[])new String[]{file.getFullPath().toString().substring(1)});
                monitor.subTask(message);
                formatProcessor.setProgressMonitor(monitor);
                formatProcessor.formatFile(file);
            }
            monitor.worked(95);
            monitor.done();
        }
        catch (MalformedInputExceptionWithDetail e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_5, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
    }

    protected void format(IProgressMonitor monitor, IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (monitor == null || !monitor.isCanceled()) {
                this.format(monitor, file);
            }
        } else if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                IResource[] members = container.members();
                monitor.beginTask("", members.length);
                int i = 0;
                while (i < members.length) {
                    if (monitor == null || !monitor.isCanceled()) {
                        this.format((IProgressMonitor)new SubProgressMonitor(monitor, 1), members[i]);
                    }
                    ++i;
                }
                monitor.done();
            }
            catch (CoreException e) {
                String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{resource.getFullPath().toString()});
                this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
            }
        }
    }

    protected IStructuredFormatProcessor getFormatProcessor(String contentTypeId) {
        return FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentTypeId);
    }

    protected Job getJob() {
        return new FormatJob(SSEUIMessages.FormatActionDelegate_jobName);
    }

    protected void process(IProgressMonitor monitor, IResource resource) {
        monitor.beginTask("", 100);
        this.format((IProgressMonitor)new SubProgressMonitor(monitor, 98), resource);
        try {
            resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{resource.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        monitor.done();
    }

    protected boolean processorAvailable(IResource resource) {
        boolean result;
        block8: {
            result = false;
            if (resource.isAccessible()) {
                try {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        IStructuredFormatProcessor formatProcessor = null;
                        IContentDescription contentDescription = file.getContentDescription();
                        if (contentDescription != null) {
                            IContentType contentType = contentDescription.getContentType();
                            formatProcessor = this.getFormatProcessor(contentType.getId());
                        }
                        if (formatProcessor != null) {
                            result = true;
                        }
                        break block8;
                    }
                    if (!(resource instanceof IContainer)) break block8;
                    IContainer container = (IContainer)resource;
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        boolean available = this.processorAvailable(members[i]);
                        if (available) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        return result;
    }

    class FormatJob
    extends Job {
        public FormatJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            Object[] elements = FormatActionDelegate.this.fSelection.toArray();
            monitor.beginTask("", elements.length);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IResource) {
                    FormatActionDelegate.this.process((IProgressMonitor)new SubProgressMonitor(monitor, 1), (IResource)elements[i]);
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
            monitor.done();
            if (FormatActionDelegate.this.fErrorStatus.getChildren().length > 0) {
                status = FormatActionDelegate.this.fErrorStatus;
                FormatActionDelegate.this.fErrorStatus = new MultiStatus("org.eclipse.wst.sse.ui", 4, SSEUIMessages.FormatActionDelegate_errorStatusMessage, null);
            }
            return status;
        }
    }
}

