/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.extension;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.IActionValidator;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.extension.ExtendedEditorActionProxy;
import org.eclipse.wst.sse.ui.internal.extension.ExtendedEditorActionProxyForDelayLoading;
import org.eclipse.wst.sse.ui.internal.extension.ImageUtil;
import org.osgi.framework.Bundle;

public class ActionDescriptor {
    public static final String ATT_ACCELERATOR = "accelerator";
    public static final String ATT_CLASS = "class";
    public static final String ATT_DEFINITION_ID = "definitionId";
    public static final String ATT_DESCRIPTION = "description";
    public static final String ATT_DISABLEDICON = "disabledIcon";
    public static final String ATT_HELP_CONTEXT_ID = "helpContextId";
    public static final String ATT_HOVERICON = "hoverIcon";
    public static final String ATT_ICON = "icon";
    public static final String ATT_ID = "id";
    public static final String ATT_LABEL = "label";
    public static final String ATT_MENUBAR_PATH = "menubarPath";
    public static final String ATT_POPUPMENU_PATH = "popupmenuPath";
    public static final String ATT_STATE = "state";
    public static final String ATT_TOOLBAR_PATH = "toolbarPath";
    public static final String ATT_TOOLTIP = "tooltip";
    private String id;
    private ActionContributionItem item;
    private String menuGroup;
    private String menuPath;
    private String popupmenuGroup;
    private String popupmenuPath;
    private String toolbarGroup;
    private String toolbarPath;

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) {
        final Object[] result = new Object[1];
        String pluginId = element.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle.getState() == 32) {
            try {
                result[0] = element.createExecutableExtension(classAttribute);
            }
            catch (Exception e) {
                ActionDescriptor.handleCreateExecutableException(result, e);
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        result[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (Exception e) {
                        ActionDescriptor.handleCreateExecutableException(result, e);
                    }
                }
            });
        }
        return result[0];
    }

    private static void handleCreateExecutableException(Object[] result, Throwable e) {
        Logger.logException(e);
        result[0] = null;
    }

    public ActionDescriptor(IConfigurationElement actionElement) throws CoreException {
        String accelerator;
        String disabledIcon;
        String hoverIcon;
        String icon;
        String state;
        String description;
        String helpContextId;
        String tooltip;
        String defId;
        String mpath = actionElement.getAttribute(ATT_MENUBAR_PATH);
        String mgroup = null;
        if (mpath != null) {
            int loc = mpath.lastIndexOf(47);
            if (loc != -1) {
                mgroup = mpath.substring(loc + 1);
                mpath = mpath.substring(0, loc);
            } else {
                mgroup = mpath;
                mpath = null;
            }
        }
        this.menuPath = mpath;
        this.menuGroup = mgroup;
        String ppath = actionElement.getAttribute(ATT_POPUPMENU_PATH);
        String pgroup = null;
        if (ppath != null) {
            int loc = ppath.lastIndexOf(47);
            if (loc != -1) {
                pgroup = ppath.substring(loc + 1);
                ppath = ppath.substring(0, loc);
            } else {
                pgroup = ppath;
                ppath = null;
            }
        }
        this.popupmenuPath = ppath;
        this.popupmenuGroup = pgroup;
        String tpath = actionElement.getAttribute(ATT_TOOLBAR_PATH);
        String tgroup = null;
        if (tpath != null) {
            int loc = tpath.lastIndexOf(47);
            if (loc != -1) {
                tgroup = tpath.substring(loc + 1);
                tpath = tpath.substring(0, loc);
            } else {
                tgroup = tpath;
                tpath = null;
            }
        }
        this.toolbarPath = tpath;
        this.toolbarGroup = tgroup;
        IAction action = this.createAction(actionElement);
        if (action == null) {
            return;
        }
        String label = actionElement.getAttribute(ATT_LABEL);
        if (label != null) {
            action.setText(label);
        }
        this.id = actionElement.getAttribute(ATT_ID);
        if (this.id == null) {
            this.id = actionElement.getAttribute(ATT_CLASS);
        }
        if (this.id != null) {
            action.setId(this.id);
        }
        if ((defId = actionElement.getAttribute(ATT_DEFINITION_ID)) != null && defId.length() != 0) {
            action.setActionDefinitionId(defId);
        }
        if ((tooltip = actionElement.getAttribute(ATT_TOOLTIP)) != null) {
            action.setToolTipText(tooltip);
        }
        if ((helpContextId = actionElement.getAttribute(ATT_HELP_CONTEXT_ID)) != null) {
            String fullID = helpContextId;
            if (helpContextId.indexOf(".") == -1) {
                fullID = String.valueOf(actionElement.getDeclaringExtension().getNamespace()) + "." + helpContextId;
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp(action, fullID);
        }
        if ((description = actionElement.getAttribute(ATT_DESCRIPTION)) != null) {
            action.setDescription(description);
        }
        if ((state = actionElement.getAttribute(ATT_STATE)) != null) {
            action.setChecked(state.equals("true"));
        }
        if ((icon = actionElement.getAttribute(ATT_ICON)) != null) {
            action.setImageDescriptor(ImageUtil.getImageDescriptorFromExtension(actionElement.getDeclaringExtension(), icon));
        }
        if ((hoverIcon = actionElement.getAttribute(ATT_HOVERICON)) != null) {
            action.setHoverImageDescriptor(ImageUtil.getImageDescriptorFromExtension(actionElement.getDeclaringExtension(), hoverIcon));
        }
        if ((disabledIcon = actionElement.getAttribute(ATT_DISABLEDICON)) != null) {
            action.setDisabledImageDescriptor(ImageUtil.getImageDescriptorFromExtension(actionElement.getDeclaringExtension(), disabledIcon));
        }
        if ((accelerator = actionElement.getAttribute(ATT_ACCELERATOR)) != null) {
            this.processAccelerator(action, accelerator);
        }
        this.item = new ActionContributionItem(action);
    }

    private int convertAccelerator(String acceleratorText) {
        int accelerator = 0;
        StringTokenizer stok = new StringTokenizer(acceleratorText, "+");
        int keyCode = -1;
        boolean hasMoreTokens = stok.hasMoreTokens();
        while (hasMoreTokens) {
            String token = stok.nextToken();
            hasMoreTokens = stok.hasMoreTokens();
            if (hasMoreTokens) {
                int modifier = Action.findModifier((String)token);
                if (modifier != 0) {
                    accelerator |= modifier;
                    continue;
                }
                return 0;
            }
            keyCode = Action.findKeyCode((String)token);
        }
        if (keyCode != -1) {
            accelerator |= keyCode;
        }
        return accelerator;
    }

    private IAction createAction(IConfigurationElement actionElement) {
        ExtendedEditorActionProxyForDelayLoading action = new ExtendedEditorActionProxyForDelayLoading(actionElement, ATT_CLASS);
        if (action == null) {
            return null;
        }
        if (action instanceof IActionValidator && !((IActionValidator)((Object)action)).isValidAction()) {
            return null;
        }
        return action instanceof IAction ? (IAction)ExtendedEditorActionProxy.newInstance(action) : null;
    }

    public IAction getAction() {
        return this.item != null ? this.item.getAction() : null;
    }

    public IContributionItem getContributionItem() {
        return this.item;
    }

    public String getId() {
        return this.id;
    }

    public String getMenuGroup() {
        return this.menuGroup;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public String getPopupMenuGroup() {
        return this.popupmenuGroup;
    }

    public String getPopupMenuPath() {
        return this.popupmenuPath;
    }

    public String getToolbarGroup() {
        return this.toolbarGroup;
    }

    public String getToolbarPath() {
        return this.toolbarPath;
    }

    private void processAccelerator(IAction action, String acceleratorText) {
        if (acceleratorText.length() == 0) {
            return;
        }
        if (Character.isDigit(acceleratorText.charAt(0))) {
            try {
                action.setAccelerator(Integer.valueOf(acceleratorText).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                Logger.log(4, "Invalid accelerator declaration: " + this.id);
            }
        } else {
            action.setAccelerator(this.convertAccelerator(acceleratorText));
        }
    }

    public String toString() {
        return "ActionDescriptor(" + this.id + ")";
    }
}

