/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel.tld;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.internal.util.FileContentCache;
import org.eclipse.jst.jsp.core.internal.util.ZeroStructuredDocumentRegion;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandlerExtension;
import org.eclipse.wst.sse.core.internal.ltk.parser.TagMarker;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;

public class TLDCMDocumentManager
implements ITaglibIndexListener {
    static final boolean _debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/tldcmdocument/manager"));
    static final boolean _debugCache = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/tldcmdocument/cache"));
    protected static List bannedPrefixes = null;
    private static Hashtable fCache = null;
    String XMLNS = "xmlns:";
    protected String URN_TAGDIR = "urn:jsptagdir:";
    protected String URN_TLD = "urn:jsptld:";
    int XMLNS_LENGTH = this.XMLNS.length();
    private CMDocumentFactoryTLD fCMDocumentBuilder = null;
    private DirectiveStructuredDocumentRegionHandler fDirectiveHandler = null;
    private Hashtable fDocuments = null;
    HashMap fInclude2TimestampMap = new HashMap();
    private Stack fIncludes = null;
    private JSPSourceParser fParser = null;
    private List fTaglibTrackers = null;
    Map fTLDCMReferencesMap = new HashMap();
    boolean fProcessIncludes = true;
    boolean preludesHandled = false;

    static {
        bannedPrefixes = new ArrayList(7);
        bannedPrefixes.add("jsp");
        bannedPrefixes.add("jspx");
        bannedPrefixes.add("java");
        bannedPrefixes.add("javax");
        bannedPrefixes.add("servlet");
        bannedPrefixes.add("sun");
        bannedPrefixes.add("sunw");
    }

    public static Hashtable getSharedDocumentCache() {
        if (fCache == null) {
            fCache = new Hashtable();
        }
        return fCache;
    }

    public static Object getUniqueIdentifier(ITaglibRecord reference) {
        if (reference == null) {
            return null;
        }
        Object identifier = null;
        switch (reference.getRecordType()) {
            case 1: {
                ITLDRecord record = (ITLDRecord)reference;
                identifier = record.getPath();
                break;
            }
            case 2: {
                IJarRecord record = (IJarRecord)reference;
                identifier = record.getLocation();
                break;
            }
            case 8: {
                ITagDirRecord record = (ITagDirRecord)reference;
                identifier = record.getPath();
                break;
            }
            case 4: {
                IURLRecord record = (IURLRecord)reference;
                identifier = record.getURL();
                break;
            }
            default: {
                identifier = reference;
            }
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (_debugCache) {
            System.out.println("TLDCMDocumentManager cleared its private CMDocument cache");
        }
        Iterator iter = this.getDocuments().keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Hashtable hashtable = TLDCMDocumentManager.getSharedDocumentCache();
            synchronized (hashtable) {
                Object o = TLDCMDocumentManager.getSharedDocumentCache().get(key);
                if (o instanceof TLDCacheEntry) {
                    TLDCacheEntry entry = (TLDCacheEntry)o;
                    --entry.referenceCount;
                    if (entry.referenceCount <= 0) {
                        TLDCMDocumentManager.getSharedDocumentCache().put(key, new WeakReference<TLDCacheEntry>(entry));
                    }
                }
            }
        }
    }

    protected Object getCacheKey(String uri) {
        ITaglibRecord record = TaglibIndex.resolve(this.getCurrentParserPath().toString(), uri, false);
        if (record != null) {
            return TLDCMDocumentManager.getUniqueIdentifier(record);
        }
        String location = URIResolverPlugin.createResolver().resolve(this.getCurrentBaseLocation().toString(), null, uri);
        return location;
    }

    protected CMDocument getCMDocument(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String reference = uri;
        Object cacheKey = this.getCacheKey(reference);
        long lastModified = this.getModificationStamp(reference);
        CMDocument doc = (CMDocument)this.getDocuments().get(cacheKey);
        if (doc == null) {
            Object o = TLDCMDocumentManager.getSharedDocumentCache().get(cacheKey);
            if (o != null) {
                TLDCacheEntry entry;
                if (o instanceof TLDCacheEntry) {
                    entry = (TLDCacheEntry)o;
                    if (_debugCache) {
                        System.out.println("TLDCMDocument cache hit on " + cacheKey);
                    }
                    if (entry != null && entry.modificationStamp != -1L && entry.modificationStamp >= lastModified) {
                        doc = entry.document;
                        ++entry.referenceCount;
                    } else {
                        TLDCMDocumentManager.getSharedDocumentCache().remove(cacheKey);
                    }
                } else if (o instanceof Reference) {
                    entry = (TLDCacheEntry)((Reference)o).get();
                    if (entry != null) {
                        if (entry.modificationStamp != -1L && entry.modificationStamp >= lastModified) {
                            doc = entry.document;
                            entry.referenceCount = 1;
                            TLDCMDocumentManager.getSharedDocumentCache().put(cacheKey, entry);
                        }
                    } else {
                        TLDCMDocumentManager.getSharedDocumentCache().remove(cacheKey);
                    }
                }
            }
            if (doc == null) {
                TLDCMDocumentDescriptor descriptor;
                if (_debugCache) {
                    System.out.println("TLDCMDocument cache miss on " + cacheKey);
                }
                if ((descriptor = this.loadTaglib(reference)) != null) {
                    TLDCacheEntry entry = new TLDCacheEntry();
                    doc = entry.document = descriptor.document;
                    entry.referenceCount = 1;
                    entry.modificationStamp = this.getModificationStamp(reference);
                    TLDCMDocumentManager.getSharedDocumentCache().put(cacheKey, entry);
                }
            }
            if (doc != null) {
                this.getDocuments().put(cacheKey, doc);
            }
        }
        return doc;
    }

    private long getModificationStamp(String reference) {
        ITaglibRecord record = TaglibIndex.resolve(this.getCurrentParserPath().toString(), reference, false);
        long modificationStamp = -1L;
        if (record != null) {
            switch (record.getRecordType()) {
                case 1: {
                    IFile tldfile = ResourcesPlugin.getWorkspace().getRoot().getFile(((ITLDRecord)record).getPath());
                    if (!tldfile.isAccessible()) break;
                    modificationStamp = tldfile.getModificationStamp();
                    break;
                }
                case 2: {
                    File jarfile = new File(((IJarRecord)record).getLocation().toOSString());
                    if (!jarfile.exists()) break;
                    try {
                        modificationStamp = jarfile.lastModified();
                    }
                    catch (SecurityException securityException) {
                        modificationStamp = -1L;
                    }
                    break;
                }
                case 8: {
                    IFolder tagFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(((ITagDirRecord)record).getPath());
                    if (!tagFolder.isAccessible()) break;
                    try {
                        IResource[] members = tagFolder.members();
                        int i = 0;
                        while (i < members.length) {
                            modificationStamp = Math.max(modificationStamp, members[i].getModificationStamp());
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {
                        modificationStamp = -1L;
                    }
                    break;
                }
                case 4: {
                    modificationStamp = -1L;
                    break;
                }
            }
        }
        return modificationStamp;
    }

    protected CMDocumentFactoryTLD getCMDocumentBuilder() {
        if (this.fCMDocumentBuilder == null) {
            this.fCMDocumentBuilder = new CMDocumentFactoryTLD();
        }
        return this.fCMDocumentBuilder;
    }

    public List getCMDocumentTrackers(int offset) {
        ArrayList<TaglibTracker> validDocs = new ArrayList<TaglibTracker>();
        Iterator alldocs = this.getTaglibTrackers().iterator();
        while (alldocs.hasNext()) {
            TaglibTracker aTracker = (TaglibTracker)alldocs.next();
            if (aTracker.getStructuredDocumentRegion().getStartOffset() >= offset && offset >= 0) continue;
            validDocs.add(aTracker);
        }
        return validDocs;
    }

    public List getCMDocumentTrackers(String prefix, int offset) {
        ArrayList<TaglibTracker> validDocs = new ArrayList<TaglibTracker>();
        Iterator alldocs = this.getTaglibTrackers().iterator();
        while (alldocs.hasNext()) {
            TaglibTracker aTracker = (TaglibTracker)alldocs.next();
            if (aTracker.getStructuredDocumentRegion().getStartOffset() >= offset && offset >= 0 || !aTracker.getPrefix().equals(prefix)) continue;
            validDocs.add(aTracker);
        }
        return validDocs;
    }

    IPath getCurrentBaseLocation() {
        IPath baseLocation = null;
        IPath path = this.getCurrentParserPath();
        baseLocation = ResourcesPlugin.getWorkspace().getRoot().getFile(path).getLocation();
        if (baseLocation == null) {
            baseLocation = path;
        }
        return baseLocation;
    }

    IPath getCurrentParserPath() {
        IPath path = null;
        path = !this.getIncludes().isEmpty() ? (IPath)this.getIncludes().peek() : TaglibController.getFileBuffer(this).getLocation();
        return path;
    }

    protected DirectiveStructuredDocumentRegionHandler getDirectiveStructuredDocumentRegionHandler() {
        if (this.fDirectiveHandler == null) {
            this.fDirectiveHandler = new DirectiveStructuredDocumentRegionHandler();
        }
        return this.fDirectiveHandler;
    }

    public Hashtable getDocuments() {
        if (this.fDocuments == null) {
            this.fDocuments = new Hashtable();
        }
        return this.fDocuments;
    }

    protected Stack getIncludes() {
        if (this.fIncludes == null) {
            this.fIncludes = new Stack();
        }
        return this.fIncludes;
    }

    JSPSourceParser getParser() {
        return this.fParser;
    }

    public JSPSourceParser getSourceParser() {
        return this.fParser;
    }

    public StructuredDocumentRegionHandler getStructuredDocumentRegionHandler() {
        return this.getDirectiveStructuredDocumentRegionHandler();
    }

    public List getTaglibTrackers() {
        if (this.fTaglibTrackers == null) {
            this.fTaglibTrackers = new ArrayList();
        }
        return this.fTaglibTrackers;
    }

    void handlePreludes() {
        ZeroStructuredDocumentRegion anchor = new ZeroStructuredDocumentRegion(null, -1);
        this.fProcessIncludes = false;
        IPath currentPath = this.getCurrentParserPath();
        if (currentPath != null) {
            DeploymentDescriptorPropertyCache.PropertyGroup[] propertyGroups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(currentPath);
            int k = 0;
            while (k < propertyGroups.length) {
                IPath[] preludes = propertyGroups[k].getIncludePrelude();
                int i = 0;
                while (i < preludes.length) {
                    if (!this.getIncludes().contains(preludes[i]) && !preludes[i].equals((Object)currentPath)) {
                        this.getIncludes().push(preludes[i]);
                        if (this.getParser() != null) {
                            IncludeHelper includeHelper = new IncludeHelper(anchor, this.getParser());
                            includeHelper.parse(preludes[i]);
                            List references = includeHelper.taglibReferences;
                            this.fTLDCMReferencesMap.put(preludes[i], references);
                            int j = 0;
                            while (j < references.size()) {
                                TLDCMDocumentReference reference = (TLDCMDocumentReference)references.get(j);
                                this.getParser().addNestablePrefix(new TagMarker(String.valueOf(reference.prefix) + ":"));
                                ++j;
                            }
                        } else {
                            Logger.log(2, "Warning: parser text was requested by " + this.getClass().getName() + " but none was available; taglib support disabled");
                        }
                        this.getIncludes().pop();
                    }
                    ++i;
                }
                ++k;
            }
        }
        this.fProcessIncludes = true;
    }

    boolean hasAnyIncludeBeenModified(IPath filePath) {
        boolean result = false;
        if (this.hasBeenModified(filePath)) {
            result = true;
        } else {
            Iterator iter = this.fInclude2TimestampMap.keySet().iterator();
            while (iter.hasNext()) {
                if (!this.hasBeenModified((IPath)iter.next())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    boolean hasBeenModified(IPath filePath) {
        boolean result = false;
        IFile f = null;
        if (f == null && filePath.segmentCount() > 1) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        if (f != null && f.exists()) {
            Long currentStamp = new Long(f.getModificationStamp());
            Object o = this.fInclude2TimestampMap.get(filePath);
            if (o != null) {
                Long previousStamp = (Long)o;
                if (currentStamp.longValue() != previousStamp.longValue()) {
                    result = true;
                    this.fInclude2TimestampMap.put(filePath, currentStamp);
                }
            } else {
                result = true;
                this.fInclude2TimestampMap.put(filePath, currentStamp);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexChanged(ITaglibIndexDelta event) {
        Hashtable hashtable = TLDCMDocumentManager.getSharedDocumentCache();
        synchronized (hashtable) {
            Iterator values = TLDCMDocumentManager.getSharedDocumentCache().values().iterator();
            while (values.hasNext()) {
                Object o = values.next();
                if (!(o instanceof Reference)) continue;
                values.remove();
            }
        }
    }

    protected TLDCMDocumentDescriptor loadTaglib(String uri) {
        TLDCMDocumentDescriptor entry = null;
        IPath currentPath = this.getCurrentParserPath();
        if (currentPath != null) {
            CMDocument document = null;
            ITaglibRecord record = TaglibIndex.resolve(currentPath.toString(), uri, false);
            if (record != null) {
                document = this.getCMDocumentBuilder().createCMDocument(record);
                if (document != null) {
                    entry = new TLDCMDocumentDescriptor();
                    entry.document = document;
                    entry.cacheKey = TLDCMDocumentManager.getUniqueIdentifier(record);
                }
            } else {
                String location;
                IPath currentBaseLocation = this.getCurrentBaseLocation();
                if (currentBaseLocation != null && (location = URIResolverPlugin.createResolver().resolve(currentBaseLocation.toString(), null, uri)) != null) {
                    if (_debug) {
                        System.out.println("Loading tags from " + uri + " at " + location);
                    }
                    document = this.getCMDocumentBuilder().createCMDocument(location);
                    entry = new TLDCMDocumentDescriptor();
                    entry.document = document;
                    entry.cacheKey = location;
                }
            }
        }
        return entry;
    }

    protected void resetTaglibTrackers() {
        if (_debug) {
            System.out.println("TLDCMDocumentManager cleared its taglib trackers\n");
        }
        this.preludesHandled = false;
        this.getTaglibTrackers().clear();
    }

    public void setSourceParser(JSPSourceParser parser) {
        if (this.fParser != null) {
            this.fParser.removeStructuredDocumentRegionHandler(this.getStructuredDocumentRegionHandler());
        }
        this.fParser = parser;
        if (this.fParser != null) {
            this.fParser.addStructuredDocumentRegionHandler(this.getStructuredDocumentRegionHandler());
        }
    }

    protected class DirectiveStructuredDocumentRegionHandler
    implements StructuredDocumentRegionHandler,
    StructuredDocumentRegionHandlerExtension {
        protected DirectiveStructuredDocumentRegionHandler() {
        }

        protected void addBlockTag(String tagnameNS, IStructuredDocumentRegion marker) {
            if (TLDCMDocumentManager.this.getParser() == null) {
                return;
            }
            if (TLDCMDocumentManager.this.getParser().getBlockMarker(tagnameNS) == null) {
                TLDCMDocumentManager.this.getParser().addBlockMarker(new BlockMarker(tagnameNS, (ITextRegion)marker, "BLOCK_TEXT", true, false));
                if (_debug) {
                    System.out.println("TLDCMDocumentManager added block marker: " + tagnameNS + "@" + marker.getStartOffset());
                }
            }
        }

        protected void addTaglibTracker(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tldCMDocument) {
            TLDCMDocumentManager.this.getTaglibTrackers().add(new TaglibTracker(uri, prefix, tldCMDocument, anchorStructuredDocumentRegion));
        }

        protected void enableTaglibFromURI(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion) {
            this.enableTags(prefix, uri, anchorStructuredDocumentRegion);
            if (_debug) {
                System.out.println("TLDCMDocumentManager registered a tracker for " + uri + " with prefix " + prefix);
            }
        }

        private void enableTags(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion) {
            if (prefix == null || uri == null || bannedPrefixes.contains(prefix)) {
                return;
            }
            CMDocument tld = TLDCMDocumentManager.this.getCMDocument(uri);
            if (tld == null || !(tld instanceof TLDDocument)) {
                if (_debug) {
                    System.out.println("TLDCMDocumentManager failed to create a CMDocument for " + uri);
                }
                return;
            }
            this.registerTaglib(prefix, uri, anchorStructuredDocumentRegion, tld);
        }

        protected void enableTagsInDir(String prefix, String tagdir, IStructuredDocumentRegion anchorStructuredDocumentRegion) {
            this.enableTags(prefix, tagdir, anchorStructuredDocumentRegion);
            if (_debug) {
                System.out.println("TLDCMDocumentManager registered a tracker for directory" + tagdir + " with prefix " + prefix);
            }
        }

        public void nodeParsed(IStructuredDocumentRegion aCoreStructuredDocumentRegion) {
            if (!TLDCMDocumentManager.this.preludesHandled) {
                TLDCMDocumentManager.this.handlePreludes();
                TLDCMDocumentManager.this.preludesHandled = true;
            }
            if (aCoreStructuredDocumentRegion.getNumberOfRegions() > 4 && aCoreStructuredDocumentRegion.getRegions().get(1).getType() == "JSP_DIRECTIVE_NAME") {
                ITextRegion name = aCoreStructuredDocumentRegion.getRegions().get(1);
                try {
                    if (TLDCMDocumentManager.this.getParser() == null) {
                        Logger.log(2, "Warning: parser text was requested by " + this.getClass().getName() + " but none was available; taglib support disabled");
                    } else {
                        boolean taglibDetected = false;
                        boolean taglibDirectiveDetected = false;
                        boolean includeDetected = false;
                        boolean includeDirectiveDetected = false;
                        int startOffset = aCoreStructuredDocumentRegion.getStartOffset(name);
                        int textLength = name.getTextLength();
                        if (TLDCMDocumentManager.this.getParser() != null) {
                            taglibDetected = TLDCMDocumentManager.this.getParser().regionMatches(startOffset, textLength, "taglib");
                            taglibDirectiveDetected = TLDCMDocumentManager.this.getParser().regionMatches(startOffset, textLength, "jsp:directive.taglib");
                            includeDetected = TLDCMDocumentManager.this.getParser().regionMatches(startOffset, textLength, "include");
                            includeDirectiveDetected = TLDCMDocumentManager.this.getParser().regionMatches(startOffset, textLength, "jsp:directive.include");
                        } else {
                            String directiveName = TLDCMDocumentManager.this.getParser().getText(startOffset, textLength);
                            taglibDetected = directiveName.equals("taglib");
                            taglibDirectiveDetected = directiveName.equals("jsp:directive.taglib");
                            includeDetected = directiveName.equals("include");
                            includeDirectiveDetected = directiveName.equals("jsp:directive.include");
                        }
                        if (taglibDetected || taglibDirectiveDetected) {
                            this.processTaglib(aCoreStructuredDocumentRegion);
                        } else if (includeDetected || includeDirectiveDetected) {
                            this.processInclude(aCoreStructuredDocumentRegion);
                        }
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            } else if (aCoreStructuredDocumentRegion.getNumberOfRegions() > 4 && aCoreStructuredDocumentRegion.getRegions().get(1).getType() == "JSP_ROOT_TAG_NAME") {
                if (TLDCMDocumentManager.this.getParser() == null) {
                    Logger.log(2, "Warning: parser text was requested by " + this.getClass().getName() + " but none was available; taglib support disabled");
                } else {
                    this.processJSPRoot(aCoreStructuredDocumentRegion);
                }
            }
        }

        protected void processInclude(IStructuredDocumentRegion aCoreStructuredDocumentRegion) {
            this.processInclude(aCoreStructuredDocumentRegion, aCoreStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
        }

        protected void processInclude(IStructuredDocumentRegion includeStructuredDocumentRegion, IStructuredDocumentRegion anchorStructuredDocumentRegion, JSPSourceParser textSource) {
            ITextRegionList regions = includeStructuredDocumentRegion.getRegions();
            String includedFile = null;
            boolean isFilename = false;
            try {
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        isFilename = textSource.getText(includeStructuredDocumentRegion.getStartOffset(region), region.getTextLength()).equals("file");
                    } else if (isFilename && region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        includedFile = textSource.getText(includeStructuredDocumentRegion.getStartOffset(region), region.getTextLength());
                        isFilename = false;
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                includedFile = null;
            }
            if (TLDCMDocumentManager.this.fProcessIncludes && includedFile != null) {
                includedFile = StringUtils.strip(includedFile).trim();
                IPath filePath = null;
                filePath = TLDCMDocumentManager.this.getIncludes().isEmpty() ? FacetModuleCoreSupport.resolve(TaglibController.getFileBuffer(TLDCMDocumentManager.this).getLocation(), includedFile) : FacetModuleCoreSupport.resolve((IPath)TLDCMDocumentManager.this.getIncludes().peek(), includedFile);
                if (filePath != null && !TLDCMDocumentManager.this.getIncludes().contains(filePath) && !filePath.equals((Object)TaglibController.getFileBuffer(TLDCMDocumentManager.this).getLocation())) {
                    if (TLDCMDocumentManager.this.hasAnyIncludeBeenModified(filePath)) {
                        TLDCMDocumentManager.this.getIncludes().push(filePath);
                        if (TLDCMDocumentManager.this.getParser() != null) {
                            IncludeHelper includeHelper = new IncludeHelper(anchorStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
                            includeHelper.parse(filePath);
                            List references = includeHelper.taglibReferences;
                            TLDCMDocumentManager.this.fTLDCMReferencesMap.put(filePath, references);
                        } else {
                            Logger.log(2, "Warning: parser text was requested by " + this.getClass().getName() + " but none was available; taglib support disabled");
                        }
                        TLDCMDocumentManager.this.getIncludes().pop();
                    } else {
                        List references = (List)TLDCMDocumentManager.this.fTLDCMReferencesMap.get(filePath);
                        int i = 0;
                        while (references != null && i < references.size()) {
                            TLDCMDocumentReference reference = (TLDCMDocumentReference)references.get(i);
                            this.enableTaglibFromURI(reference.prefix, reference.uri, includeStructuredDocumentRegion);
                            TLDCMDocumentManager.this.getParser().addNestablePrefix(new TagMarker(String.valueOf(reference.prefix) + ":"));
                            ++i;
                        }
                    }
                }
            }
        }

        protected void processJSPRoot(IStructuredDocumentRegion jspRootStructuredDocumentRegion) {
            this.processJSPRoot(jspRootStructuredDocumentRegion, jspRootStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
        }

        protected void processJSPRoot(IStructuredDocumentRegion taglibStructuredDocumentRegion, IStructuredDocumentRegion anchorStructuredDocumentRegion, JSPSourceParser textSource) {
            ITextRegionList regions = taglibStructuredDocumentRegion.getRegions();
            String uri = null;
            String prefix = null;
            boolean taglib = false;
            try {
                int i = 2;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        String name = textSource.getText(taglibStructuredDocumentRegion.getStartOffset(region), region.getTextLength());
                        if (name.startsWith(TLDCMDocumentManager.this.XMLNS)) {
                            prefix = name.substring(TLDCMDocumentManager.this.XMLNS_LENGTH);
                            if (!bannedPrefixes.contains(prefix)) {
                                taglib = true;
                            }
                        } else {
                            prefix = null;
                            taglib = false;
                        }
                    } else if (taglib && region.getType() == "XML_TAG_ATTRIBUTE_VALUE" && prefix != null && prefix.length() > 0) {
                        uri = textSource.getText(taglibStructuredDocumentRegion.getStartOffset(region), region.getTextLength());
                        if ((uri = StringUtils.strip((String)uri)) != null && uri.length() > 0) {
                            if (uri.startsWith(TLDCMDocumentManager.this.URN_TLD)) {
                                uri = uri.substring(TLDCMDocumentManager.this.URN_TLD.length());
                            } else if (uri.startsWith(TLDCMDocumentManager.this.URN_TAGDIR)) {
                                uri = uri.substring(TLDCMDocumentManager.this.URN_TAGDIR.length());
                            }
                            if (anchorStructuredDocumentRegion == null) {
                                this.enableTags(prefix, uri, taglibStructuredDocumentRegion);
                            } else {
                                this.enableTags(prefix, uri, anchorStructuredDocumentRegion);
                            }
                            uri = null;
                            prefix = null;
                        }
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                uri = null;
                prefix = null;
            }
        }

        protected void processTaglib(IStructuredDocumentRegion taglibStructuredDocumentRegion) {
            this.processTaglib(taglibStructuredDocumentRegion, taglibStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
        }

        protected void processTaglib(IStructuredDocumentRegion taglibStructuredDocumentRegion, IStructuredDocumentRegion anchorStructuredDocumentRegion, JSPSourceParser textSource) {
            ITextRegionList regions = taglibStructuredDocumentRegion.getRegions();
            String uri = null;
            String prefix = null;
            String tagdir = null;
            String attrName = null;
            try {
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    int startOffset = taglibStructuredDocumentRegion.getStartOffset(region);
                    int textLength = region.getTextLength();
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        attrName = textSource.regionMatches(startOffset, textLength, "prefix") ? "prefix" : (textSource.regionMatches(startOffset, textLength, "uri") ? "uri" : (textSource.regionMatches(startOffset, textLength, "tagdir") ? "tagdir" : null));
                    } else if (region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        if ("prefix".equals(attrName)) {
                            prefix = StringUtils.strip((String)textSource.getText(startOffset, textLength));
                        } else if ("uri".equals(attrName)) {
                            uri = StringUtils.strip((String)textSource.getText(startOffset, textLength));
                        } else if ("tagdir".equals(attrName)) {
                            tagdir = StringUtils.strip((String)textSource.getText(startOffset, textLength));
                        }
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                uri = null;
                prefix = null;
            }
            if (uri != null && prefix != null && uri.length() > 0 && prefix.length() > 0) {
                if (anchorStructuredDocumentRegion == null) {
                    this.enableTaglibFromURI(prefix, StringUtils.strip((String)uri), taglibStructuredDocumentRegion);
                } else {
                    this.enableTaglibFromURI(prefix, uri, anchorStructuredDocumentRegion);
                }
            } else if (tagdir != null && prefix != null && tagdir.length() > 0 && prefix.length() > 0) {
                if (anchorStructuredDocumentRegion == null) {
                    this.enableTagsInDir(StringUtils.strip((String)prefix), StringUtils.strip((String)tagdir), taglibStructuredDocumentRegion);
                } else {
                    this.enableTagsInDir(StringUtils.strip((String)prefix), StringUtils.strip((String)tagdir), anchorStructuredDocumentRegion);
                }
            }
        }

        private void registerTaglib(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tld) {
            CMNamedNodeMap elements = tld.getElements();
            int i = 0;
            while (i < elements.getLength()) {
                TLDElementDeclaration ed = (TLDElementDeclaration)elements.item(i);
                if (ed.getBodycontent() == "tagdependent") {
                    this.addBlockTag(String.valueOf(prefix) + ":" + ed.getNodeName(), anchorStructuredDocumentRegion);
                }
                ++i;
            }
            boolean doTrack = true;
            List trackers = TLDCMDocumentManager.this.getTaglibTrackers();
            int i2 = 0;
            while (i2 < trackers.size()) {
                TaglibTracker tracker = (TaglibTracker)trackers.get(i2);
                if (tracker.getPrefix().equals(prefix) && tracker.getURI().equals(uri)) {
                    doTrack = false;
                }
                ++i2;
            }
            if (doTrack) {
                this.addTaglibTracker(prefix, uri, anchorStructuredDocumentRegion, tld);
            }
        }

        private void resetBlockTags() {
            if (TLDCMDocumentManager.this.getParser() == null) {
                return;
            }
            Iterator names = TLDCMDocumentManager.this.getParser().getBlockMarkers().iterator();
            while (names.hasNext()) {
                BlockMarker marker = (BlockMarker)names.next();
                if (marker.isGlobal() || marker.getContext() != "BLOCK_TEXT") continue;
                if (_debug) {
                    System.out.println("TLDCMDocumentManager removing block tag named: " + marker.getTagName());
                }
                names.remove();
            }
        }

        public void resetNodes() {
            TLDCMDocumentManager.this.getIncludes().clear();
            this.resetBlockTags();
            TLDCMDocumentManager.this.resetTaglibTrackers();
        }

        public void setStructuredDocument(IStructuredDocument newDocument) {
            Assert.isTrue((newDocument != null ? 1 : 0) != 0, (String)"null document");
            Assert.isTrue((newDocument.getParser() != null ? 1 : 0) != 0, (String)"null document parser");
            Assert.isTrue((boolean)(newDocument.getParser() instanceof JSPSourceParser), (String)"can only listen to document with a JSPSourceParser");
            TLDCMDocumentManager.this.getSourceParser().removeStructuredDocumentRegionHandler(this);
            TLDCMDocumentManager.this.setSourceParser((JSPSourceParser)newDocument.getParser());
            TLDCMDocumentManager.this.getSourceParser().addStructuredDocumentRegionHandler(this);
        }
    }

    protected class IncludeHelper
    extends DirectiveStructuredDocumentRegionHandler {
        protected IStructuredDocumentRegion fAnchor = null;
        protected JSPSourceParser fLocalParser = null;
        protected JSPSourceParser fParentParser = null;
        List taglibReferences = null;

        public IncludeHelper(IStructuredDocumentRegion anchor, JSPSourceParser rootParser) {
            this.fAnchor = anchor;
            this.fParentParser = rootParser;
            this.taglibReferences = new ArrayList(0);
        }

        protected void addTaglibTracker(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tldCMDocument) {
            super.addTaglibTracker(prefix, uri, anchorStructuredDocumentRegion, tldCMDocument);
            TLDCMDocumentReference reference = new TLDCMDocumentReference();
            reference.prefix = prefix;
            reference.uri = uri;
            this.taglibReferences.add(reference);
        }

        protected String getContents(IPath filePath) {
            return FileContentCache.getInstance().getContents(filePath);
        }

        public void nodeParsed(IStructuredDocumentRegion aCoreStructuredDocumentRegion) {
            if (aCoreStructuredDocumentRegion.getNumberOfRegions() > 1 && aCoreStructuredDocumentRegion.getRegions().get(1).getType() == "JSP_DIRECTIVE_NAME") {
                ITextRegion name = aCoreStructuredDocumentRegion.getRegions().get(1);
                try {
                    String directiveName = this.fLocalParser.getText(aCoreStructuredDocumentRegion.getStartOffset(name), name.getTextLength());
                    if (directiveName.equals("taglib") || directiveName.equals("jsp:directive.taglib")) {
                        this.processTaglib(aCoreStructuredDocumentRegion, this.fAnchor, this.fLocalParser);
                    }
                    if (directiveName.equals("include") || directiveName.equals("jsp:directive.include")) {
                        this.processInclude(aCoreStructuredDocumentRegion, this.fAnchor, this.fLocalParser);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            } else if (aCoreStructuredDocumentRegion.getNumberOfRegions() > 4 && aCoreStructuredDocumentRegion.getRegions().get(1).getType() == "JSP_ROOT_TAG_NAME") {
                this.processJSPRoot(aCoreStructuredDocumentRegion, this.fAnchor, this.fLocalParser);
            }
        }

        void parse(IPath path) {
            JSPSourceParser p;
            this.fLocalParser = p = new JSPSourceParser();
            List blockTags = this.fParentParser.getBlockMarkers();
            String s = this.getContents(path);
            this.fLocalParser.addStructuredDocumentRegionHandler(this);
            this.fLocalParser.reset(s);
            int i = 0;
            while (i < blockTags.size()) {
                BlockMarker marker = (BlockMarker)blockTags.get(i);
                this.fLocalParser.addBlockMarker(new BlockMarker(marker.getTagName(), null, marker.getContext(), marker.isCaseSensitive()));
                ++i;
            }
            this.fLocalParser.getDocumentRegions();
            this.fLocalParser = null;
        }

        public void resetNodes() {
        }
    }

    private static class TLDCMDocumentDescriptor {
        Object cacheKey;
        CMDocument document;

        TLDCMDocumentDescriptor() {
        }
    }

    private class TLDCMDocumentReference {
        String prefix;
        String uri;

        private TLDCMDocumentReference() {
        }
    }

    static class TLDCacheEntry {
        CMDocument document;
        long modificationStamp;
        int referenceCount;

        TLDCacheEntry() {
        }
    }
}

