/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.java.EscapedTextUtil;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.internal.util.FileContentCache;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.TagMarker;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

class XMLJSPRegionHelper
implements StructuredDocumentRegionHandler {
    private final JSPTranslator fTranslator;
    protected JSPSourceParser fLocalParser = null;
    protected String fTextToParse = null;
    protected int fStartOfTextToParse = 0;
    protected String fTagname = null;
    protected String fTextBefore = "";
    protected String fUnescapedText = "";
    protected String fStrippedText = "";
    int fPossibleOwner = 8;

    public XMLJSPRegionHelper(JSPTranslator translator) {
        this.getLocalParser().addStructuredDocumentRegionHandler(this);
        this.fTranslator = translator;
    }

    protected JSPSourceParser getLocalParser() {
        if (this.fLocalParser == null) {
            this.fLocalParser = new JSPSourceParser();
        }
        return this.fLocalParser;
    }

    public void addBlockMarker(BlockMarker marker) {
        this.fLocalParser.addBlockMarker(marker);
    }

    public void reset(String textToParse) {
        this.reset(textToParse, 0);
    }

    public void reset(String textToParse, int start) {
        this.fStartOfTextToParse = start;
        this.getLocalParser().reset(textToParse);
        this.fTextToParse = textToParse;
    }

    public void forceParse() {
        this.getLocalParser().getDocumentRegions();
        this.fLocalParser = null;
    }

    public boolean parse(String filePath) {
        this.getLocalParser().removeStructuredDocumentRegionHandler(this);
        List blockMarkers = this.fTranslator.getBlockMarkers();
        IStructuredDocument document = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)this.getLocalParser());
        String contents = this.getContents(filePath);
        if (contents == null) {
            return false;
        }
        int i = 0;
        while (i < blockMarkers.size()) {
            this.addBlockMarker((BlockMarker)blockMarkers.get(i));
            ++i;
        }
        this.reset(contents);
        document.set(contents);
        IStructuredDocumentRegion cursor = document.getFirstStructuredDocumentRegion();
        while (cursor != null) {
            this.nodeParsed(cursor);
            cursor = cursor.getNext();
        }
        this.getLocalParser().addStructuredDocumentRegionHandler(this);
        return true;
    }

    public void nodeParsed(IStructuredDocumentRegion sdRegion) {
        try {
            this.handleScopingIfNecessary(sdRegion);
            if (this.isJSPEndRegion(sdRegion)) {
                String nameStr = this.getRegionName(sdRegion);
                if (this.isPossibleCustomTag(nameStr)) {
                    this.fTranslator.addTaglibVariables(nameStr, sdRegion);
                }
                this.fTagname = null;
            } else if (this.isJSPStartRegion(sdRegion)) {
                String nameStr = this.getRegionName(sdRegion);
                if (sdRegion.getFirstRegion().getType() == "XML_TAG_OPEN" && this.isPossibleCustomTag(nameStr)) {
                    this.fTranslator.addTaglibVariables(nameStr, sdRegion);
                }
                this.fTagname = this.isJSPRegion(nameStr) ? nameStr : null;
                if (this.fTagname != null && sdRegion.getFirstRegion().getType() == "JSP_DIRECTIVE_OPEN") {
                    this.processOtherRegions(sdRegion);
                }
                if (this.fTagname != null && this.fTagname.equals("jsp:useBean")) {
                    this.processUseBean(sdRegion);
                }
            } else if (sdRegion.getFirstRegion().getType() == "JSP_CONTENT" || sdRegion.getFirstRegion().getType() == "XML_CONTENT") {
                if (this.fTagname != null) {
                    if (this.isScriptlet(this.fTagname)) {
                        this.processScriptlet(sdRegion);
                    } else if (this.isExpression(this.fTagname)) {
                        this.processExpression(sdRegion);
                    } else if (this.isDeclaration(this.fTagname)) {
                        this.processDeclaration(sdRegion);
                    }
                }
            } else {
                this.fTagname = null;
            }
            this.checkCursorInRegion(sdRegion);
        }
        catch (NullPointerException e) {
            try {
                Logger.logException("XMLJSPRegionHelper: exception in node parsing", e);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }

    private void handleScopingIfNecessary(IStructuredDocumentRegion sdRegion) {
        String nameStr;
        if (sdRegion.getFirstRegion().getType() == "XML_TAG_OPEN") {
            String nameStr2;
            if (!this.isSelfClosingTag((ITextRegionCollection)sdRegion) && this.isPossibleCustomTag(nameStr2 = this.getRegionName(sdRegion))) {
                this.startScope(nameStr2);
            }
        } else if (sdRegion.getFirstRegion().getType() == "XML_END_TAG_OPEN" && this.isPossibleCustomTag(nameStr = this.getRegionName(sdRegion))) {
            this.endScope(nameStr);
        }
    }

    private boolean isSelfClosingTag(ITextRegionCollection containerRegion) {
        if (containerRegion == null) {
            return false;
        }
        ITextRegionList regions = containerRegion.getRegions();
        ITextRegion r = regions.get(regions.size() - 1);
        return r.getType() == "XML_EMPTY_TAG_CLOSE";
    }

    private void startScope(String tagName) {
        IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
        StringBuffer text = new StringBuffer();
        text.append("{ // <");
        text.append(tagName);
        text.append(">\n");
        this.fTranslator.translateScriptletString(text.toString(), (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength());
    }

    private void endScope(String tagName) {
        IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
        StringBuffer text = new StringBuffer();
        text.append("} // </");
        text.append(tagName);
        text.append(">\n");
        this.fTranslator.translateScriptletString(text.toString(), (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength());
    }

    public void resetNodes() {
    }

    private void checkCursorInRegion(IStructuredDocumentRegion sdRegion) {
        if (this.fTranslator.getSourcePosition() >= this.fStartOfTextToParse + sdRegion.getStartOffset() && this.fTranslator.getSourcePosition() <= this.fStartOfTextToParse + sdRegion.getEndOffset()) {
            int endOfNameTag = sdRegion.getStartOffset();
            int offset = this.fTextBefore.length() - this.fStrippedText.length();
            this.fTranslator.setRelativeOffset(this.fTranslator.getSourcePosition() - (this.fStartOfTextToParse + endOfNameTag) - offset);
            this.fTranslator.setCursorOwner(this.fPossibleOwner);
            this.fTranslator.setRelativeOffset(this.fTranslator.getRelativeOffset() + this.fTranslator.getCursorOwner().length());
            if (this.fPossibleOwner == 4) {
                this.fTranslator.setRelativeOffset(this.fTranslator.getRelativeOffset() + "out.print(\"\"+".length());
            }
        }
    }

    protected void processDeclaration(IStructuredDocumentRegion sdRegion) {
        this.prepareText(sdRegion);
        IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
        this.fTranslator.translateDeclarationString(this.fStrippedText, (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength());
        this.fPossibleOwner = 2;
    }

    protected void processExpression(IStructuredDocumentRegion sdRegion) {
        this.prepareText(sdRegion);
        IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
        this.fTranslator.translateExpressionString(this.fStrippedText, (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength());
        this.fPossibleOwner = 4;
    }

    protected void processScriptlet(IStructuredDocumentRegion sdRegion) {
        this.prepareText(sdRegion);
        IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
        this.fTranslator.translateScriptletString(this.fStrippedText, (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength());
        this.fPossibleOwner = 8;
    }

    protected void prepareText(IStructuredDocumentRegion sdRegion) {
        this.fTextBefore = this.fTextToParse.substring(sdRegion.getStartOffset(), sdRegion.getEndOffset());
        this.fUnescapedText = EscapedTextUtil.getUnescapedText(this.fTextBefore);
        this.fStrippedText = this.fTranslator.stripCDATA(this.fUnescapedText);
    }

    protected void processUseBean(IStructuredDocumentRegion sdRegion) {
        if (this.fTagname != null && this.isUseBean(this.fTagname)) {
            String beanDecl = "";
            String beanClass = this.getAttributeValue("class", sdRegion);
            String beanType = this.getAttributeValue("type", sdRegion);
            String beanId = this.getAttributeValue("id", sdRegion);
            if (beanId != null && (beanType != null || beanClass != null)) {
                String prefix = null;
                prefix = beanType.length() != 0 ? String.valueOf(beanType) + " " + beanId + " = " : String.valueOf(beanClass) + " " + beanId + " = ";
                String suffix = "null;\n";
                if (beanClass.length() > 0) {
                    suffix = "new " + beanClass + "();\n";
                }
                beanDecl = String.valueOf(prefix) + suffix;
            }
            IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
            this.fTranslator.translateScriptletString(beanDecl, (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength());
            this.fPossibleOwner = 8;
        }
    }

    protected void processOtherRegions(IStructuredDocumentRegion sdRegion) {
        this.processIncludeDirective(sdRegion);
        this.processPageDirective(sdRegion);
    }

    protected void processIncludeDirective(IStructuredDocumentRegion sdRegion) {
        if (this.isIncludeDirective(this.fTagname)) {
            if (sdRegion.getRegions().get(0).getType() == "XML_CONTENT") {
                sdRegion = sdRegion.getPrevious();
            }
            String fileLocation = this.getAttributeValue("file", sdRegion);
            this.fTranslator.handleIncludeFile(fileLocation);
        } else if (this.isPossibleCustomTag(this.fTagname)) {
            this.fTranslator.addTaglibVariables(this.fTagname);
        } else if (this.isTaglibDirective(this.fTagname)) {
            String prefix = this.getAttributeValue("prefix", sdRegion);
            TLDCMDocumentManager documentManager = this.fTranslator.getTLDCMDocumentManager();
            if (documentManager != null) {
                List docs = documentManager.getCMDocumentTrackers(prefix, this.fTranslator.getCurrentNode().getStartOffset());
                Iterator it = docs.iterator();
                Iterator elements = null;
                CMNode node = null;
                CMDocument doc = null;
                BlockMarker marker = null;
                while (it.hasNext()) {
                    doc = (CMDocument)it.next();
                    elements = doc.getElements().iterator();
                    while (elements.hasNext()) {
                        node = (CMNode)elements.next();
                        marker = new BlockMarker(node.getNodeName(), null, "JSP_CONTENT", true);
                        this.addBlockMarker(marker);
                        this.fTranslator.getBlockMarkers().add(marker);
                    }
                }
            }
        }
    }

    protected void processPageDirective(IStructuredDocumentRegion sdRegion) {
        if (this.isPageDirective(this.fTagname)) {
            this.fTranslator.translatePageDirectiveAttributes(sdRegion.getRegions().iterator(), sdRegion);
        }
    }

    protected String getAttributeValue(String attrName, IStructuredDocumentRegion sdRegion) {
        String sdRegionText = this.fTextToParse.substring(sdRegion.getStartOffset(), sdRegion.getEndOffset());
        String attrValue = "";
        Iterator it = sdRegion.getRegions().iterator();
        ITextRegion valueRegion = null;
        block0: while (it.hasNext()) {
            String textRegionText;
            ITextRegion nameRegion = (ITextRegion)it.next();
            if (nameRegion.getType() != "XML_TAG_ATTRIBUTE_NAME" || !(textRegionText = sdRegionText.substring(nameRegion.getStart(), nameRegion.getTextEnd())).equalsIgnoreCase(attrName)) continue;
            while (it.hasNext()) {
                valueRegion = (ITextRegion)it.next();
                if (valueRegion.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
                attrValue = sdRegionText.substring(valueRegion.getStart(), valueRegion.getEnd());
                break block0;
            }
            break block0;
        }
        return StringUtils.stripQuotes((String)attrValue);
    }

    protected boolean isJSPStartRegion(IStructuredDocumentRegion sdRegion) {
        return sdRegion.getFirstRegion().getType() == "XML_TAG_OPEN" || sdRegion.getFirstRegion().getType() == "JSP_DIRECTIVE_OPEN";
    }

    private boolean isJSPEndRegion(IStructuredDocumentRegion sdRegion) {
        return sdRegion.getFirstRegion().getType() == "XML_END_TAG_OPEN";
    }

    protected boolean isJSPRegion(String tagName) {
        return this.isDeclaration(tagName) || this.isExpression(tagName) || this.isScriptlet(tagName) || this.isUseBean(tagName) || this.isIncludeDirective(tagName) || this.isPossibleCustomTag(tagName) || this.isTaglibDirective(tagName) || this.isPageDirective(tagName);
    }

    protected boolean isDeclaration(String tagName) {
        return tagName.equalsIgnoreCase("jsp:declaration");
    }

    protected boolean isExpression(String tagName) {
        return tagName.equalsIgnoreCase("jsp:expression");
    }

    protected boolean isScriptlet(String tagName) {
        return tagName.equalsIgnoreCase("jsp:scriptlet");
    }

    protected boolean isUseBean(String tagName) {
        return tagName.equalsIgnoreCase("jsp:useBean");
    }

    protected boolean isIncludeDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.include");
    }

    protected boolean isPossibleCustomTag(String tagName) {
        int colonIndex = tagName.indexOf(":");
        if (colonIndex > 0) {
            String prefix = tagName.substring(0, colonIndex);
            if (prefix.equals("jsp")) {
                return false;
            }
            if (prefix.length() > 0) {
                TagMarker[] prefixes = this.fLocalParser.getNestablePrefixes().toArray(new TagMarker[0]);
                int i = 0;
                while (i < prefixes.length) {
                    if (prefix.equals(prefixes[i].getTagName())) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected boolean isTaglibDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.taglib");
    }

    protected boolean isPageDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.page");
    }

    protected String getRegionName(IStructuredDocumentRegion sdRegion) {
        String nameStr = "";
        ITextRegionList regions = sdRegion.getRegions();
        int i = 0;
        while (i < regions.size()) {
            ITextRegion r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME") {
                nameStr = this.fTextToParse.substring(sdRegion.getStartOffset(r), sdRegion.getTextEndOffset(r));
                break;
            }
            ++i;
        }
        return nameStr.trim();
    }

    protected String getContents(String filePath) {
        Path path = new Path(filePath);
        return FileContentCache.getInstance().getContents(path.makeAbsolute());
    }
}

