/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.modelhandler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapterFactory;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveWatcherFactory;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.jst.jsp.core.internal.encoding.IJSPHeadContentDetector;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentHeadContentDetector;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentLoader;
import org.eclipse.jst.jsp.core.internal.modelhandler.EmbeddedTypeStateData;
import org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryAdapterImpl;
import org.eclipse.jst.jsp.core.internal.modelquery.ModelQueryAdapterFactoryForJSP;
import org.eclipse.jst.jsp.core.internal.parser.JSPReParser;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.IContentDescriptionForJSP;
import org.eclipse.jst.jsp.core.internal.text.StructuredTextPartitionerForJSP;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeFamilyForHTML;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.JSPCapableParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.model.AbstractModelLoader;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistry;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistryImpl;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.internal.util.DocumentInputStream;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.propagate.PropagatingAdapterFactoryImpl;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

public class JSPModelLoader
extends AbstractModelLoader {
    protected final int MAX_BUFFERED_SIZE_FOR_RESET_MARK = 200000;
    private EmbeddedTypeRegistry embeddedContentTypeRegistry;
    private static final String DEFAULT_MIME_TYPE = "text/html";
    private static final String DEFAULT_LANGUAGE = "java";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private EmbeddedTypeRegistry getEmbeddedContentTypeRegistry() {
        if (this.embeddedContentTypeRegistry == null) {
            this.embeddedContentTypeRegistry = EmbeddedTypeRegistryImpl.getInstance();
        }
        return this.embeddedContentTypeRegistry;
    }

    public IStructuredModel newModel() {
        DOMModelForJSP model = new DOMModelForJSP();
        return model;
    }

    private EmbeddedTypeHandler getJSPDefaultEmbeddedType(IStructuredModel model) {
        IFile file;
        EmbeddedTypeRegistry reg = this.getEmbeddedContentTypeRegistry();
        String mimeType = null;
        if (model != null && (file = this.getFile(model)) != null) {
            mimeType = JSPFContentProperties.getProperty("jsp-content-type", (IResource)file, true);
        }
        mimeType = mimeType == null ? this.getDefaultMimeType() : mimeType;
        return reg.getTypeFor(mimeType);
    }

    private String getDefaultMimeType() {
        return DEFAULT_MIME_TYPE;
    }

    public IStructuredDocument newStructuredDocument() {
        IStructuredDocument structuredDocument = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)this.getParser());
        ((BasicStructuredDocument)structuredDocument).setReParser((IStructuredTextReParser)new JSPReParser());
        EmbeddedTypeHandler embeddedType = this.getJSPDefaultEmbeddedType(null);
        embeddedType.initializeParser((JSPCapableParser)structuredDocument.getParser());
        return structuredDocument;
    }

    public RegionParser getParser() {
        return new JSPSourceParser();
    }

    protected void preLoadAdapt(IStructuredModel structuredModel) {
        super.preLoadAdapt(structuredModel);
        IDOMModel domModel = (IDOMModel)structuredModel;
        IDOMDocument document = domModel.getDocument();
        Assert.isNotNull((Object)document);
        INodeNotifier iNodeNotifier = (INodeNotifier)document;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.internal.PropagatingAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)iNodeNotifier.getAdapterFor((Object)clazz);
        propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)new PageDirectiveWatcherFactory());
        INodeNotifier iNodeNotifier2 = (INodeNotifier)document;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iNodeNotifier2.getAdapterFor((Object)clazz2);
    }

    public List getAdapterFactories() {
        ArrayList<AbstractAdapterFactory> result = new ArrayList<AbstractAdapterFactory>();
        AbstractAdapterFactory factory = null;
        factory = new ModelQueryAdapterFactoryForJSP();
        result.add(factory);
        factory = new PropagatingAdapterFactoryImpl();
        result.add(factory);
        factory = new PageDirectiveAdapterFactory();
        result.add(factory);
        return result;
    }

    public IJSPHeadContentDetector getHeadParser() {
        return new JSPDocumentHeadContentDetector();
    }

    private IContentDescription getContentDescription(IDocument doc) {
        if (doc == null) {
            return null;
        }
        DocumentInputStream in = new DocumentInputStream(doc);
        return this.getContentDescription((InputStream)in);
    }

    private IContentDescription getContentDescription(String filePath) {
        if (filePath == null) {
            return null;
        }
        IDocument doc = null;
        ITextFileBuffer buf = FileBuffers.getTextFileBufferManager().getTextFileBuffer((IPath)new Path(filePath));
        if (buf != null) {
            doc = buf.getDocument();
        }
        IContentDescription contentDescription = null;
        if (doc != null) {
            contentDescription = this.getContentDescription(doc);
        }
        return contentDescription;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IContentDescription getContentDescription(InputStream in) {
        if (in == null) {
            return null;
        }
        IContentDescription desc = null;
        try {
            try {
                IContentType contentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
                desc = contentTypeJSP.getDescriptionFor(in, IContentDescription.ALL);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                Logger.logException(e);
            }
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (IOException e) {
            Logger.logException(e);
            return desc;
        }
        in.close();
        return desc;
    }

    private IFile getFile(IStructuredModel model) {
        Path path;
        String location;
        if (model != null && (location = model.getBaseLocation()) != null && !(path = new Path(location)).toFile().exists() && path.segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    private String getLanguage(IStructuredModel model) {
        String result = null;
        result = this.getLanguageFromStructuredDocument(model.getStructuredDocument());
        IFile file = this.getFile(model);
        result = JSPFContentProperties.getProperty("jsp-language", (IResource)file, true);
        if (result == null) {
            result = DEFAULT_LANGUAGE;
        }
        return result;
    }

    private String getLanguageFromStructuredDocument(IStructuredDocument structuredDocument) {
        if (structuredDocument == null) {
            return null;
        }
        String result = null;
        IJSPHeadContentDetector localHeadParser = this.getHeadParser();
        localHeadParser.set((IDocument)structuredDocument);
        try {
            result = localHeadParser.getLanguage();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return result;
    }

    private void reInitializeEmbeddedType(IStructuredModel model, EmbeddedTypeHandler oldEmbeddedContentType, EmbeddedTypeHandler newEmbeddedContentType) {
        String language;
        Assert.isNotNull((Object)oldEmbeddedContentType, (String)"Program error: invalid call during model initialization");
        IDOMModel domModel = (IDOMModel)model;
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        IDOMDocument document = domModel.getDocument();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)document.getExistingAdapter((Object)clazz);
        oldEmbeddedContentType.uninitializeFactoryRegistry(model.getFactoryRegistry());
        oldEmbeddedContentType.uninitializeParser((JSPCapableParser)structuredDocument.getParser());
        pageDirectiveAdapter.setEmbeddedType(newEmbeddedContentType);
        if (newEmbeddedContentType != null) {
            ((DOMModelImpl)model).setModelParser(null);
            newEmbeddedContentType.initializeFactoryRegistry(model.getFactoryRegistry());
            newEmbeddedContentType.initializeParser((JSPCapableParser)structuredDocument.getParser());
            IDocumentPartitioner documentPartitioner = structuredDocument.getDocumentPartitioner();
            if (documentPartitioner != null && documentPartitioner instanceof StructuredTextPartitionerForJSP) {
                if (newEmbeddedContentType.getFamilyId().equals(ContentTypeIdForXML.ContentTypeID_XML)) {
                    ((StructuredTextPartitionerForJSP)documentPartitioner).setEmbeddedPartitioner((IStructuredTextPartitioner)new StructuredTextPartitionerForXML());
                } else if (newEmbeddedContentType.getFamilyId().equals(ContentTypeIdForHTML.ContentTypeID_HTML)) {
                    ((StructuredTextPartitionerForJSP)documentPartitioner).setEmbeddedPartitioner((IStructuredTextPartitioner)new StructuredTextPartitionerForHTML());
                }
            }
        }
        if ((language = this.getLanguage(model)) != null && language.length() > 0) {
            pageDirectiveAdapter.setLanguage(language);
        }
    }

    private void initCloneOfEmbeddedType(IStructuredModel model, EmbeddedTypeHandler oldEmbeddedContentType, EmbeddedTypeHandler newEmbeddedContentType) {
        String language;
        Assert.isNotNull((Object)oldEmbeddedContentType, (String)"Program error: invalid call during model initialization");
        IDOMModel domModel = (IDOMModel)model;
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        IDOMDocument document = domModel.getDocument();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)document.getAdapterFor((Object)clazz);
        oldEmbeddedContentType.uninitializeFactoryRegistry(model.getFactoryRegistry());
        oldEmbeddedContentType.uninitializeParser((JSPCapableParser)structuredDocument.getParser());
        pageDirectiveAdapter.setEmbeddedType(newEmbeddedContentType);
        if (newEmbeddedContentType != null) {
            newEmbeddedContentType.initializeFactoryRegistry(model.getFactoryRegistry());
            newEmbeddedContentType.initializeParser((JSPCapableParser)structuredDocument.getParser());
        }
        if ((language = this.getLanguage(model)) != null && language.length() > 0) {
            pageDirectiveAdapter.setLanguage(language);
        }
    }

    private EmbeddedTypeHandler getEmbeddedType(IStructuredModel model) {
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getAdapterFor((Object)clazz);
        EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
        return embeddedHandler;
    }

    protected void initEmbeddedTypePre(IStructuredModel model) {
        IContentDescription desc;
        EmbeddedTypeHandler embeddedContentType = null;
        IDOMModel domModel = (IDOMModel)model;
        String possibleFileBaseLocation = model.getBaseLocation();
        if (embeddedContentType == null && (desc = this.getContentDescription(possibleFileBaseLocation)) != null) {
            Object prop = null;
            prop = desc.getProperty(IContentDescriptionForJSP.CONTENT_FAMILY_ATTRIBUTE);
            if (prop != null && ContentTypeFamilyForHTML.HTML_FAMILY.equals(prop)) {
                embeddedContentType = EmbeddedTypeRegistryImpl.getInstance().getTypeFor(DEFAULT_MIME_TYPE);
            }
            if (embeddedContentType == null && (prop = desc.getProperty(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE)) != null) {
                embeddedContentType = EmbeddedTypeRegistryImpl.getInstance().getTypeFor((String)prop);
            }
        }
        IDOMDocument document = domModel.getDocument();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)document.getAdapterFor((Object)clazz);
        if (embeddedContentType != null) {
            pageDirectiveAdapter.setEmbeddedType(embeddedContentType);
            embeddedContentType.initializeFactoryRegistry(model.getFactoryRegistry());
        } else {
            embeddedContentType = this.getJSPDefaultEmbeddedType(model);
            pageDirectiveAdapter.setEmbeddedType(embeddedContentType);
            embeddedContentType.initializeFactoryRegistry(model.getFactoryRegistry());
        }
    }

    protected void initEmbeddedTypePost(IStructuredModel model) {
        this.setLanguageInPageDirective(model);
    }

    protected void initEmbeddedType(IStructuredModel oldModel, IStructuredModel newModel) {
        EmbeddedTypeHandler existingEmbeddedType = this.getEmbeddedType(oldModel);
        EmbeddedTypeHandler newEmbeddedContentType = existingEmbeddedType.newInstance();
        if (existingEmbeddedType == null) {
            this.initEmbeddedTypePre(newModel);
            this.initEmbeddedTypePost(newModel);
        } else {
            this.initCloneOfEmbeddedType(newModel, existingEmbeddedType, newEmbeddedContentType);
            this.setLanguageInPageDirective(newModel);
        }
    }

    protected void setLanguageInPageDirective(IStructuredModel newModel) {
        if (newModel instanceof IDOMModel) {
            IDOMDocument document = ((IDOMModel)newModel).getDocument();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)document.getAdapterFor((Object)clazz);
            String language = this.getLanguage(newModel);
            pageDirectiveAdapter.setLanguage(language);
        }
    }

    public IStructuredModel reinitialize(IStructuredModel model) {
        EmbeddedTypeHandler oldHandler = null;
        EmbeddedTypeHandler newHandler = null;
        Object reinitStateData = model.getReinitializeStateData();
        if (reinitStateData instanceof EmbeddedTypeStateData) {
            EmbeddedTypeStateData oldStateData = (EmbeddedTypeStateData)reinitStateData;
            oldHandler = oldStateData.getOldHandler();
            newHandler = oldStateData.getNewHandler();
            this.reInitializeEmbeddedType(model, oldHandler, newHandler);
        }
        return super.reinitialize(model);
    }

    public IModelLoader newInstance() {
        return new JSPModelLoader();
    }

    public IDocumentLoader getDocumentLoader() {
        if (this.documentLoaderInstance == null) {
            this.documentLoaderInstance = new JSPDocumentLoader();
        }
        return this.documentLoaderInstance;
    }

    public static InputStream getMarkSupportedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original.markSupported()) {
            return original;
        }
        return new BufferedInputStream(original);
    }

    protected byte[] getBytes(InputStream inputStream, int max) throws IOException {
        byte[] smallBuffer = new byte[max];
        byte[] returnBuffer = null;
        int nRead = inputStream.read(smallBuffer, 0, max);
        if (nRead < max) {
            if (nRead < 0) {
                nRead = 0;
            }
            byte[] smallerBuffer = new byte[nRead];
            System.arraycopy(smallBuffer, 0, smallerBuffer, 0, nRead);
            returnBuffer = smallerBuffer;
        } else {
            returnBuffer = smallBuffer;
        }
        return returnBuffer;
    }

    public IStructuredModel createModel(IStructuredModel oldModel) {
        IStructuredModel model = super.createModel(oldModel);
        ModelQueryAdapter modelQueryAdapter = this.getModelQueryAdapter(model);
        if (modelQueryAdapter == null) {
            modelQueryAdapter = this.getModelQueryAdapter(oldModel);
            IDOMDocument document = ((IDOMModel)model).getDocument();
            document.addAdapter((INodeAdapter)new JSPModelQueryAdapterImpl(modelQueryAdapter.getCMDocumentCache(), modelQueryAdapter.getModelQuery(), modelQueryAdapter.getIdResolver()));
        }
        return model;
    }

    private ModelQueryAdapter getModelQueryAdapter(IStructuredModel model) {
        IDOMDocument document = ((IDOMModel)model).getDocument();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModelQueryAdapter modelQueryAdapter = (ModelQueryAdapter)document.getAdapterFor((Object)clazz);
        return modelQueryAdapter;
    }
}

