/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.taglib;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.servlet.jsp.tagext.VariableInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDAttributeDeclaration;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDVariable;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibClassLoader;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibVariable;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;

public class TaglibHelper {
    private static final boolean DEBUG;
    private IProject fProject = null;
    private TaglibClassLoader fLoader = null;
    private Collection fValidationMessages = null;
    private Set fProjectEntries = null;
    private Set fContainerEntries = null;
    static /* synthetic */ Class class$0;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/taglibvars");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public TaglibHelper(IProject project) {
        this.setProject(project);
        this.fProjectEntries = new HashSet();
        this.fContainerEntries = new HashSet();
        this.fValidationMessages = new HashSet();
    }

    public TaglibVariable[] getTaglibVariables(String tagToAdd, IStructuredDocument structuredDoc, IStructuredDocumentRegion customTag) {
        ArrayList results = new ArrayList();
        this.fValidationMessages.clear();
        ModelQuery mq = this.getModelQuery((IDocument)structuredDoc);
        if (mq != null) {
            TLDCMDocumentManager mgr = TaglibController.getTLDCMDocumentManager((IDocument)structuredDoc);
            if (mgr == null) {
                return new TaglibVariable[0];
            }
            List trackers = mgr.getCMDocumentTrackers(-1);
            Iterator taglibs = trackers.iterator();
            CMDocument doc = null;
            CMNamedNodeMap elements = null;
            while (taglibs.hasNext()) {
                doc = (CMDocument)taglibs.next();
                CMNode node = null;
                elements = doc.getElements();
                if (elements == null || (node = elements.getNamedItem(tagToAdd)) == null || node.getNodeType() != 5) continue;
                if (node instanceof CMNodeWrapper) {
                    node = ((CMNodeWrapper)node).getOriginNode();
                }
                this.addVariables(results, node, customTag);
                if (!(doc instanceof TaglibTracker)) continue;
                String uri = ((TaglibTracker)doc).getURI();
                String prefix = ((TaglibTracker)doc).getPrefix();
                this.addTEIVariables(customTag, results, (TLDElementDeclaration)node, prefix, uri);
            }
        }
        return results.toArray(new TaglibVariable[results.size()]);
    }

    private void addVariables(List results, CMNode node, IStructuredDocumentRegion customTag) {
        List list = ((TLDElementDeclaration)node).getVariables();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TLDVariable var = (TLDVariable)it.next();
            if (!var.getDeclare()) continue;
            String varName = var.getNameGiven();
            if (varName == null) {
                varName = var.getAlias();
            }
            if (varName == null) {
                String attrName = var.getNameFromAttribute();
                ITextRegionList regions = customTag.getRegions();
                boolean attrNameFound = false;
                int i = 2;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if ("XML_TAG_ATTRIBUTE_NAME".equals(region.getType())) {
                        attrNameFound = attrName.equals(customTag.getText(region));
                    }
                    if (attrNameFound && "XML_TAG_ATTRIBUTE_VALUE".equals(region.getType())) {
                        varName = StringUtils.strip((String)customTag.getText(region));
                    }
                    ++i;
                }
            }
            if (varName == null) continue;
            String varClass = "java.lang.String";
            if (var.getVariableClass() != null) {
                varClass = var.getVariableClass();
            }
            results.add(new TaglibVariable(varClass, varName, var.getScope(), var.getDescription()));
        }
    }

    private void addTEIVariables(IStructuredDocumentRegion customTag, List results, TLDElementDeclaration decl, String prefix, String uri) {
        block22: {
            String teiClassname = decl.getTeiclass();
            if (teiClassname == null || teiClassname.length() == 0) {
                return;
            }
            TaglibClassLoader loader = this.getClassloader();
            Class<?> teiClass = null;
            try {
                teiClass = Class.forName(teiClassname, true, loader);
                if (teiClass == null) break block22;
                Object teiObject = teiClass.newInstance();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.servlet.jsp.tagext.TagExtraInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isInstance(teiObject)) {
                    TagExtraInfo tei = (TagExtraInfo)teiObject;
                    Hashtable tagDataTable = this.extractTagData(customTag);
                    TagInfo info = this.getTagInfo(decl, tei, prefix, uri);
                    if (info != null) {
                        VariableInfo[] vInfos;
                        int i;
                        tei.setTagInfo(info);
                        TagData td = new TagData(tagDataTable);
                        if (!tei.isValid(td)) {
                            ValidationMessage[] messages = tei.validate(td);
                            i = 0;
                            while (i < messages.length) {
                                this.fValidationMessages.add(messages[i]);
                                ++i;
                            }
                        }
                        if ((vInfos = tei.getVariableInfo(td)) != null) {
                            i = 0;
                            while (i < vInfos.length) {
                                results.add(new TaglibVariable(vInfos[i].getClassName(), vInfos[i].getVarName(), vInfos[i].getScope(), decl.getDescription()));
                                ++i;
                            }
                        }
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (InstantiationException e) {
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (IllegalAccessException e) {
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (ClassCastException e) {
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (Exception e) {
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (Error e) {
                if (!DEBUG) break block22;
                this.logException(teiClassname, e);
            }
        }
    }

    private TagInfo getTagInfo(TLDElementDeclaration decl, TagExtraInfo tei, String prefix, String uri) {
        TagLibraryInfo libInfo = new TagLibraryInfo(prefix, uri){};
        CMNamedNodeMap attrs = decl.getAttributes();
        TagAttributeInfo[] attrInfos = new TagAttributeInfo[attrs.getLength()];
        TLDAttributeDeclaration attr = null;
        String type = "";
        int i = 0;
        while (i < attrs.getLength()) {
            attr = (TLDAttributeDeclaration)attrs.item(i);
            type = attr.getType();
            if (attr.getType() == null || attr.getType().equals("")) {
                type = "java.lang.String";
            }
            attrInfos[i] = new TagAttributeInfo(attr.getAttrName(), attr.isRequired(), type, false);
            ++i;
        }
        String tagName = decl.getNodeName();
        String tagClass = decl.getTagclass();
        String bodyContent = decl.getBodycontent();
        if (tagName != null && tagClass != null && bodyContent != null) {
            return new TagInfo(tagName, tagClass, bodyContent, decl.getInfo(), libInfo, tei, attrInfos);
        }
        return null;
    }

    private void logException(String teiClassname, Throwable e) {
        String message = "teiClassname: [";
        if (teiClassname != null) {
            message = String.valueOf(message) + teiClassname;
        }
        message = String.valueOf(message) + "]";
        Logger.logException(message, e);
    }

    private Hashtable extractTagData(IStructuredDocumentRegion customTag) {
        Hashtable<String, String> tagDataTable = new Hashtable<String, String>();
        ITextRegionList regions = customTag.getRegions();
        ITextRegion r = null;
        String attrName = "";
        String attrValue = "";
        int i = 0;
        while (i < regions.size()) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                attrName = customTag.getText(r);
                if (regions.size() > ++i && (r = regions.get(i)).getType() == "XML_TAG_ATTRIBUTE_EQUALS" && regions.size() > ++i && (r = regions.get(i)).getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    r = regions.get(i);
                    attrValue = StringUtils.stripQuotes((String)customTag.getText(r));
                    tagDataTable.put(attrName, attrValue);
                }
            }
            ++i;
        }
        return tagDataTable;
    }

    private TaglibClassLoader getClassloader() {
        if (this.fLoader == null) {
            this.fLoader = new TaglibClassLoader(this.getClass().getClassLoader());
            this.fProjectEntries.clear();
            this.fContainerEntries.clear();
            this.addClasspathEntriesForProject(this.getProject(), this.fLoader);
        }
        return this.fLoader;
    }

    private void addClasspathEntriesForProject(IProject p, TaglibClassLoader loader) {
        if (!p.isAccessible() || this.fProjectEntries.contains(p.getFullPath().toString())) {
            return;
        }
        this.fProjectEntries.add(p.getFullPath().toString());
        try {
            if (p.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject project = JavaCore.create((IProject)p);
                try {
                    IClasspathEntry[] entries = project.getRawClasspath();
                    this.addDefaultDirEntry(loader, project);
                    this.addClasspathEntries(loader, project, entries);
                }
                catch (JavaModelException e) {
                    Logger.logException(e);
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    private void addClasspathEntries(TaglibClassLoader loader, IJavaProject project, IClasspathEntry[] entries) throws JavaModelException {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (DEBUG) {
                System.out.println("current entry is: " + entry);
            }
            switch (entry.getEntryKind()) {
                case 3: {
                    this.addSourceEntry(loader, entry);
                    break;
                }
                case 1: {
                    this.addLibraryEntry(loader, entry.getPath());
                    break;
                }
                case 2: {
                    this.addProjectEntry(loader, entry);
                    break;
                }
                case 4: {
                    this.addVariableEntry(loader, entry);
                    break;
                }
                case 5: {
                    this.addContainerEntry(loader, project, entry);
                }
            }
            ++i;
        }
    }

    private void addVariableEntry(TaglibClassLoader loader, IClasspathEntry entry) {
        if (DEBUG) {
            System.out.println(" -> adding variable entry: [" + entry + "]");
        }
        String variableName = entry.getPath().toString();
        IPath variablePath = JavaCore.getResolvedVariablePath((IPath)entry.getPath());
        variablePath = JavaCore.getClasspathVariable((String)variableName);
        if (variablePath != null) {
            IProject varProj;
            if (variablePath.segments().length == 1 && (varProj = ResourcesPlugin.getWorkspace().getRoot().getProject(variablePath.toString())) != null && varProj.exists()) {
                this.addClasspathEntriesForProject(varProj, loader);
                return;
            }
            this.addLibraryEntry(loader, variablePath);
        }
    }

    private void addContainerEntry(TaglibClassLoader loader, IJavaProject project, IClasspathEntry entry) throws JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
        if (container != null && !this.fContainerEntries.contains(container.getPath().toString())) {
            this.fContainerEntries.add(container.getPath().toString());
            IClasspathEntry[] cpes = container.getClasspathEntries();
            this.addClasspathEntries(loader, project, cpes);
        }
    }

    private void addProjectEntry(TaglibClassLoader loader, IClasspathEntry entry) {
        if (DEBUG) {
            System.out.println(" -> project entry: [" + entry + "]");
        }
        IPath path = entry.getPath();
        IProject referenceProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        if (referenceProject != null && referenceProject.isAccessible()) {
            this.addClasspathEntriesForProject(referenceProject, loader);
        }
    }

    private void addDefaultDirEntry(TaglibClassLoader loader, IJavaProject project) throws JavaModelException {
        IPath outputPath = project.getOutputLocation();
        String outputLocation = null;
        if (!outputPath.toFile().exists()) {
            if (outputPath.segmentCount() > 1) {
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath);
                if (folder.getLocation() != null) {
                    outputLocation = folder.getLocation().toString();
                }
            } else {
                IProject iproject = ResourcesPlugin.getWorkspace().getRoot().getProject(outputPath.segment(0));
                if (iproject.getLocation() != null) {
                    outputLocation = iproject.getLocation().toString();
                }
            }
        } else {
            outputLocation = outputPath.toString();
        }
        loader.addDirectory(outputLocation);
    }

    private void addLibraryEntry(TaglibClassLoader loader, IPath libPath) {
        IFile jarFile;
        String jarPathString = libPath.toString();
        File file = new File(libPath.toOSString());
        if (!file.exists() && libPath.segmentCount() > 1 && (jarFile = ResourcesPlugin.getWorkspace().getRoot().getFile(libPath)).isAccessible() && jarFile.getLocation() != null) {
            jarPathString = jarFile.getLocation().toString();
        }
        if (jarPathString != null) {
            if (jarPathString.endsWith(".jar")) {
                loader.addJar(jarPathString);
            } else if (file.isDirectory()) {
                loader.addDirectory(jarPathString);
            }
        }
    }

    private void addSourceEntry(TaglibClassLoader loader, IClasspathEntry entry) {
        IFolder folder;
        IPath outputLocation = entry.getOutputLocation();
        if (outputLocation != null && outputLocation.segmentCount() > 1 && (folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation)) != null && folder.isAccessible()) {
            outputLocation = folder.getLocation();
            loader.addDirectory(outputLocation.toString());
        }
    }

    /*
     * Exception decompiling
     */
    public ModelQuery getModelQuery(IDocument doc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 44->47)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject p) {
        this.fProject = p;
    }

    Collection getValidationMessages() {
        return this.fValidationMessages;
    }
}

