/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPDirectiveValidator
extends JSPValidator {
    private static Collator collator = Collator.getInstance((Locale)Locale.US);
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator"));
    private IValidator fMessageOriginator;
    private HashMap fPrefixValueRegionToDocumentRegionMap = new HashMap();
    private HashMap fReservedPrefixes = new HashMap();
    private int fSeverityIncludeFileMissing = 2;
    private int fSeverityIncludeFileNotSpecified = 2;
    private int fSeverityTaglibDuplicatePrefixWithDifferentURIs = 2;
    private int fSeverityTaglibDuplicatePrefixWithSameURIs = 4;
    private int fSeverityTaglibMissingPrefix = 1;
    private int fSeverityTaglibMissingURI = 1;
    private int fSeverityTaglibUnresolvableURI = 1;
    private HashMap fTaglibPrefixesInUse = new HashMap();
    private final int NO_SEVERITY = -1;

    public JSPDirectiveValidator() {
        this.initReservedPrefixes();
        this.fMessageOriginator = this;
    }

    public JSPDirectiveValidator(IValidator validator) {
        this.initReservedPrefixes();
        this.fMessageOriginator = validator;
    }

    public void cleanup(IReporter reporter) {
        super.cleanup(reporter);
        this.fTaglibPrefixesInUse.clear();
        this.fPrefixValueRegionToDocumentRegionMap.clear();
    }

    private void collectTaglibPrefix(IStructuredDocumentRegion documentRegion, ITextRegion valueRegion, String taglibPrefix) {
        this.fPrefixValueRegionToDocumentRegionMap.put(valueRegion, documentRegion);
        Object o = this.fTaglibPrefixesInUse.get(taglibPrefix);
        if (o == null) {
            this.fTaglibPrefixesInUse.put(taglibPrefix, valueRegion);
        } else {
            ArrayList<Object> regionList = null;
            if (o instanceof List) {
                regionList = (ArrayList<Object>)o;
            } else {
                regionList = new ArrayList<Object>();
                regionList.add(o);
                this.fTaglibPrefixesInUse.put(taglibPrefix, regionList);
            }
            regionList.add(valueRegion);
        }
    }

    private void initReservedPrefixes() {
        this.fReservedPrefixes.put("jsp", "");
        this.fReservedPrefixes.put("jspx", "");
        this.fReservedPrefixes.put("java", "");
        this.fReservedPrefixes.put("javax", "");
        this.fReservedPrefixes.put("servlet", "");
        this.fReservedPrefixes.put("sun", "");
        this.fReservedPrefixes.put("sunw", "");
    }

    private boolean isReservedTaglibPrefix(String name) {
        return this.fReservedPrefixes.get(name) != null;
    }

    protected void performValidation(IFile f, IReporter reporter, IStructuredDocument sDoc) {
        this.fPrefixValueRegionToDocumentRegionMap.clear();
        this.fTaglibPrefixesInUse.clear();
        IStructuredDocumentRegion region = sDoc.getFirstStructuredDocumentRegion();
        while (region != null && !reporter.isCancelled()) {
            if (region.getType() == "JSP_DIRECTIVE_NAME") {
                this.processDirective(reporter, f, sDoc, region);
            }
            region = region.getNext();
        }
        if (!reporter.isCancelled()) {
            this.reportTaglibDuplicatePrefixes(f, reporter, sDoc);
        }
        this.fPrefixValueRegionToDocumentRegionMap.clear();
        this.fTaglibPrefixesInUse.clear();
    }

    private void processDirective(IReporter reporter, IFile file, IStructuredDocument sDoc, IStructuredDocumentRegion documentRegion) {
        String directiveName = this.getDirectiveName(documentRegion);
        if (directiveName.equals("taglib")) {
            this.processTaglibDirective(reporter, file, sDoc, documentRegion);
        } else if (directiveName.equals("include")) {
            this.processIncludeDirective(reporter, file, sDoc, documentRegion);
        }
    }

    private void processIncludeDirective(IReporter reporter, IFile file, IStructuredDocument sDoc, IStructuredDocumentRegion documentRegion) {
        ITextRegion fileValueRegion = this.getAttributeValueRegion(documentRegion, "file");
        if (fileValueRegion != null) {
            String fileValue = documentRegion.getText(fileValueRegion);
            if ((fileValue = StringUtils.stripQuotes((String)fileValue)).length() == 0 && this.fSeverityIncludeFileNotSpecified != -1) {
                String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"file");
                JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityIncludeFileNotSpecified, msgText, (IResource)file);
                int start = documentRegion.getStartOffset(fileValueRegion);
                int length = fileValueRegion.getTextLength();
                int lineNo = sDoc.getLineOfOffset(start);
                message.setLineNo(lineNo);
                message.setOffset(start);
                message.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message);
            } else if (this.fSeverityIncludeFileMissing != -1) {
                IPath testPath = FacetModuleCoreSupport.resolve(file.getFullPath(), fileValue);
                IFile testFile = file.getWorkspace().getRoot().getFile(testPath);
                if (!testFile.isAccessible()) {
                    String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_4, (Object[])new String[]{fileValue, testPath.toString()});
                    JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityIncludeFileMissing, msgText, (IResource)file);
                    int start = documentRegion.getStartOffset(fileValueRegion);
                    int length = fileValueRegion.getTextLength();
                    int lineNo = sDoc.getLineOfOffset(start);
                    message.setLineNo(lineNo);
                    message.setOffset(start);
                    message.setLength(length);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message);
                }
            }
        } else if (this.fSeverityIncludeFileNotSpecified != -1) {
            String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"file");
            JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityIncludeFileNotSpecified, msgText, (IResource)file);
            int start = documentRegion.getStartOffset();
            int length = documentRegion.getTextLength();
            int lineNo = sDoc.getLineOfOffset(start);
            message.setLineNo(lineNo);
            message.setOffset(start);
            message.setLength(length);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
    }

    private void processTaglibDirective(IReporter reporter, IFile file, IStructuredDocument sDoc, IStructuredDocumentRegion documentRegion) {
        int lineNo;
        JSPValidator.LocalizedMessage message;
        String msgText;
        int lineNo2;
        int length;
        String msgText2;
        int lineNo3;
        int length2;
        int start;
        JSPValidator.LocalizedMessage message2;
        ITextRegion prefixValueRegion = null;
        ITextRegion uriValueRegion = this.getAttributeValueRegion(documentRegion, "uri");
        ITextRegion tagdirValueRegion = this.getAttributeValueRegion(documentRegion, "tagdir");
        if (uriValueRegion != null) {
            String uri = documentRegion.getText(uriValueRegion);
            if (file != null) {
                if ((uri = StringUtils.stripQuotes((String)uri)).length() > 0) {
                    ITaglibRecord tld = TaglibIndex.resolve(file.getFullPath().toString(), uri, false);
                    if (tld == null && this.fSeverityTaglibUnresolvableURI != -1) {
                        String msgText3 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_1, (Object)uri);
                        message2 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibUnresolvableURI, msgText3, (IResource)file);
                        start = documentRegion.getStartOffset(uriValueRegion);
                        length2 = uriValueRegion.getTextLength();
                        lineNo3 = sDoc.getLineOfOffset(start);
                        message2.setLineNo(lineNo3);
                        message2.setOffset(start);
                        message2.setLength(length2);
                        reporter.addMessage(this.fMessageOriginator, (IMessage)message2);
                    }
                } else if (this.fSeverityTaglibMissingURI != -1) {
                    msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"uri");
                    JSPValidator.LocalizedMessage message3 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingURI, msgText2, (IResource)file);
                    int start2 = documentRegion.getStartOffset(uriValueRegion);
                    length = uriValueRegion.getTextLength();
                    lineNo2 = sDoc.getLineOfOffset(start2);
                    message3.setLineNo(lineNo2);
                    message3.setOffset(start2);
                    message3.setLength(length);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message3);
                }
            }
        } else if (tagdirValueRegion != null) {
            String tagdir = documentRegion.getText(tagdirValueRegion);
            if (file != null && (tagdir = StringUtils.stripQuotes((String)tagdir)).length() <= 0 && this.fSeverityTaglibMissingURI != -1) {
                msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"tagdir");
                JSPValidator.LocalizedMessage message4 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingURI, msgText2, (IResource)file);
                int start3 = documentRegion.getStartOffset(tagdirValueRegion);
                length = tagdirValueRegion.getTextLength();
                lineNo2 = sDoc.getLineOfOffset(start3);
                message4.setLineNo(lineNo2);
                message4.setOffset(start3);
                message4.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message4);
            }
        } else if (this.fSeverityTaglibMissingURI != -1) {
            msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"uri");
            message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingURI, msgText, (IResource)file);
            int start4 = documentRegion.getStartOffset();
            int length3 = documentRegion.getTextLength();
            lineNo = sDoc.getLineOfOffset(start4);
            message.setLineNo(lineNo);
            message.setOffset(start4);
            message.setLength(length3);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
        if ((prefixValueRegion = this.getAttributeValueRegion(documentRegion, "prefix")) != null) {
            String taglibPrefix = documentRegion.getText(prefixValueRegion);
            taglibPrefix = StringUtils.stripQuotes((String)taglibPrefix);
            this.collectTaglibPrefix(documentRegion, prefixValueRegion, taglibPrefix);
            if (this.isReservedTaglibPrefix(taglibPrefix)) {
                msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_0, (Object)taglibPrefix);
                int sev = 1;
                message2 = file == null ? new JSPValidator.LocalizedMessage(this, sev, msgText2) : new JSPValidator.LocalizedMessage((JSPValidator)this, sev, msgText2, (IResource)file);
                start = documentRegion.getStartOffset(prefixValueRegion);
                length2 = prefixValueRegion.getTextLength();
                lineNo3 = sDoc.getLineOfOffset(start);
                message2.setLineNo(lineNo3);
                message2.setOffset(start);
                message2.setLength(length2);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message2);
            }
            if (taglibPrefix.length() == 0 && this.fSeverityTaglibMissingPrefix != -1) {
                msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"prefix");
                JSPValidator.LocalizedMessage message5 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingPrefix, msgText2, (IResource)file);
                int start5 = documentRegion.getStartOffset(prefixValueRegion);
                length = prefixValueRegion.getTextLength();
                lineNo2 = sDoc.getLineOfOffset(start5);
                message5.setLineNo(lineNo2);
                message5.setOffset(start5);
                message5.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message5);
            }
        } else if (this.fSeverityTaglibMissingPrefix != -1) {
            msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"prefix");
            message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingPrefix, msgText, (IResource)file);
            int start6 = documentRegion.getStartOffset();
            int length4 = documentRegion.getTextLength();
            lineNo = sDoc.getLineOfOffset(start6);
            message.setLineNo(lineNo);
            message.setOffset(start6);
            message.setLength(length4);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
    }

    private void reportTaglibDuplicatePrefixes(IFile file, IReporter reporter, IStructuredDocument document) {
        if (this.fSeverityTaglibDuplicatePrefixWithDifferentURIs == -1 && this.fSeverityTaglibDuplicatePrefixWithSameURIs == -1) {
            return;
        }
        String[] prefixes = this.fTaglibPrefixesInUse.keySet().toArray(new String[0]);
        int prefixNumber = 0;
        while (prefixNumber < prefixes.length) {
            int severity = this.fSeverityTaglibDuplicatePrefixWithSameURIs;
            Object o = this.fTaglibPrefixesInUse.get(prefixes[prefixNumber]);
            if (o instanceof List) {
                List valueRegions = (List)o;
                String uri = null;
                int regionNumber = 0;
                while (regionNumber < valueRegions.size()) {
                    IStructuredDocumentRegion documentRegion = (IStructuredDocumentRegion)this.fPrefixValueRegionToDocumentRegionMap.get(valueRegions.get(regionNumber));
                    ITextRegion uriValueRegion = this.getAttributeValueRegion(documentRegion, "uri");
                    if (uriValueRegion == null) {
                        uriValueRegion = this.getAttributeValueRegion(documentRegion, "tagdir");
                    }
                    if (uriValueRegion != null) {
                        String uri2 = StringUtils.stripQuotes((String)documentRegion.getText(uriValueRegion));
                        if (uri == null) {
                            uri = uri2;
                        } else if (collator.compare(uri, uri2) != 0) {
                            severity = this.fSeverityTaglibDuplicatePrefixWithDifferentURIs;
                        }
                    }
                    ++regionNumber;
                }
                String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_2, (Object)prefixes[prefixNumber]);
                int regionNumber2 = 0;
                while (regionNumber2 < valueRegions.size()) {
                    ITextRegion valueRegion = (ITextRegion)valueRegions.get(regionNumber2);
                    IStructuredDocumentRegion documentRegion = (IStructuredDocumentRegion)this.fPrefixValueRegionToDocumentRegionMap.get(valueRegion);
                    JSPValidator.LocalizedMessage message = file == null ? new JSPValidator.LocalizedMessage(this, severity, msgText) : new JSPValidator.LocalizedMessage((JSPValidator)this, severity, msgText, (IResource)file);
                    int start = documentRegion.getStartOffset(valueRegion);
                    int length = valueRegion.getTextLength();
                    int lineNo = document.getLineOfOffset(start);
                    message.setLineNo(lineNo);
                    message.setOffset(start);
                    message.setLength(length);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message);
                    ++regionNumber2;
                }
            }
            ++prefixNumber;
        }
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        reporter.removeAllMessages((IValidator)this);
        super.validate(helper, reporter);
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 112->116)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

