/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.wsdltojava;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.common.wizards.AbstractScWizard;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.GeneralInfoPage;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.WsdlToJavaGenerateAction;
import org.eclipse.ui.IWorkbench;

public class GenerateCodeWizard
extends AbstractScWizard {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(GenerateCodeWizard.class);
    public static final String DATA_PROJECT = "DATA_PROJECT";
    public static final String DATA_GEN_PARAMS = "DATA_GEN_PARAMS";
    public static final String DATA_WSDL_FILE = "DATA_WSDL_FILE";
    public static final String DATA_NEW_BUILD_PATH = "DATA_NEW_BUILD_PATH";
    public static final String GENERAL_PAGE = "generalPage";
    GeneralInfoPage genPage;
    Object wsdlSrc = null;

    public GenerateCodeWizard() {
        String title = ScJaxWsResources.getString("WsdlToJava.GenerateCodeWizard.Title");
        this.setWindowTitle(title);
        ((HashMap)this.wizardData).put(DATA_PROJECT, ResourceUtils.getActiveProject());
        Hashtable genParams = new Hashtable();
        ((HashMap)this.wizardData).put(DATA_GEN_PARAMS, genParams);
    }

    public GenerateCodeWizard(StructuredSelection selection) {
        this();
        this.setSelection(selection);
    }

    public void setSelection(StructuredSelection selection) {
        if (selection != null) {
            ((HashMap)this.wizardData).put(DATA_WSDL_FILE, selection);
        }
    }

    public GenerateCodeWizard(IProject targetProject, StructuredSelection selection) {
        this(selection);
        ((HashMap)this.wizardData).put(DATA_PROJECT, targetProject);
    }

    public void addPages() {
        this.genPage = new GeneralInfoPage(this, GENERAL_PAGE, null);
        this.addPage((IWizardPage)this.genPage);
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        try {
            this.genPage.applyToData(this.genPage.getWizardData());
            IProject theProject = ResourceUtils.getActiveProject();
            WsdlToJavaGenerateAction action = new WsdlToJavaGenerateAction();
            IPath wsdlPath = ResourceUtils.getSelectedResource().getFullPath();
            IFile wsdlFile = theProject.getWorkspace().getRoot().getFile(wsdlPath);
            action.generate(wsdlFile.getRawLocation().toOSString(), theProject, this.wizardData.get(DATA_GEN_PARAMS));
            IPath[] nPaths = (IPath[])this.wizardData.get(DATA_NEW_BUILD_PATH);
            this.updateProjectSrcPaths(theProject, nPaths);
        }
        catch (Exception ce) {
            ce.printStackTrace();
            return false;
        }
        return true;
    }

    private void updateProjectSrcPaths(IProject project, IPath[] paths) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> allEntries = new ArrayList<IClasspathEntry>();
        try {
            int i;
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            if (entries != null) {
                i = 0;
                while (i < entries.length) {
                    allEntries.add(entries[i]);
                    ++i;
                }
            }
            if (paths != null) {
                i = 0;
                while (i < paths.length) {
                    IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)paths[i]);
                    allEntries.add(newEntry);
                    ++i;
                }
            }
            javaProject.setRawClasspath(allEntries.toArray(new IClasspathEntry[0]), null);
        }
        catch (JavaModelException e) {
            LOG.debug((Object)"Error updating source path for project.", (Throwable)e);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

